/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.geocluster.client.toast;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.sterner.geocluster.GeoclusterConfig;
import dev.sterner.geocluster.client.toast.IOreToast;
import dev.sterner.geocluster.client.toast.OreToast;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class OreToastManager
extends class_332 {
    private static final int SPACES = 5;
    final class_310 client;
    private final List<Entry<?>> visibleEntries = new ArrayList();
    private final BitSet occupiedSpaces = new BitSet(5);
    private final Deque<IOreToast> toastQueue = Queues.newArrayDeque();

    public OreToastManager(class_310 client) {
        this.client = client;
    }

    public void draw(class_4587 matrices) {
        if (!this.client.field_1690.field_1842) {
            int i = this.client.method_22683().method_4486();
            this.visibleEntries.removeIf(visibleEntry -> {
                if (visibleEntry != null) {
                    boolean bl = visibleEntry.draw(i, matrices);
                    if (bl) {
                        this.occupiedSpaces.clear(visibleEntry.topIndex, visibleEntry.topIndex + visibleEntry.requiredSpaceCount);
                        return true;
                    }
                } else {
                    return false;
                }
                return false;
            });
            if (!this.toastQueue.isEmpty() && this.getEmptySpaceCount() > 0) {
                this.toastQueue.removeIf(toast -> {
                    int k = toast.getRequiredSpaceCount();
                    int j = this.getTopIndex(k);
                    if (j != -1 && !this.findEntryByToast((IOreToast)toast)) {
                        Entry entry = new Entry(this, toast, j, k);
                        this.visibleEntries.add(entry);
                        this.occupiedSpaces.set(j, j + k);
                        return true;
                    }
                    return false;
                });
            }
        }
    }

    private boolean findEntryByToast(IOreToast toast) {
        boolean bl = false;
        for (Entry<?> entry : this.visibleEntries) {
            List<class_2680> storedStates;
            if (!(toast instanceof OreToast)) continue;
            OreToast oreToast = (OreToast)toast;
            IOreToast iOreToast = entry.getToast();
            if (!(iOreToast instanceof OreToast)) continue;
            OreToast storedToast = (OreToast)iOreToast;
            List<class_2680> states = oreToast.getStates();
            if (!OreToastManager.listsHaveSameElements(states, storedStates = storedToast.getStates())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private int getTopIndex(int requiredSpaces) {
        int i = 0;
        int emptySpaceCount = this.getEmptySpaceCount();
        for (int j = 0; j < 5; ++j) {
            int n = i = this.occupiedSpaces.get(j) ? 0 : i + 1;
            if (i != requiredSpaces || emptySpaceCount < requiredSpaces) continue;
            return j + 1 - i;
        }
        return -1;
    }

    public static <T> boolean listsHaveSameElements(List<T> list1, List<T> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        ArrayList<T> copiedList = new ArrayList<T>(list1);
        for (T element : list2) {
            if (copiedList.contains(element)) {
                copiedList.remove(element);
                continue;
            }
            return false;
        }
        return copiedList.isEmpty();
    }

    private int getEmptySpaceCount() {
        return 5 - this.occupiedSpaces.cardinality();
    }

    public void add(IOreToast toast) {
        if (!this.findEntryByToast(toast)) {
            this.toastQueue.add(toast);
        }
    }

    public class_310 getClient() {
        return this.client;
    }

    @Environment(value=EnvType.CLIENT)
    class Entry<T extends IOreToast> {
        private static final long DISAPPEAR_TIME = 600L;
        private final T instance;
        final int topIndex;
        final int requiredSpaceCount;
        private long startTime = -1L;
        private long showTime = -1L;
        private IOreToast.Visibility visibility = IOreToast.Visibility.SHOW;
        final /* synthetic */ OreToastManager this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        Entry(T instance, int topIndex, int requiredSpaceCount) {
            this.this$0 = (OreToastManager)this$0;
            this.instance = instance;
            this.topIndex = topIndex;
            this.requiredSpaceCount = requiredSpaceCount;
        }

        private float getDisappearProgress(long time) {
            float f = class_3532.method_15363((float)((float)(time - this.startTime) / 600.0f), (float)0.0f, (float)1.0f);
            f *= f;
            return this.visibility == IOreToast.Visibility.HIDE ? 1.0f - f : f;
        }

        public IOreToast getToast() {
            return this.instance;
        }

        public boolean draw(int x, class_4587 matrices) {
            long l = class_156.method_658();
            if (this.startTime == -1L) {
                this.startTime = l;
            }
            if (this.visibility == IOreToast.Visibility.SHOW && l - this.startTime <= 600L) {
                this.showTime = l;
            }
            class_4587 matrixStack = RenderSystem.getModelViewStack();
            matrixStack.method_22903();
            if (GeoclusterConfig.PROSPECTORS_POPUP_RIGHT) {
                matrixStack.method_22904((double)((float)x - (float)this.instance.getWidth() * this.getDisappearProgress(l)), (double)(this.this$0.client.method_22683().method_4502() - 32 - this.topIndex * 24), 800.0);
            } else {
                matrixStack.method_22904((double)((float)(this.this$0.client.method_22683().method_4486() - x) + (float)this.instance.getWidth() * this.getDisappearProgress(l) - (float)this.instance.getWidth()), (double)(this.this$0.client.method_22683().method_4502() - 32 - this.topIndex * 24), 800.0);
            }
            RenderSystem.applyModelViewMatrix();
            IOreToast.Visibility visibility = this.instance.draw(matrices, this.this$0, l - this.showTime);
            matrixStack.method_22909();
            RenderSystem.applyModelViewMatrix();
            if (visibility != this.visibility) {
                this.startTime = l - (long)((int)((1.0f - this.getDisappearProgress(l)) * 600.0f));
                this.visibility = visibility;
            }
            return this.visibility == IOreToast.Visibility.HIDE && l - this.startTime > 600L;
        }
    }
}

