/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.geocluster.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.sterner.geocluster.Geocluster;
import dev.sterner.geocluster.GeoclusterConfig;
import dev.sterner.geocluster.api.DepositCache;
import dev.sterner.geocluster.api.deposits.DenseDeposit;
import dev.sterner.geocluster.api.deposits.DikeDeposit;
import dev.sterner.geocluster.api.deposits.LayerDeposit;
import dev.sterner.geocluster.api.deposits.SparseDeposit;
import dev.sterner.geocluster.api.deposits.TopLayerDeposit;
import dev.sterner.geocluster.common.data.serializer.DenseDepositSerializer;
import dev.sterner.geocluster.common.data.serializer.DikeDepositSerializer;
import dev.sterner.geocluster.common.data.serializer.LayerDepositSerializer;
import dev.sterner.geocluster.common.data.serializer.SparseDepositSerializer;
import dev.sterner.geocluster.common.data.serializer.TopLayerDepositSerializer;
import dev.sterner.geocluster.common.utils.ProspectingUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class WorldGenDataReloadListener
extends class_4309
implements IdentifiableResourceReloadListener {
    private final List<String> MODDED = new ArrayList<String>();
    private static final Gson GSON = new GsonBuilder().create();
    private final DenseDepositSerializer DenseSerializer = new DenseDepositSerializer();
    private final LayerDepositSerializer LayerSerializer = new LayerDepositSerializer();
    private final TopLayerDepositSerializer TopLayerSerializer = new TopLayerDepositSerializer();
    private final DikeDepositSerializer DikeSerializer = new DikeDepositSerializer();
    private final SparseDepositSerializer SparseSerializer = new SparseDepositSerializer();

    public WorldGenDataReloadListener() {
        super(GSON, "deposits");
        this.MODDED.add("aluminium");
        this.MODDED.add("lead_silver");
        this.MODDED.add("platinum");
        this.MODDED.add("tin");
        this.MODDED.add("titanium");
        this.MODDED.add("uranium");
        this.MODDED.add("zinc");
        this.MODDED.add("iron_nickel");
    }

    public class_2960 getFabricId() {
        return Geocluster.id("deposits");
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        DepositCache cache = DepositCache.getCache();
        cache.clear();
        prepared.forEach((identifier, json) -> {
            if (GeoclusterConfig.ONLY_VANILLA_ORES && this.MODDED.contains(identifier.method_12832())) {
                return;
            }
            try {
                JsonObject jsonobject = json.getAsJsonObject();
                JsonObject config = jsonobject.get("config").getAsJsonObject();
                Geocluster.LOGGER.info("Preparing to load deposit datafile {}", (Object)identifier.toString());
                switch (jsonobject.get("type").getAsString()) {
                    case "geocluster:deposit_dense": {
                        DenseDeposit denseDeposit = this.DenseSerializer.deserialize(config);
                        if (denseDeposit != null) {
                            Geocluster.LOGGER.info(denseDeposit.toString());
                            cache.addDeposit(denseDeposit);
                        }
                        break;
                    }
                    case "geocluster:deposit_layer": {
                        LayerDeposit layerDeposit = this.LayerSerializer.deserialize(config);
                        if (layerDeposit != null) {
                            Geocluster.LOGGER.info(layerDeposit.toString());
                            cache.addDeposit(layerDeposit);
                        }
                        break;
                    }
                    case "geocluster:deposit_top_layer": {
                        TopLayerDeposit topLayerDeposit = this.TopLayerSerializer.deserialize(config);
                        if (topLayerDeposit != null) {
                            Geocluster.LOGGER.info(topLayerDeposit.toString());
                            cache.addDeposit(topLayerDeposit);
                        }
                        break;
                    }
                    case "geocluster:deposit_dike": {
                        DikeDeposit dikeDeposit = this.DikeSerializer.deserialize(config);
                        if (dikeDeposit != null) {
                            Geocluster.LOGGER.info(dikeDeposit.toString());
                            cache.addDeposit(dikeDeposit);
                        }
                        break;
                    }
                    case "geocluster:deposit_sparse": {
                        SparseDeposit sparseDeposit = this.SparseSerializer.deserialize(config);
                        if (sparseDeposit != null) {
                            Geocluster.LOGGER.info(sparseDeposit.toString());
                            cache.addDeposit(sparseDeposit);
                        }
                        break;
                    }
                    default: {
                        Geocluster.LOGGER.warn("Unknown JSON type. Received JSON {}", json);
                    }
                }
            }
            catch (NullPointerException ex) {
                Geocluster.LOGGER.info("Skipping registration of ore {}", identifier);
            }
        });
        ProspectingUtils.populateDepositBlocks();
    }
}

