/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.geocluster.common.items;

import dev.sterner.geocluster.Geocluster;
import dev.sterner.geocluster.GeoclusterConfig;
import dev.sterner.geocluster.client.network.S2CProspectingPacket;
import dev.sterner.geocluster.common.utils.GeoclusterUtils;
import dev.sterner.geocluster.common.utils.ProspectingUtils;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ProspectorsPickItem
extends class_1792 {
    public static class_1792.class_1793 props = new class_1792.class_1793().method_7889(1).method_7892(Geocluster.GROUP).method_7895(1024);

    public ProspectorsPickItem() {
        super(props);
    }

    public class_1269 method_7884(class_1838 context) {
        int yStart;
        int xEnd;
        int xStart;
        int zEnd;
        int zStart;
        class_1657 player = context.method_8036();
        class_1268 hand = context.method_20287();
        class_1937 worldIn = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 facing = context.method_8038();
        if (player == null) {
            return class_1269.field_5811;
        }
        if (player.method_5715()) {
            return class_1269.field_21466;
        }
        class_1799 stack = player.method_5998(hand);
        if (worldIn.field_9236) {
            player.method_6104(hand);
            return class_1269.field_21466;
        }
        if (!player.method_7337()) {
            stack.method_7956(1, (class_1309)player, x -> x.method_20236(hand));
        }
        int range = GeoclusterConfig.PROSPECTORS_PICK_RANGE;
        int diam = GeoclusterConfig.PROSPECTORS_PICK_DIAMETER;
        int n = facing == class_2350.field_11043 ? 0 : (zStart = facing == class_2350.field_11035 ? -range : -(diam / 2));
        int n2 = facing == class_2350.field_11043 ? range : (zEnd = facing == class_2350.field_11035 ? 0 : diam / 2);
        int n3 = facing == class_2350.field_11034 ? -range : (xStart = facing == class_2350.field_11039 ? 0 : -(diam / 2));
        int n4 = facing == class_2350.field_11034 ? 0 : (xEnd = facing == class_2350.field_11039 ? range : diam / 2);
        int n5 = facing == class_2350.field_11036 ? -range : (yStart = facing == class_2350.field_11033 ? 0 : -(diam / 2));
        int yEnd = facing == class_2350.field_11036 ? 0 : (facing == class_2350.field_11033 ? range : diam / 2);
        this.prospect(player, stack, worldIn, pos, facing, xStart, xEnd, yStart, yEnd, zStart, zEnd);
        player.method_6104(hand);
        return class_1269.field_21466;
    }

    private void prospect(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, class_2350 facing, int xStart, int xEnd, int yStart, int yEnd, int zStart, int zEnd) {
        HashSet<class_2680> foundBlocks = new HashSet<class_2680>();
        HashSet<class_2338> foundBlockPos = new HashSet<class_2338>();
        HashSet<class_2680> depositBlocks = ProspectingUtils.getDepositBlocks();
        for (int x = xStart; x <= xEnd; ++x) {
            for (int y = yStart; y <= yEnd; ++y) {
                for (int z = zStart; z <= zEnd; ++z) {
                    class_2338 tmpPos = pos.method_10069(x, y, z);
                    class_2680 state = world.method_8320(tmpPos);
                    if (!depositBlocks.contains(state) || !ProspectingUtils.canDetect(state)) continue;
                    foundBlocks.add(state);
                    foundBlockPos.add(tmpPos);
                }
            }
        }
        Optional optional = foundBlockPos.stream().findAny();
        if (!foundBlocks.isEmpty()) {
            S2CProspectingPacket.send(player, foundBlocks, facing.method_10153().method_10151());
            optional.ifPresent(blockPos -> world.method_8396(null, blockPos, class_3417.field_14785, class_3419.field_15248, 0.15f, 2.0f));
            return;
        }
        if (!GeoclusterConfig.DISABLE_IN_AREA_MESSAGE) {
            this.prospectChunk(world, pos, player);
        }
    }

    private void prospectChunk(class_1937 world, class_2338 pos, class_1657 player) {
        HashSet<class_2680> foundBlocks = new HashSet<class_2680>();
        HashSet<class_2680> depositBlocks = ProspectingUtils.getDepositBlocks();
        class_1923 tempPos = new class_1923(pos);
        for (int x = tempPos.method_8326(); x <= tempPos.method_8327(); ++x) {
            for (int z = tempPos.method_8328(); z <= tempPos.method_8329(); ++z) {
                for (int y = world.method_31607(); y < world.method_31600(); ++y) {
                    class_2680 state = world.method_8320(new class_2338(x, y, z));
                    if (!depositBlocks.contains(state) || !ProspectingUtils.canDetect(state)) continue;
                    foundBlocks.add(state);
                }
            }
        }
        if (!foundBlocks.isEmpty()) {
            S2CProspectingPacket.send(player, foundBlocks, "");
            return;
        }
        player.method_7353((class_2561)GeoclusterUtils.tryTranslate("geocluster.pro_pick.tooltip.nonefound_surface", new Object[0]), true);
    }
}

