/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.geocluster.common.registry;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import dev.sterner.geocluster.Geocluster;
import dev.sterner.geocluster.common.registry.GeoclusterTagRegistry;
import dev.sterner.geocluster.common.world.feature.DepositFeature;
import dev.sterner.geocluster.mixin.BiomeModificationContextImplMixin;
import java.util.List;
import net.fabricmc.fabric.api.biome.v1.BiomeModification;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5843;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6803;
import net.minecraft.class_6817;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public interface GeoclusterWorldgenRegistry {
    public static final List<class_6797> placement = Lists.newArrayList((Object[])new class_6797[]{class_6795.method_39634((class_5843)class_5843.method_33841((int)-64), (class_5843)class_5843.method_33841((int)320))});
    public static final class_3031<class_3111> DEPOSIT_FEATURE = GeoclusterWorldgenRegistry.registerFeature("deposits", new DepositFeature((Codec<class_3111>)class_3111.field_24893));
    public static final class_6880<class_2975<class_3111, ?>> CONFIGURED_DEPOSIT_FEATURE = GeoclusterWorldgenRegistry.registerConfigured("deposits_configured", DEPOSIT_FEATURE);
    public static final class_6880<class_6796> PLACED_DEPOSIT_FEATURE = class_6817.method_39737((String)"geocluster:deposits_placed", CONFIGURED_DEPOSIT_FEATURE, placement);

    public static void init() {
        BiomeModification modifications = BiomeModifications.create((class_2960)Geocluster.id("worldgen"));
        modifications.add(ModificationPhase.REMOVALS, BiomeSelectors.all(), ctx -> {
            Iterable<class_6880<class_6796>> registryEntries = GeoclusterWorldgenRegistry.getPlacedFeaturesByTag(ctx, GeoclusterTagRegistry.ORES_TO_REMOVE);
            for (class_6880<class_6796> placedFeatureHolder : registryEntries) {
                if (!placedFeatureHolder.method_40230().isPresent()) continue;
                ctx.getGenerationSettings().removeFeature((class_5321)placedFeatureHolder.method_40230().get());
            }
        });
        modifications.add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13176, (class_5321)PLACED_DEPOSIT_FEATURE.method_40230().get()));
    }

    private static Iterable<class_6880<class_6796>> getPlacedFeaturesByTag(BiomeModificationContext ctx, class_6862<class_6796> placedFeatureTagKey) {
        class_5455 dynamicRegistryManager = ((BiomeModificationContextImplMixin)ctx).getRegistries();
        class_2378 placedFeatureRegistry = dynamicRegistryManager.method_30530(class_2378.field_35758);
        return placedFeatureRegistry.method_40286(placedFeatureTagKey);
    }

    public static <C extends class_3037, F extends class_3031<C>> F registerFeature(String id, F feature) {
        return (F)((class_3031)class_2378.method_10226((class_2378)class_2378.field_11138, (String)id, feature));
    }

    public static class_6880<class_2975<class_3111, ?>> registerConfigured(String id, class_3031<class_3111> feature) {
        return class_6803.method_40364((String)Geocluster.id(id).toString(), feature);
    }

    public static class_5321<class_6796> placedFeature(class_2960 id) {
        return class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)id);
    }
}

