/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.geocluster.common.utils;

import dev.sterner.geocluster.Geocluster;
import dev.sterner.geocluster.GeoclusterConfig;
import dev.sterner.geocluster.api.DepositCache;
import java.util.HashSet;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class ProspectingUtils {
    private static HashSet<class_2680> depositBlocks;
    private static HashSet<class_2680> detectionBlacklist;

    public static HashSet<class_2680> getDepositBlocks() {
        if (depositBlocks == null) {
            depositBlocks = new HashSet();
            ProspectingUtils.populateDepositBlocks();
        }
        return depositBlocks;
    }

    public static void populateDepositBlocks() {
        depositBlocks = new HashSet();
        DepositCache cache = DepositCache.getCache();
        cache.getOres().forEach(cluster -> {
            HashSet<class_2680> ores = cluster.getAllOres();
            if (ores != null) {
                depositBlocks.addAll(ores);
            }
        });
    }

    public static HashSet<class_2680> getDetectionBlacklist() {
        if (detectionBlacklist == null) {
            detectionBlacklist = new HashSet();
            ProspectingUtils.populateDetectionBlacklist();
        }
        return detectionBlacklist;
    }

    public static void populateDetectionBlacklist() {
        detectionBlacklist = new HashSet();
        GeoclusterConfig.PROSPECTORS_PICK_DETECTION_BLACKLIST.forEach(s -> {
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(new class_2960(s));
            if (block != null) {
                detectionBlacklist.add(block.method_9564());
            } else {
                Geocluster.LOGGER.warn("The item {} in the proPickDetectionBlacklist config option was not valid", s);
            }
        });
    }

    public static boolean canDetect(class_2680 test) {
        return !ProspectingUtils.getDetectionBlacklist().contains(test.method_26204().method_9564());
    }
}

