/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.geocluster.common.utils;

import dev.sterner.geocluster.GeoclusterConfig;
import dev.sterner.geocluster.common.registry.GeoclusterTagRegistry;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_5281;
import org.jetbrains.annotations.Nullable;

public class SampleUtils {
    @Nullable
    public static class_2338 getSamplePosition(class_5281 level, class_1923 chunkPos, class_2338 pos) {
        return SampleUtils.getSamplePosition(level, chunkPos, -1, pos);
    }

    @Nullable
    public static class_2338 getSamplePosition(class_5281 worldAccess, class_1923 chunkPos, int spread, class_2338 pos) {
        if (!(worldAccess instanceof class_3233)) {
            return null;
        }
        class_3233 world = (class_3233)worldAccess;
        int usedSpread = Math.max(8, spread);
        int xCenter = (chunkPos.method_8326() + chunkPos.method_8327()) / 2;
        int zCenter = (chunkPos.method_8328() + chunkPos.method_8329()) / 2;
        int blockPosX = xCenter + worldAccess.method_8409().method_43048(usedSpread) * (worldAccess.method_8409().method_43056() ? 1 : -1);
        int blockPosZ = zCenter + worldAccess.method_8409().method_43048(usedSpread) * (worldAccess.method_8409().method_43056() ? 1 : -1);
        if (world.method_8597().comp_643()) {
            class_2338 searchPos = new class_2338(blockPosX, world.method_31605(), blockPosZ);
            while (searchPos.method_10264() > world.method_8597().comp_651()) {
                class_2680 blockToPlaceOn = world.method_8320(searchPos);
                if (class_2248.method_9501((class_265)blockToPlaceOn.method_26218((class_1922)world, searchPos), (class_2350)class_2350.field_11036)) {
                    if (!blockToPlaceOn.method_26164(GeoclusterTagRegistry.SUPPORTS_SAMPLE)) {
                        searchPos = searchPos.method_10074();
                        continue;
                    }
                    class_2338 actualPlacePos = searchPos.method_10084();
                    if (SampleUtils.canReplace((class_5281)world, actualPlacePos)) {
                        return actualPlacePos;
                    }
                }
                searchPos = searchPos.method_10074();
            }
        } else {
            class_2338 searchPos = new class_2338(blockPosX, worldAccess.method_8624(class_2902.class_2903.field_13195, blockPosX, blockPosZ), blockPosZ).method_10074();
            if (GeoclusterConfig.FORCE_DEEPSLATE_SAMPLE_CAVEGEN && pos.method_10264() < 10) {
                int forcedPosY = pos.method_10264();
                while (forcedPosY < searchPos.method_10264()) {
                    class_2338 forcedPos = new class_2338(pos.method_10263(), ++forcedPosY, pos.method_10260());
                    class_2338 result = SampleUtils.tryFind(world, forcedPos);
                    if (result == null) continue;
                    return result;
                }
            }
            return SampleUtils.tryFind(world, searchPos);
        }
        return null;
    }

    private static class_2338 tryFind(class_3233 world, class_2338 pos) {
        class_2338 actualPlacePos;
        class_2680 blockToPlaceOn = world.method_8320(pos);
        if (class_2248.method_9501((class_265)blockToPlaceOn.method_26218((class_1922)world, pos), (class_2350)class_2350.field_11036) && blockToPlaceOn.method_26164(GeoclusterTagRegistry.SUPPORTS_SAMPLE) && SampleUtils.canReplace((class_5281)world, actualPlacePos = pos.method_10084())) {
            return actualPlacePos;
        }
        return null;
    }

    public static boolean canReplace(class_5281 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return state.method_26207().method_15800() || state.method_26215();
    }

    public static boolean isInWater(class_5281 level, class_2338 pos) {
        return level.method_8320(pos).method_26204() == class_2246.field_10382;
    }

    public static boolean inNonWaterFluid(class_5281 level, class_2338 pos) {
        return level.method_8320(pos).method_26207().method_15797() && !SampleUtils.isInWater(level, pos);
    }
}

