/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.geocluster.common.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.sterner.geocluster.common.utils.GeoclusterUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializerUtils {
    @NotNull
    public static class_2680 fromString(@Nullable String string) {
        if (string == null) {
            return class_2246.field_10124.method_9564();
        }
        class_2960 r = new class_2960(string);
        return Objects.requireNonNull((class_2248)class_2378.field_11146.method_10223(r)).method_9564();
    }

    public static String[] toStringArray(JsonArray arr) {
        String[] ret = new String[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            ret[i] = arr.get(i).getAsString();
        }
        return ret;
    }

    public static HashSet<class_2680> toBlockStateList(JsonArray arr) {
        HashSet<class_2680> ret = new HashSet<class_2680>();
        for (String s : SerializerUtils.toStringArray(arr)) {
            ret.add(SerializerUtils.fromString(s));
        }
        return ret;
    }

    public static HashMap<class_2680, Float> buildMultiBlockMap(JsonArray arr) {
        HashMap<class_2680, Float> ret = new HashMap<class_2680, Float>();
        for (JsonElement j : arr) {
            JsonObject pair = j.getAsJsonObject();
            if (pair.get("block").isJsonNull()) {
                ret.put(null, Float.valueOf(pair.get("chance").getAsFloat()));
                continue;
            }
            ret.put(SerializerUtils.fromString(pair.get("block").getAsString()), Float.valueOf(pair.get("chance").getAsFloat()));
        }
        return ret;
    }

    public static JsonArray deconstructMultiBlockMap(HashMap<class_2680, Float> in) {
        JsonArray ret = new JsonArray();
        for (Map.Entry<class_2680, Float> e : in.entrySet()) {
            JsonObject obj = new JsonObject();
            obj.addProperty("block", GeoclusterUtils.getRegistryName(e.getKey().method_26204()));
            obj.addProperty("chance", (Number)e.getValue());
            ret.add((JsonElement)obj);
        }
        return ret;
    }

    public static HashMap<String, HashMap<class_2680, Float>> buildMultiBlockMatcherMap(JsonObject jsonObject) {
        HashMap<String, HashMap<class_2680, Float>> map = new HashMap<String, HashMap<class_2680, Float>>();
        jsonObject.keySet().forEach(key -> {
            HashMap<class_2680, Float> value = SerializerUtils.buildMultiBlockMap(jsonObject.get(key).getAsJsonArray());
            map.put((String)key, value);
        });
        return map;
    }

    public static JsonObject deconstructMultiBlockMatcherMap(HashMap<String, HashMap<class_2680, Float>> in) {
        JsonObject ret = new JsonObject();
        for (Map.Entry<String, HashMap<class_2680, Float>> i : in.entrySet()) {
            String key = i.getKey();
            JsonArray value = SerializerUtils.deconstructMultiBlockMap(i.getValue());
            ret.add(key, (JsonElement)value);
        }
        return ret;
    }
}

