/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.geocluster.common.world.feature;

import com.mojang.serialization.Codec;
import dev.sterner.geocluster.Geocluster;
import dev.sterner.geocluster.GeoclusterConfig;
import dev.sterner.geocluster.api.DepositCache;
import dev.sterner.geocluster.api.IDeposit;
import dev.sterner.geocluster.common.components.GeoclusterComponents;
import dev.sterner.geocluster.common.components.IWorldChunkComponent;
import dev.sterner.geocluster.common.components.IWorldDepositComponent;
import dev.sterner.geocluster.common.components.WorldChunkComponent;
import dev.sterner.geocluster.common.components.WorldDepositComponent;
import dev.sterner.geocluster.common.utils.FeatureUtils;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2897;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5821;

public class DepositFeature
extends class_3031<class_3111> {
    public DepositFeature(Codec<class_3111> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        if (context.method_33653() instanceof class_2897) {
            return false;
        }
        class_5281 world = context.method_33652();
        class_2338 pos = context.method_33655();
        WorldDepositComponent depositComponent = (WorldDepositComponent)GeoclusterComponents.DEPOSIT.get((Object)world.method_8410());
        WorldChunkComponent chunkComponent = (WorldChunkComponent)GeoclusterComponents.CHUNK.get((Object)world.method_8410());
        boolean placedCluster = false;
        boolean placedPending = this.placePendingBlocks(world, depositComponent, chunkComponent, pos);
        if (world.method_8409().method_43058() > GeoclusterConfig.CHUNK_SKIP_CHANCE) {
            for (int p = 0; p < GeoclusterConfig.NUMBER_CLUSTERS_PER_CHUNK; ++p) {
                boolean anyGenerated;
                IDeposit deposit = DepositCache.getCache().pick(world, pos);
                if (deposit == null) continue;
                boolean bl = anyGenerated = deposit.generate(world, pos, depositComponent, chunkComponent) > 0;
                if (!anyGenerated) continue;
                placedCluster = true;
                deposit.generatePost(world, pos, depositComponent, chunkComponent);
            }
        }
        chunkComponent.setChunkGenerated(new class_1923(pos));
        return placedCluster || placedPending;
    }

    private boolean placePendingBlocks(class_5281 worldAccess, IWorldDepositComponent depCap, IWorldChunkComponent cgCap, class_2338 origin) {
        class_1923 cp = new class_1923(origin);
        ConcurrentLinkedQueue<WorldDepositComponent.PendingBlock> q = depCap.getPendingBlocks(cp);
        if (cgCap.hasChunkGenerated(cp) && q.size() > 0) {
            Geocluster.LOGGER.info("Chunk [{}, {}] has already generated but we're trying to place pending blocks anyways", (Object)cp.field_9181, (Object)cp.field_9180);
        }
        q.forEach(x -> FeatureUtils.enqueueBlockPlacement(worldAccess, x.pos(), x.state(), depCap, cgCap));
        depCap.removePendingBlocksForChunk(cp);
        return q.size() > 0;
    }
}

