/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.type.ITradeType;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TradeProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_2403 generator;
    private final Map<class_1299<?>, EnumMap<TradeRarity, List<ITradeType<?>>>> trades = new HashMap();

    protected TradeProvider(class_2403 generator) {
        this.generator = generator;
    }

    protected abstract void registerTrades();

    protected final void addTrade(class_1299<?> type, TradeRarity rarity, ITradeType<?> trade) {
        this.trades.putIfAbsent(type, new EnumMap(TradeRarity.class));
        this.trades.get(type).putIfAbsent(rarity, new ArrayList());
        this.trades.get(type).get((Object)rarity).add(trade);
    }

    public void method_10319(class_7403 output) throws IOException {
        this.trades.clear();
        this.registerTrades();
        this.trades.forEach((entityType, tradeRarityListEnumMap) -> tradeRarityListEnumMap.forEach((tradeRarity, tradeList) -> {
            JsonObject object = new JsonObject();
            object.addProperty("replace", Boolean.valueOf(false));
            JsonArray tradeArray = new JsonArray();
            tradeList.forEach(trade -> tradeArray.add((JsonElement)trade.serialize()));
            object.add("trades", (JsonElement)tradeArray);
            class_2960 id = class_1299.method_5890((class_1299)entityType);
            Path path = this.generator.method_10313().resolve("data/" + id.method_12836() + "/trades/" + id.method_12832() + "/" + tradeRarity.getKey() + ".json");
            try {
                class_2405.method_10320((class_7403)output, (JsonElement)object, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save trades to {}", (Object)path, (Object)e);
            }
        }));
    }

    public String method_10321() {
        return "Trades: goblintraders";
    }
}

