/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.log;

import java.util.Arrays;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JamLibLogger {
    private final String modId;
    private final boolean developmentOnly;
    private final Logger logger;

    private JamLibLogger(String modId, boolean developmentOnly) {
        this.modId = modId;
        this.logger = LoggerFactory.getLogger((String)modId);
        this.developmentOnly = developmentOnly;
    }

    public static JamLibLogger getLogger(String modId) {
        return new JamLibLogger(modId, false);
    }

    public static JamLibLogger getDevelopmentOnlyLogger(String modId) {
        return new JamLibLogger(modId, true);
    }

    private String addModId(Object ... messages) {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            messages[0] = "[" + this.modId + "] " + messages[0];
        }
        return (this.developmentOnly ? "(Development Only) " : "") + String.join((CharSequence)" ", Arrays.stream(messages).map(Object::toString).toList());
    }

    public void info(Object ... messages) {
        if (this.isActive()) {
            this.logger.info(this.addModId(messages));
        }
    }

    public void warn(Object ... messages) {
        if (this.isActive()) {
            this.logger.warn(this.addModId(messages));
        }
    }

    public void error(Object ... messages) {
        if (this.isActive()) {
            this.logger.error(this.addModId(messages));
        }
    }

    public void logInitialize() {
        this.info("Mod initialized!");
    }

    public Logger getUnderlyingLogger() {
        return this.logger;
    }

    public boolean isActive() {
        return !this.developmentOnly || FabricLoader.getInstance().isDevelopmentEnvironment();
    }
}

