/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.javd.util;

import com.unrealdinnerbone.javd.JAVDRegistry;
import com.unrealdinnerbone.javd.block.PortalBlock;
import com.unrealdinnerbone.javd.block.PortalTileEntity;
import com.unrealdinnerbone.javd.util.TeleportHelper;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class TelerportUtils {
    public static void teleport(class_1657 playerEntity, class_5321<class_1937> toWorldKey, class_2338 blockPos, boolean spawnPlatform) {
        class_3218 toWorld = playerEntity.method_5682().method_3847(toWorldKey);
        if (toWorld != null) {
            TelerportUtils.findPortalLocation((class_1937)toWorld, blockPos).ifPresentOrElse(portalLocation -> {
                if (toWorld.method_8320(portalLocation).method_26215()) {
                    toWorld.method_8501(portalLocation, ((PortalBlock)((Object)((Object)JAVDRegistry.PORTAL_BLOCK.get()))).method_9564());
                    class_2248 block = class_2378.field_11146.method_40266(JAVDRegistry.GENERATOR_BLOCKS).map(named -> named.method_40243(toWorld.method_8409())).filter(Optional::isPresent).map(Optional::get).map(class_6880::comp_349).orElse(class_2246.field_10340);
                    int range = 3;
                    class_2338.method_20437((class_2338)portalLocation.method_10069(range, 0, range), (class_2338)portalLocation.method_10069(-range, 0, -range)).forEach(blockPos1 -> {
                        if (toWorld.method_8320(blockPos1).method_26215()) {
                            toWorld.method_8501(blockPos1, block.method_9564());
                        }
                    });
                }
                TeleportHelper.teleport(playerEntity, toWorld, (double)portalLocation.method_10263() + 0.5, portalLocation.method_10264() + 1, (double)portalLocation.method_10260() + 0.5);
            }, () -> playerEntity.method_7353((class_2561)class_2561.method_43471((String)"javd.invalid.pos"), true));
        } else {
            playerEntity.method_7353((class_2561)class_2561.method_43469((String)"javd.invalid.world", (Object[])new Object[]{toWorldKey.method_29177().toString()}), true);
        }
    }

    private static Optional<class_2338> findPortalLocation(class_1937 worldTo, class_2338 fromPos) {
        if (worldTo.method_8320(fromPos).method_26204() == JAVDRegistry.PORTAL_BLOCK.get() && TelerportUtils.isSafeSpawnLocation(worldTo, fromPos)) {
            return Optional.of(fromPos.method_10084());
        }
        int range = 5;
        return Optional.ofNullable(class_1923.method_19280((class_1923)worldTo.method_8500(fromPos).method_12004(), (int)range).map(chunkPos -> worldTo.method_8497(chunkPos.field_9181, chunkPos.field_9180).method_12021()).flatMap(Collection::stream).toList().stream().filter(pos -> worldTo.method_8321(pos) instanceof PortalTileEntity).findFirst().orElseGet(() -> {
            int y;
            int maxY;
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(0, 0, 0);
            int minY = worldTo.method_31607();
            int start = minY + (maxY = worldTo.method_31600());
            if (start != 0) {
                start /= 2;
            }
            for (y = start - 1; y > minY; --y) {
                if (!TelerportUtils.forLocationAround(worldTo, mutableBlockPos, fromPos.method_10263(), fromPos.method_10260(), y)) continue;
                return mutableBlockPos;
            }
            for (y = start; y < maxY; ++y) {
                if (!TelerportUtils.forLocationAround(worldTo, mutableBlockPos, fromPos.method_10263(), fromPos.method_10260(), y)) continue;
                return mutableBlockPos;
            }
            return null;
        }));
    }

    private static boolean forLocationAround(class_1937 levelTo, class_2338.class_2339 blockPos, int fromX, int fromZ, int y) {
        for (int x = fromX - 6; x < fromX + 6; ++x) {
            for (int z = fromZ - 6; z < fromZ + 6; ++z) {
                blockPos.method_10103(x, y, z);
                if (!TelerportUtils.isSaveLocation(levelTo, blockPos)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSaveLocation(class_1937 levelTo, class_2338.class_2339 blockPos) {
        class_2680 blockState = levelTo.method_8320((class_2338)blockPos);
        return blockState.method_26215() && TelerportUtils.isSafeSpawnLocation(levelTo, blockPos.method_10084());
    }

    private static boolean isSafeSpawnLocation(class_1937 world, class_2338 blockPos) {
        return world.method_8320(blockPos).method_26215() && world.method_8320(blockPos.method_10084()).method_26215();
    }
}

