/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.compat.jei;

import dev.architectury.fluid.FluidStack;
import dev.architectury.platform.Platform;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.JustEnoughCalculation;
import me.towdium.jecalculation.compat.ModCompat;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.CostList;
import me.towdium.jecalculation.data.structure.Recipe;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.guis.GuiRecipe;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.utils.wrappers.Trio;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.class_1657;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_6328;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

@class_6328
@ParametersAreNonnullByDefault
@JeiPlugin
public class JecaJEIPlugin
implements IModPlugin {
    private static final RecipeType<class_1860> RECIPE_TYPE = RecipeType.create((String)"jecalculation", (String)"any", class_1860.class);
    public static IJeiRuntime runtime;
    public static Class<?> FABRIC_FLUID_INGREDIENT_CLASS;
    public static Class<?> FORGE_FLUID_INGREDIENT_CLASS;

    public static ILabel getLabelUnderMouse() {
        var ref = new Object(){
            Object o = null;
        };
        runtime.getIngredientListOverlay().getIngredientUnderMouse().ifPresent(ingredient -> {
            ref.o = ingredient.getIngredient();
        });
        runtime.getBookmarkOverlay().getIngredientUnderMouse().ifPresent(ingredient -> {
            ref.o = ingredient.getIngredient();
        });
        return ILabel.Converter.from(ref.o);
    }

    public static boolean isRecipeScreen(class_437 screen) {
        return screen instanceof IRecipesGui;
    }

    public static boolean showRecipe(ILabel l) {
        class_437 s = class_310.method_1551().field_1755;
        Object rep = l.getRepresentation();
        if (rep != null) {
            if (rep instanceof FluidStack) {
                FluidStack fluidStack = (FluidStack)rep;
                rep = runtime.getJeiHelpers().getPlatformFluidHelper().create(fluidStack.getFluid(), fluidStack.getAmount());
            }
            Object finalRep = rep;
            runtime.getIngredientManager().getIngredientTypeChecked(rep).ifPresent(type -> runtime.getRecipesGui().show(runtime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, type, finalRep)));
        }
        return class_310.method_1551().field_1755 != s;
    }

    public class_2960 getPluginUid() {
        return new class_2960("jecalculation", "general");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGlobalGuiHandler(new IGlobalGuiHandler(){

            public Collection<class_768> getGuiExtraAreas() {
                return JustEnoughCalculation.Client.GUI_HANDLER.getGuiAreas();
            }
        });
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addUniversalRecipeTransferHandler((IRecipeTransferHandler)new JEITransferHandler());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
        ModCompat.isJEILoaded = true;
        if (Platform.isForge()) {
            try {
                FORGE_FLUID_INGREDIENT_CLASS = Class.forName("net.minecraftforge.fluids.FluidStack");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Forge fluid ingredient class should exist!", e);
            }
        }
        if (Platform.isFabric()) {
            try {
                FABRIC_FLUID_INGREDIENT_CLASS = Class.forName("mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Fabric fluid ingredient class should exist!", e);
            }
        }
    }

    private static Recipe.IO fromRole(RecipeIngredientRole role) {
        return switch (role) {
            default -> throw new IncompatibleClassChangeError();
            case RecipeIngredientRole.INPUT -> Recipe.IO.INPUT;
            case RecipeIngredientRole.OUTPUT -> Recipe.IO.OUTPUT;
            case RecipeIngredientRole.CATALYST -> Recipe.IO.CATALYST;
            case RecipeIngredientRole.RENDER_ONLY -> null;
        };
    }

    public static class JEITransferHandler
    implements IRecipeTransferHandler<JecaGui.ContainerTransfer, class_1860> {
        public Class<JecaGui.ContainerTransfer> getContainerClass() {
            return JecaGui.ContainerTransfer.class;
        }

        public Optional<class_3917<JecaGui.ContainerTransfer>> getMenuType() {
            return Optional.empty();
        }

        public RecipeType<class_1860> getRecipeType() {
            return RECIPE_TYPE;
        }

        @Nullable
        public IRecipeTransferError transferRecipe(JecaGui.ContainerTransfer container, class_1860 recipe, IRecipeSlotsView recipeSlots, class_1657 player, boolean maxTransfer, boolean doTransfer) {
            if (doTransfer) {
                Class<?> context = runtime.getRecipeManager().createRecipeCategoryLookup().get().filter(category -> category.getRecipeType().getRecipeClass() == recipe.getClass()).findFirst().getClass();
                JecaGui gui = container.getGui();
                if (gui.root instanceof GuiRecipe) {
                    ((GuiRecipe)gui.root).transfer(this.convertRecipe(recipeSlots, context), context);
                } else {
                    GuiRecipe guiRecipe = new GuiRecipe();
                    JecaGui.displayGui((IGui)guiRecipe, JecaGui.getLast());
                    guiRecipe.transfer(this.convertRecipe(recipeSlots, context), context);
                }
            }
            return null;
        }

        protected EnumMap<Recipe.IO, List<Trio<ILabel, CostList, CostList>>> convertRecipe(IRecipeSlotsView recipe, Class<?> context) {
            EnumMap<Recipe.IO, List<Trio<ILabel, CostList, CostList>>> merged = new EnumMap<Recipe.IO, List<Trio<ILabel, CostList, CostList>>>(Recipe.IO.class);
            recipe.getSlotViews().forEach(view -> ModCompat.merge(merged, view.getAllIngredients().map(ITypedIngredient::getIngredient).toList(), context, JecaJEIPlugin.fromRole(view.getRole())));
            return merged;
        }
    }
}

