/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.Context;
import me.towdium.jecalculation.data.label.labels.LStack;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public class LFluidStack
extends LStack<class_3611> {
    public static final String IDENTIFIER = "fluidStack";
    public static final String KEY_FLUID = "fluid";
    public static final String KEY_NBT = "nbt";
    class_3611 fluid;
    class_2487 nbt;
    FluidStack temp;
    private static final String TIC_CLASS = "slimeknights.tconstruct.plugin.jei.casting.CastingRecipeCategory";

    public FluidStack getRepresentation() {
        return this.temp;
    }

    @Override
    public boolean acceptPercent() {
        return false;
    }

    public LFluidStack(FluidStack fs) {
        this(fs.getAmount(), fs.getFluid(), fs.getTag());
    }

    public LFluidStack(long amount, class_3611 fluid) {
        this(amount, fluid, null);
    }

    public LFluidStack(long amount, class_3611 fluid, @Nullable class_2487 nbt) {
        super(amount, false);
        this.init(fluid, nbt);
    }

    public LFluidStack(class_2487 nbt) {
        super(nbt);
        String id = nbt.method_10558(KEY_FLUID);
        Optional f = class_2378.field_11154.method_17966(new class_2960(id));
        if (f.isEmpty()) {
            throw new ILabel.Serializer.SerializationException("Fluid " + id + " cannot be resolved, ignoring");
        }
        this.init((class_3611)f.get(), nbt.method_10545(KEY_NBT) ? nbt.method_10562(KEY_NBT) : null);
    }

    @Override
    public class_3611 get() {
        return this.fluid;
    }

    @Override
    public Context<class_3611> getContext() {
        return Context.FLUID;
    }

    private void init(class_3611 fluid, @Nullable class_2487 nbt) {
        this.fluid = fluid;
        this.nbt = nbt;
        this.temp = FluidStack.create((class_3611)fluid, (long)1L, (class_2487)nbt);
    }

    public LFluidStack(LFluidStack lfs) {
        super(lfs);
        this.fluid = lfs.fluid;
        this.nbt = lfs.nbt;
        this.temp = lfs.temp;
    }

    @Override
    protected int getMultiplier() {
        return 100;
    }

    @Override
    public String getAmountString(boolean round) {
        return LFluidStack.format(this.amount);
    }

    public static String format(long amount) {
        float bucket = FluidStackHooks.bucketAmount();
        return (float)amount >= bucket ? Utilities.cutNumber((float)amount / bucket, 4) + "B" : amount + (Platform.isForge() ? "mB" : "U");
    }

    @Override
    public String getDisplayName() {
        return this.temp.getName().getString();
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean matches(Object l) {
        if (l instanceof LFluidStack) {
            LFluidStack lfs = (LFluidStack)l;
            return Objects.equals(this.nbt, lfs.nbt) && this.fluid == lfs.fluid;
        }
        return false;
    }

    @Override
    public LFluidStack copy() {
        return new LFluidStack(this);
    }

    @Override
    public class_2487 toNbt() {
        class_2487 ret = super.toNbt();
        ret.method_10582(KEY_FLUID, class_2378.field_11154.method_10221((Object)this.fluid).toString());
        if (this.nbt != null) {
            ret.method_10566(KEY_NBT, (class_2520)this.nbt);
        }
        return ret;
    }

    @Override
    public void getToolTip(List<String> existing, boolean detailed) {
        existing.add("\u00a79\u00a7o" + Utilities.getModName(this.fluid));
    }

    @Override
    public void drawLabel(int xPos, int yPos, JecaGui gui, boolean hand) {
        gui.drawResource(Resource.LBL_FLUID, xPos, yPos);
        gui.drawFluid(this.fluid, xPos + 2, yPos + 2, 12, 12);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ class_2378.field_11154.method_10221((Object)this.fluid).hashCode() ^ (this.nbt == null ? 0 : this.nbt.hashCode());
    }

    public static List<ILabel> suggest(List<ILabel> iss, @Nullable Class<?> context) {
        if (context != null && context.getName().equals(TIC_CLASS) && iss.get(0) instanceof LFluidStack) {
            return Collections.singletonList(iss.get(0).copy().multiply(0.5f));
        }
        return new ArrayList<ILabel>();
    }

    public static boolean merge(ILabel a, ILabel b) {
        if (a instanceof LFluidStack && b instanceof LFluidStack) {
            return a.matches(b);
        }
        return false;
    }
}

