/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.Context;
import me.towdium.jecalculation.data.label.labels.LStack;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.utils.Utilities;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public class LItemStack
extends LStack<class_1792> {
    public static final String IDENTIFIER = "itemStack";
    public static final String KEY_ITEM = "item";
    public static final String KEY_NBT = "nbt";
    public static final String KEY_CAP = "cap";
    public static final String KEY_F_META = "fMeta";
    public static final String KEY_F_CAP = "fCap";
    public static final String KEY_F_NBT = "fNbt";
    class_1792 item;
    class_2487 nbt;
    class_2487 cap;
    boolean fMeta;
    boolean fNbt;
    boolean fCap;
    transient class_1799 rep;

    public LItemStack(class_1799 is) {
        super(is.method_7947(), false);
        this.init(is.method_7909(), LItemStack.getCap(is), is.method_7969(), false, false, false);
    }

    public LItemStack(class_2487 tag) {
        super(tag);
        String id = tag.method_10558(KEY_ITEM);
        Optional i = class_2378.field_11142.method_17966(new class_2960(id));
        if (i.isEmpty()) {
            throw new ILabel.Serializer.SerializationException("Item " + id + " cannot be resolved, ignoring");
        }
        this.init((class_1792)i.get(), tag.method_10545(KEY_CAP) ? tag.method_10562(KEY_CAP) : null, tag.method_10545(KEY_NBT) ? tag.method_10562(KEY_NBT) : null, tag.method_10577(KEY_F_META), tag.method_10577(KEY_F_CAP), tag.method_10577(KEY_F_NBT));
    }

    @Override
    public class_1792 get() {
        return this.item;
    }

    @Override
    public Context<class_1792> getContext() {
        return Context.ITEM;
    }

    private LItemStack(LItemStack lis) {
        super(lis);
        this.item = lis.item;
        this.nbt = lis.nbt == null ? null : lis.nbt.method_10553();
        this.cap = lis.cap == null ? null : lis.cap.method_10553();
        this.fMeta = lis.fMeta;
        this.fNbt = lis.fNbt;
        this.fCap = lis.fCap;
        this.rep = lis.rep;
    }

    private void init(@Nullable class_1792 item, @Nullable class_2487 cap, @Nullable class_2487 nbt, boolean fMeta, boolean fCap, boolean fNbt) {
        Objects.requireNonNull(item);
        this.item = item;
        this.cap = cap;
        this.nbt = nbt;
        this.fMeta = fMeta;
        this.fCap = fCap;
        this.fNbt = fNbt;
        this.rep = Utilities.createItemStackWithCap(item, 1, this.cap);
        this.rep.method_7980(this.nbt);
    }

    @Nullable
    private static class_2487 getCap(class_1799 is) {
        return Utilities.getCap(is);
    }

    public static boolean merge(ILabel a, ILabel b) {
        if (a instanceof LItemStack) {
            LItemStack lisA = (LItemStack)a;
            if (b instanceof LItemStack) {
                LItemStack lisB = (LItemStack)b;
                if (lisA.rep.method_7919() != lisB.rep.method_7919() && !lisA.fMeta && !lisB.fMeta) {
                    return false;
                }
                if (!lisA.fNbt && !lisB.fNbt && (lisA.nbt == null ? lisB.nbt != null : lisB.nbt == null || !lisA.nbt.equals((Object)lisB.nbt))) {
                    return false;
                }
                if (!lisA.fCap && !lisB.fCap && (lisA.cap == null ? lisB.cap != null : lisB.cap == null || !lisA.cap.equals((Object)lisB.cap))) {
                    return false;
                }
                return lisA.item == lisB.item;
            }
        }
        return false;
    }

    public static List<ILabel> suggest(List<ILabel> iss, @Nullable Class<?> context) {
        if (iss.size() == 0) {
            return new ArrayList<ILabel>();
        }
        for (ILabel i : iss) {
            if (i instanceof LItemStack) continue;
            return new ArrayList<ILabel>();
        }
        LItemStack lis = (LItemStack)iss.get(0);
        boolean fMeta = false;
        boolean fNbt = false;
        boolean fCap = false;
        for (ILabel i : iss) {
            LItemStack ii = (LItemStack)i;
            if (ii.item != lis.item) {
                return new ArrayList<ILabel>();
            }
            if (ii.rep.method_7919() != lis.rep.method_7919() || ii.fMeta) {
                fMeta = true;
            }
            if (!Objects.equals(ii.nbt, lis.nbt)) {
                fNbt = true;
            }
            if (Objects.equals(ii.cap, lis.cap)) continue;
            fCap = true;
        }
        if (fMeta || fNbt || fCap) {
            return Collections.singletonList(lis.copy().setFCap(fCap).setFMeta(fMeta).setFNbt(fNbt));
        }
        return new ArrayList<ILabel>();
    }

    public static List<ILabel> fallback(List<ILabel> iss, @Nullable Class<?> context) {
        ArrayList<ILabel> ret = new ArrayList<ILabel>();
        if (iss.size() == 1) {
            ILabel label = iss.get(0);
            if (!(label instanceof LItemStack)) {
                return ret;
            }
            LItemStack lis = (LItemStack)label;
            if (lis.fCap || lis.fNbt || lis.fMeta) {
                return new ArrayList<ILabel>();
            }
            ret.add(lis.copy().setFMeta(true));
            ret.add(lis.copy().setFNbt(true));
            ret.add(lis.copy().setFCap(true));
            ret.add(lis.copy().setFMeta(true).setFNbt(true).setFCap(true));
        }
        return ret;
    }

    public LItemStack setFMeta(boolean f) {
        this.fMeta = f;
        return this;
    }

    public LItemStack setFNbt(boolean f) {
        this.fNbt = f;
        return this;
    }

    public LItemStack setFCap(boolean f) {
        this.fCap = f;
        return this;
    }

    @Override
    public void getToolTip(List<String> existing, boolean detailed) {
        super.getToolTip(existing, detailed);
        if (this.fMeta) {
            existing.add("\u00a78" + Utilities.I18n.get("label.item_stack.fuzzy_meta", new Object[0]));
        }
        if (this.fNbt) {
            existing.add("\u00a78" + Utilities.I18n.get("label.item_stack.fuzzy_nbt", new Object[0]));
        }
        if (this.fCap) {
            existing.add("\u00a78" + Utilities.I18n.get("label.item_stack.fuzzy_cap", new Object[0]));
        }
        existing.add("\u00a79\u00a7o" + Utilities.getModName(this.item));
    }

    public class_1799 getRepresentation() {
        return this.rep;
    }

    @Override
    public String getDisplayName() {
        return this.rep.method_7964().getString();
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean matches(Object l) {
        if (l instanceof LItemStack) {
            LItemStack lis = (LItemStack)l;
            return Objects.equals(this.nbt, lis.nbt) && Objects.equals(this.cap, lis.cap) && this.item == lis.item && this.fNbt == lis.fNbt && super.matches(l) && this.fCap == lis.fCap && this.fMeta == lis.fMeta;
        }
        return false;
    }

    @Override
    public LItemStack copy() {
        return new LItemStack(this);
    }

    @Override
    public class_2487 toNbt() {
        class_2960 rl = class_2378.field_11142.method_10221((Object)this.item);
        if (rl == null) {
            return ILabel.EMPTY.toNbt();
        }
        class_2487 ret = super.toNbt();
        ret.method_10582(KEY_ITEM, rl.toString());
        if (this.nbt != null) {
            ret.method_10566(KEY_NBT, (class_2520)this.nbt);
        }
        if (this.cap != null) {
            ret.method_10566(KEY_CAP, (class_2520)this.cap);
        }
        if (this.fMeta) {
            ret.method_10556(KEY_F_META, true);
        }
        if (this.fNbt) {
            ret.method_10556(KEY_F_NBT, true);
        }
        if (this.fCap) {
            ret.method_10556(KEY_F_CAP, true);
        }
        return ret;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawLabel(int xPos, int yPos, JecaGui gui, boolean hand) {
        gui.drawItemStack(xPos, yPos, this.rep, false, hand);
        if (this.fCap || this.fNbt || this.fMeta) {
            gui.drawResource(Resource.LBL_FRAME, xPos, yPos);
        }
        if (this.fCap) {
            gui.drawResource(Resource.LBL_FR_LL, xPos, yPos);
        }
        if (this.fNbt) {
            gui.drawResource(Resource.LBL_FR_UL, xPos, yPos);
        }
        if (this.fMeta) {
            gui.drawResource(Resource.LBL_FR_UR, xPos, yPos);
        }
    }

    @Override
    public int hashCode() {
        return (this.nbt == null ? 0 : this.nbt.hashCode()) ^ (this.cap == null ? 0 : this.cap.hashCode()) ^ this.item.method_7876().hashCode() ^ super.hashCode();
    }
}

