/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.structure;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.JustEnoughCalculation;
import me.towdium.jecalculation.data.structure.Recipe;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public class Recipes {
    HashMap<String, List<Recipe>> records = new HashMap();

    public Recipes() {
        File file = new File(Utilities.config(), "records.json");
        class_2487 nbt = Utilities.Json.read(file);
        if (nbt == null) {
            JustEnoughCalculation.logger.info("Failed to load default records at " + file + ".");
        } else {
            JustEnoughCalculation.logger.info("Loading default records at " + file + ".");
            this.deserialize(nbt);
        }
    }

    public Recipes(class_2487 nbt) {
        this.deserialize(nbt);
    }

    public void deserialize(class_2487 nbt) {
        this.records.clear();
        nbt.method_10541().stream().sorted().forEach((? super T i) -> {
            class_2499 group = nbt.method_10554(i, 10);
            group.stream().filter(r -> r instanceof class_2487).forEach((? super T r) -> {
                try {
                    this.add((String)i, new Recipe((class_2487)r));
                }
                catch (IllegalArgumentException e) {
                    JustEnoughCalculation.logger.warn("Invalid recipe record :" + r);
                }
            });
        });
    }

    public void add(String group, Recipe recipe) {
        this.records.computeIfAbsent(group, k -> new ArrayList()).add(recipe);
    }

    public void renameGroup(String old, String neu) {
        List<Recipe> rs = this.records.get(old);
        this.records.remove(old);
        this.records.put(neu, rs);
    }

    public void modify(String neu, @Nullable String old, int index, @Nullable Recipe recipe) {
        if (index == -1) {
            if (recipe != null) {
                this.add(neu, recipe);
            } else if (old != null) {
                this.renameGroup(old, neu);
            } else {
                this.remove(neu);
            }
        } else if (recipe == null) {
            this.remove(neu, index);
        } else if (old == null || old.equals(neu)) {
            this.set(neu, index, recipe);
        } else {
            this.set(neu, old, index, recipe);
        }
    }

    public void set(String group, int index, Recipe recipe) {
        this.records.get(group).set(index, recipe);
    }

    public void set(String neu, String old, int index, Recipe recipe) {
        this.remove(old, index);
        this.add(neu, recipe);
    }

    public int size() {
        return this.records.size();
    }

    public Stream<Pair<String, List<Recipe>>> stream() {
        return this.records.entrySet().stream().map(i -> new Pair<String, List>((String)i.getKey(), (List)i.getValue()));
    }

    public void remove(String group, int index) {
        List<Recipe> l = this.records.get(group);
        l.remove(index);
        if (l.isEmpty()) {
            this.records.remove(group);
        }
    }

    public void remove(String group) {
        this.records.remove(group);
    }

    public Recipe getRecipe(String group, int index) {
        return this.getGroup(group).get(index);
    }

    public List<Recipe> getRecipes() {
        return this.records.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Recipe> getRecipes(String group) {
        return this.records.get(group);
    }

    public void forEach(BiConsumer<String, List<Recipe>> consumer) {
        this.records.forEach(consumer);
    }

    public List<Recipe> getGroup(String group) {
        return this.records.get(group);
    }

    public class_2487 serialize(Collection<String> groups) {
        class_2487 ret = new class_2487();
        groups.forEach((? super T i) -> {
            class_2499 l = new class_2499();
            this.getGroup((String)i).forEach((? super T r) -> l.add((Object)r.serialize()));
            ret.method_10566(i, (class_2520)l);
        });
        return ret;
    }

    public List<String> getGroups() {
        return this.records.keySet().stream().sorted().collect(Collectors.toList());
    }

    public class_2487 serialize() {
        return this.serialize(this.getGroups());
    }

    public RecipeIterator recipeIterator() {
        return new RecipeIterator();
    }

    public RecipeIterator recipeIterator(String group) {
        return new RecipeIterator(group);
    }

    public class RecipeIterator
    implements Iterator<Recipe> {
        String group;
        int index;
        Iterator<String> i;
        Iterator<Recipe> j;

        public RecipeIterator() {
            this.i = Recipes.this.getGroups().iterator();
        }

        public RecipeIterator(String group) {
            this.i = Collections.singleton(group).iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.j == null || !this.j.hasNext()) {
                if (this.i.hasNext()) {
                    this.group = this.i.next();
                    List<Recipe> rs = Recipes.this.records.get(this.group);
                    this.index = rs.size();
                    this.j = new Utilities.ReversedIterator<Recipe>(rs);
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public Recipe next() {
            this.hasNext();
            --this.index;
            return this.j.next();
        }

        public String getGroup() {
            return this.group;
        }

        public int getIndex() {
            return this.index;
        }

        public Stream<Recipe> stream() {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false);
        }
    }
}

