/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.events;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.events.GuiScreenOverlayHandler;
import me.towdium.jecalculation.events.InventorySummary;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.utils.wrappers.Trio;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5684;
import net.minecraft.class_6328;
import net.minecraft.class_746;
import net.minecraft.class_768;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public class GuiScreenEventHandler {
    protected GuiScreenOverlayHandler overlayHandler = null;
    protected JecaGui gui = null;
    protected InventorySummary cachedInventory;
    protected Trio<List<? extends class_5684>, Integer, Integer> cachedTooltipEvent;

    public GuiScreenEventHandler() {
        this.registerEvents();
    }

    private void registerEvents() {
        ClientGuiEvent.SET_SCREEN.register(this::onGuiOpen);
        ClientTooltipEvent.RENDER_PRE.register(this::onTooltip);
        ClientGuiEvent.RENDER_POST.register(this::onDrawForeground);
        ClientScreenInputEvent.MOUSE_SCROLLED_PRE.register(this::onMouseScroll);
        ClientScreenInputEvent.MOUSE_CLICKED_PRE.register(this::onMouseClicked);
        ClientScreenInputEvent.MOUSE_DRAGGED_PRE.register(this::onMouseDragged);
        ClientScreenInputEvent.MOUSE_RELEASED_PRE.register(this::onMouseReleased);
        ClientScreenInputEvent.KEY_PRESSED_PRE.register(this::onKeyPressed);
        ClientScreenInputEvent.KEY_RELEASED_PRE.register(this::onKeyReleased);
        ClientScreenInputEvent.CHAR_TYPED_PRE.register(this::onCharTyped);
    }

    public CompoundEventResult<class_437> onGuiOpen(class_437 screen) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || !(screen instanceof class_465)) {
            return CompoundEventResult.pass();
        }
        this.overlayHandler = new GuiScreenOverlayHandler(player.method_31548());
        this.gui = new JecaGui(null, false, this.overlayHandler, true);
        this.gui.method_25423(class_310.method_1551(), screen.field_22789, screen.field_22790);
        this.overlayHandler.setGui(this.gui);
        return CompoundEventResult.pass();
    }

    protected boolean isScreenValidForOverlay(class_437 screen) {
        return screen instanceof class_465 && !(screen instanceof JecaGui);
    }

    public void onDrawForeground(class_437 screen, class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null || this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return;
        }
        class_1661 inventory = player.method_31548();
        if (this.didInventoryChange(inventory)) {
            this.overlayHandler = new GuiScreenOverlayHandler(inventory);
            this.gui = new JecaGui(null, false, this.overlayHandler, true);
            this.gui.method_25423(class_310.method_1551(), screen.field_22789, screen.field_22790);
            this.overlayHandler.setGui(this.gui);
        } else if (screen.field_22789 != this.gui.field_22789 || screen.field_22790 != this.gui.field_22790) {
            this.gui.method_25423(class_310.method_1551(), screen.field_22789, screen.field_22790);
        }
        this.gui.setMatrix(poseStack);
        mouseX = this.gui.getGlobalMouseX();
        mouseY = this.gui.getGlobalMouseY();
        poseStack.method_22903();
        poseStack.method_22904((double)this.gui.getGuiLeft(), (double)this.gui.getGuiTop(), 0.0);
        this.overlayHandler.onDraw(this.gui, mouseX, mouseY);
        poseStack.method_22909();
        ArrayList<String> tooltip = new ArrayList<String>();
        this.overlayHandler.onTooltip(this.gui, mouseX, mouseY, tooltip);
        this.gui.drawHoveringText(poseStack, tooltip, mouseX + this.gui.getGuiLeft(), mouseY + this.gui.getGuiTop(), minecraft.field_1772);
        if (this.cachedTooltipEvent != null) {
            this.gui.method_32633(poseStack, (List)this.cachedTooltipEvent.one, (Integer)this.cachedTooltipEvent.two, (Integer)this.cachedTooltipEvent.three);
            this.cachedTooltipEvent = null;
        }
    }

    public EventResult onTooltip(class_4587 poseStack, List<? extends class_5684> components, int x, int y) {
        if (this.overlayHandler == null || this.cachedTooltipEvent != null || !this.overlayHandler.hasAnyWindow()) {
            return EventResult.pass();
        }
        boolean overlap = this.overlayHandler.onTooltip(this.gui, x - this.gui.getGuiLeft(), y - this.gui.getGuiTop(), new ArrayList<String>());
        if (!overlap) {
            this.cachedTooltipEvent = new Trio<List<? extends class_5684>, Integer, Integer>(components, x, y);
        }
        return EventResult.interruptFalse();
    }

    public EventResult onMouseScroll(class_310 client, class_437 screen, double mouseX, double mouseY, double amount) {
        if (this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return EventResult.pass();
        }
        return amount != 0.0 && this.overlayHandler.onMouseScroll(this.gui, this.gui.getGlobalMouseX(), this.gui.getGlobalMouseY(), (int)amount) ? EventResult.interruptFalse() : EventResult.pass();
    }

    public EventResult onMouseClicked(class_310 client, class_437 screen, double mouseX, double mouseY, int button) {
        if (this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return EventResult.pass();
        }
        int xMouse = this.gui.getGlobalMouseX();
        int yMouse = this.gui.getGlobalMouseY();
        this.overlayHandler.onMouseFocused(this.gui, xMouse, yMouse, button);
        return this.overlayHandler.onMouseClicked(this.gui, xMouse, yMouse, button) ? EventResult.interruptFalse() : EventResult.pass();
    }

    public EventResult onMouseReleased(class_310 minecraft, class_437 screen, double mouseX, double mouseY, int button) {
        if (this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return EventResult.pass();
        }
        return this.overlayHandler.onMouseReleased(this.gui, this.gui.getGlobalMouseX(), this.gui.getGlobalMouseY(), button) ? EventResult.interruptFalse() : EventResult.pass();
    }

    public EventResult onMouseDragged(class_310 client, class_437 screen, double mouseX1, double mouseY1, int button, double mouseX2, double mouseY2) {
        if (this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return EventResult.pass();
        }
        return this.overlayHandler.onMouseDragged(this.gui, this.gui.getGlobalMouseX(), this.gui.getGlobalMouseY(), (int)mouseX2, (int)mouseY2) ? EventResult.interruptFalse() : EventResult.pass();
    }

    public EventResult onKeyPressed(class_310 client, class_437 screen, int keyCode, int scanCode, int modifiers) {
        if (this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return EventResult.pass();
        }
        return this.overlayHandler.onKeyPressed(this.gui, keyCode, modifiers) ? EventResult.interruptFalse() : EventResult.pass();
    }

    public EventResult onKeyReleased(class_310 client, class_437 screen, int keyCode, int scanCode, int modifiers) {
        if (this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return EventResult.pass();
        }
        return this.overlayHandler.onKeyReleased(this.gui, keyCode, modifiers) ? EventResult.interruptFalse() : EventResult.pass();
    }

    public EventResult onCharTyped(class_310 minecraft, class_437 screen, char codePoint, int modifiers) {
        if (this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return EventResult.pass();
        }
        return this.overlayHandler.onChar(this.gui, codePoint, modifiers) ? EventResult.interruptFalse() : EventResult.pass();
    }

    private boolean didInventoryChange(class_1661 inventory) {
        if (this.cachedInventory == null) {
            this.cachedInventory = new InventorySummary(inventory);
            return false;
        }
        InventorySummary newSummery = new InventorySummary(inventory);
        if (newSummery.equals(this.cachedInventory)) {
            return false;
        }
        this.cachedInventory = newSummery;
        return true;
    }

    public List<class_768> getGuiAreas() {
        if (this.overlayHandler != null && this.gui != null && this.isScreenValidForOverlay(class_310.method_1551().field_1755)) {
            return this.overlayHandler.getGuiExtraAreas(this.gui.getGuiLeft(), this.gui.getGuiTop());
        }
        return Collections.emptyList();
    }
}

