/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.widgets.ISearchable;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WContainer;
import me.towdium.jecalculation.gui.widgets.WLabel;
import me.towdium.jecalculation.gui.widgets.WLabelGroup;
import me.towdium.jecalculation.gui.widgets.WRectangle;
import me.towdium.jecalculation.gui.widgets.WScroll;
import me.towdium.jecalculation.utils.Utilities;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public class WLabelScroll
extends WContainer
implements ISearchable {
    protected List<ILabel> labels = new ArrayList<ILabel>();
    protected List<ILabel> filtered = null;
    protected WLabelGroup labelGroup;
    protected WScroll scroll;
    protected String filter = "";
    protected int xPos;
    protected int yPos;
    protected int column;
    protected int row;
    protected int current;
    private IWidget.ListenerValue<? super WLabelScroll, Integer> lsnrUpdate;
    private IWidget.ListenerValue<? super WLabelScroll, Integer> hdlrClick;
    protected final boolean accept;

    public WLabelScroll(int xPos, int yPos, int column, int row, boolean accept) {
        this(xPos, yPos, column, row, accept, 4, 14);
    }

    public WLabelScroll(int xPos, int yPos, int column, int row, boolean accept, int spacing, int scrollXSize) {
        this.accept = accept;
        this.xPos = xPos;
        this.yPos = yPos;
        this.column = column;
        this.row = row;
        this.labelGroup = new WLabelGroup(xPos, yPos, column, row, accept).setLsnrUpdate(this::onUpdate).setLsnrClick(this::onClick);
        this.scroll = new WScroll(xPos + column * 18 + spacing, yPos, scrollXSize, row * 18).setListener(i -> this.update(i.getCurrent())).setStep(Float.POSITIVE_INFINITY).setRatio(1.0f);
        this.add(this.labelGroup);
        this.add(this.scroll);
        this.add(new WRectangle(xPos + column * 18, yPos, spacing, row * 18, -6184543));
    }

    public void update(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        int amount = this.getAmountSteps();
        this.current = (int)((float)amount * f);
        if (this.current == amount) {
            --this.current;
        }
        List<ILabel> ls = this.accept ? this.labels : this.filtered;
        this.labelGroup.setLabel(ls, this.current * this.column);
        float step = 1.0f / (float)(amount - 1);
        this.scroll.setRatio(Math.min((float)this.row / (float)this.getAmountRows(), 1.0f)).setCurrent(f).setStep(step);
    }

    public WLabel get(int index) {
        return this.labelGroup.get(index - this.column * this.current);
    }

    public WLabelScroll setLabels(List<ILabel> labels) {
        this.labels = labels;
        if (this.accept) {
            this.update(0.0f);
        } else {
            this.setFilter(this.filter);
        }
        return this;
    }

    public WLabelScroll setLabel(int idx, ILabel label) {
        this.labels.set(idx, label);
        return this.setLabels(this.labels);
    }

    @Override
    public boolean setFilter(String str) {
        if (this.accept) {
            throw new RuntimeException("Filtering not allowed when editing");
        }
        this.filtered = this.labels.stream().filter(l -> Utilities.I18n.contains(l.getDisplayName().toLowerCase(), str.toLowerCase())).collect(Collectors.toList());
        this.update(0.0f);
        return this.filtered.size() != 0;
    }

    public WLabelScroll setLsnrUpdate(IWidget.ListenerValue<? super WLabelScroll, Integer> lsnrUpdate) {
        this.lsnrUpdate = lsnrUpdate;
        return this;
    }

    public WLabelScroll setLsnrClick(IWidget.ListenerValue<? super WLabelScroll, Integer> hdlrClick) {
        this.hdlrClick = hdlrClick;
        return this;
    }

    public List<ILabel> getLabels() {
        return new ArrayList<ILabel>(this.labels);
    }

    protected void onUpdate(WLabelGroup w, int index) {
        ILabel l = w.get(index).getLabel();
        int i = this.column * this.current + index;
        while (this.labels.size() <= i) {
            this.labels.add(ILabel.EMPTY);
        }
        this.labels.set(i, l);
        if (this.lsnrUpdate != null) {
            this.lsnrUpdate.invoke(this, i);
        }
        if (index + 1 == this.row * this.column && l != ILabel.EMPTY && (this.row + this.current) * this.column == this.labels.size()) {
            this.labels.add(ILabel.EMPTY);
            int amount = this.getAmountSteps();
            float step = 1.0f / (float)(amount - 1);
            this.update(step * (float)this.current);
        }
    }

    protected void onClick(WLabelGroup w, int index) {
        if (this.hdlrClick != null) {
            this.hdlrClick.invoke(this, this.column * this.current + index);
        }
    }

    public WLabelScroll setLsnrScroll(IWidget.ListenerValue<? super WLabel, Integer> hdlr) {
        this.labelGroup.setLsnrScroll(hdlr);
        return this;
    }

    public WLabelScroll setFmtAmount(Function<ILabel, String> f) {
        this.labelGroup.setFmtAmount(f);
        return this;
    }

    public WLabelScroll setFmtTooltip(BiConsumer<ILabel, List<String>> f) {
        this.labelGroup.setFmtTooltip(f);
        return this;
    }

    protected int getAmountSteps() {
        return Math.max(this.getAmountRows() - this.row + 1, 1);
    }

    protected int getAmountRows() {
        List<ILabel> ls = this.accept ? this.labels : this.filtered;
        return (ls.size() + this.column - 1) / this.column;
    }
}

