/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WButton;
import me.towdium.jecalculation.gui.widgets.WContainer;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class WTick
extends WContainer {
    WButton button;
    int xPos;
    int yPos;
    int xSize;
    int ySize;
    String name;
    boolean disabled;
    JecaGui.FontType font;
    boolean displayLabel;
    IWidget.ListenerAction<? super WTick> listener;

    public WTick(int xPos, int yPos, int xSize, int ySize, @Nullable String name) {
        this(xPos, yPos, xSize, ySize, name, false, null);
    }

    public WTick(int xPos, int yPos, int xSize, int ySize, @Nullable String name, boolean displayLabel, JecaGui.FontType font) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.xSize = xSize;
        this.ySize = ySize;
        this.name = name;
        this.displayLabel = displayLabel;
        this.font = font == null ? JecaGui.FontType.PLAIN : font;
        this.setSelected(false);
    }

    public WTick setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.button.setDisabled(disabled);
        return this;
    }

    public WTick setListener(IWidget.ListenerAction<? super WTick> listener) {
        this.listener = listener;
        return this;
    }

    public boolean selected() {
        return !(this.button instanceof Normal);
    }

    public WTick setSelected(boolean selected) {
        if (selected == this.selected()) {
            return this;
        }
        this.remove(this.button);
        this.button = selected ? new Selected(this.xPos, this.yPos, this.xSize, this.ySize, this.name) : new Normal(this.xPos, this.yPos, this.xSize, this.ySize, this.name);
        this.add(this.button);
        return this;
    }

    private class Normal
    extends WButton {
        public Normal(int xPos, int yPos, int xSize, @Nullable int ySize, String name) {
            super(xPos, yPos, xSize, ySize, name);
            this.listener = i -> {
                WTick.this.setSelected(true);
                WTick.this.listener.invoke(WTick.this);
            };
            this.disabled = WTick.this.disabled;
        }

        @Override
        public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
            boolean result = super.onDraw(gui, xMouse, yMouse);
            if (WTick.this.displayLabel) {
                gui.drawText(this.xPos + this.xSize + 4, this.yPos + this.ySize / 2 - WTick.this.font.getTextHeight() / 2 + 1, 999, WTick.this.font, this.name);
            }
            return result;
        }

        @Override
        protected List<String> getSuffix() {
            return Collections.singletonList("unselected");
        }
    }

    private class Selected
    extends WButton {
        public Selected(int xPos, int yPos, int xSize, @Nullable int ySize, String name) {
            super(xPos, yPos, xSize, ySize, name);
            this.listener = i -> {
                WTick.this.setSelected(false);
                WTick.this.listener.invoke(WTick.this);
            };
            this.disabled = WTick.this.disabled;
        }

        @Override
        protected List<String> getSuffix() {
            return Collections.singletonList("selected");
        }

        @Override
        public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
            boolean hovered = this.hovered(xMouse, yMouse);
            Resource res = this.disabled ? Resource.WGT_BUTTON_S_D : (hovered ? Resource.WGT_BUTTON_S_F : Resource.WGT_BUTTON_S_N);
            gui.drawResourceContinuous(res, this.xPos, this.yPos, this.xSize, this.ySize, 5, 5, 5, 5);
            if (WTick.this.displayLabel) {
                gui.drawText(this.xPos + this.xSize + 4, this.yPos + this.ySize / 2 - WTick.this.font.getTextHeight() / 2 + 1, 999, WTick.this.font, this.name);
            }
            return hovered;
        }
    }
}

