/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.util.Objects;
import journeymap.client.render.RenderWrapper;
import journeymap.client.ui.GuiUtils;
import journeymap.client.ui.component.BooleanPropertyButton;
import journeymap.common.properties.config.BooleanField;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class CheckBox
extends BooleanPropertyButton {
    public int boxWidth = 11;
    String glyph = "\u2714";

    public CheckBox(String label, boolean checked, class_4185.class_4241 pressable) {
        this(label, null, pressable);
        this.toggled = checked;
    }

    public CheckBox(String label, BooleanField field, class_4185.class_4241 pressable) {
        super(label, label, field, pressable);
        Objects.requireNonNull(this.fontRenderer);
        this.setHeight(9 + 2);
        this.method_25358(this.getFitWidth(this.fontRenderer));
    }

    public CheckBox(String label, boolean checked) {
        this(label, checked, CheckBox.emptyPressable());
    }

    public CheckBox(String label, BooleanField field) {
        this(label, field, CheckBox.emptyPressable());
    }

    @Override
    public int getFitWidth(class_327 fr) {
        return super.getFitWidth(fr) + this.boxWidth + 2;
    }

    @Override
    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float ticks) {
        if (this.field_22764) {
            this.setHovered(this.isEnabled() && mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758 && mouseY < this.field_22761 + this.field_22759);
            int yoffset = (this.field_22759 - this.boxWidth) / 2;
            RenderWrapper.setShader(class_757::method_34542);
            GuiUtils.drawContinuousTexturedBox(poseStack, field_22757, this.field_22760, this.field_22761 + yoffset, 0, 46, this.boxWidth, this.boxWidth, 200, 20, 2, 3, 2, 2, this.method_25305());
            this.method_25403(mouseX, mouseY, 0, this.field_22760, this.field_22761);
            int color = 0xE0E0E0;
            if (this.isHovered()) {
                color = 0xFFFFA0;
            } else if (!this.isEnabled()) {
                color = 0x404040;
            } else if (this.labelColor != null) {
                color = this.labelColor;
            } else if (this.getActiveColor() != 0) {
                color = this.getActiveColor();
            }
            int labelPad = 4;
            if (this.toggled.booleanValue()) {
                CheckBox.method_25300((class_4587)poseStack, (class_327)this.fontRenderer, (String)this.glyph, (int)(this.field_22760 + this.boxWidth / 2 + 1), (int)(this.field_22761 + 1 + yoffset), (int)color);
            }
            CheckBox.method_27535((class_4587)poseStack, (class_327)this.fontRenderer, (class_2561)this.method_25369(), (int)(this.field_22760 + this.boxWidth + labelPad), (int)(this.field_22761 + 2 + yoffset), (int)color);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.field_22764 && mouseX >= (double)this.field_22760 && mouseY >= (double)this.field_22761 && mouseX < (double)(this.field_22760 + this.field_22758) && mouseY < (double)(this.field_22761 + this.field_22759)) {
            this.toggle();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean keyTyped(char c, int i) {
        if (this.isEnabled() && i == 32) {
            this.toggle();
            return true;
        }
        return false;
    }
}

