/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import java.util.List;
import journeymap.client.Constants;
import journeymap.client.data.WorldData;
import journeymap.client.ui.component.Button;
import journeymap.client.waypoint.WaypointStore;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import net.minecraft.class_5321;

class DimensionsButton
extends Button {
    static boolean needInit = true;
    static WorldData.DimensionProvider currentWorldProvider;
    final List<WorldData.DimensionProvider> dimensionProviders = WorldData.getDimensionProviders(WaypointStore.INSTANCE.getLoadedDimensions());
    static int index;

    public DimensionsButton(class_4185.class_4241 onPress) {
        super(0, 0, "", onPress);
        if (needInit) {
            currentWorldProvider = null;
            needInit = false;
        }
        this.updateLabel();
        this.fitWidth(class_310.method_1551().field_1772);
    }

    public void setDim(class_5321<class_1937> dim) {
        index = -1;
        WorldData.DimensionProvider provider = this.dimensionProviders.stream().filter(dimensionProvider -> dim.equals(dimensionProvider.getDimension())).findFirst().orElse(null);
        for (WorldData.DimensionProvider p : this.dimensionProviders) {
            ++index;
            this.getProvider();
            if (!p.equals(provider)) continue;
            return;
        }
    }

    @Override
    protected void updateLabel() {
        String dimName = currentWorldProvider != null ? currentWorldProvider.getName() : Constants.getString("jm.waypoint.dimension_all");
        this.method_25355((class_2561)Constants.getStringTextComponent(Constants.getString("jm.waypoint.dimension", dimName)));
    }

    @Override
    public int getFitWidth(class_327 fr) {
        int maxWidth = 0;
        for (WorldData.DimensionProvider dimensionProvider : this.dimensionProviders) {
            String name = Constants.getString("jm.waypoint.dimension", WorldData.getSafeDimensionName(dimensionProvider));
            maxWidth = Math.max(maxWidth, class_310.method_1551().field_1772.method_1727(name));
        }
        return maxWidth + 12;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean clicked = super.method_25402(mouseX, mouseY, button);
        if (clicked && button == 0) {
            ++index;
            this.getProvider();
        } else if (clicked && button == 1) {
            --index;
            this.getProvider();
        }
        if (clicked) {
            super.method_25306();
        }
        return clicked;
    }

    @Override
    public void method_25306() {
    }

    protected boolean method_25351(int button) {
        return button == 0 || button == 1;
    }

    private void getProvider() {
        if (index >= this.dimensionProviders.size()) {
            index = -1;
        } else if (index < -1) {
            index = this.dimensionProviders.size() - 1;
        }
        currentWorldProvider = index >= this.dimensionProviders.size() || index < 0 ? null : this.dimensionProviders.get(index);
        this.updateLabel();
    }

    static {
        index = -1;
    }
}

