/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.command.CmdTeleportWaypoint;
import journeymap.client.log.JMLogger;
import journeymap.client.properties.ClientCategory;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.OnOffButton;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypoint.DimensionsDropDownButton;
import journeymap.client.ui.waypoint.SortButton;
import journeymap.client.ui.waypoint.WaypointManagerItem;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.properties.catagory.Category;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_5481;

public class WaypointManager
extends JmUI {
    static final String ASCEND = "\u25b2";
    static final String DESCEND = "\u25bc";
    static final int COLWAYPOINT = 0;
    static final int COLLOCATION = 20;
    static final int COLNAME = 60;
    static final int DEFAULT_ITEMWIDTH = 460;
    private static WaypointManagerItem.Sort currentSort;
    private final String on = Constants.getString("jm.common.on");
    private final String off = Constants.getString("jm.common.off");
    protected int colWaypoint = 0;
    protected int colLocation = 20;
    protected int colName = 60;
    protected int itemWidth = 460;
    protected ScrollListPane itemScrollPane;
    protected int rowHeight = 16;
    Boolean canUserTeleport;
    private SortButton buttonSortName;
    private SortButton buttonSortDistance;
    private SortButton buttonSortDeviation;
    private DimensionsDropDownButton buttonDimensions;
    private Button buttonClose;
    private Button buttonAdd;
    private Button buttonOptions;
    private OnOffButton buttonToggleAll;
    private ButtonList bottomButtons;
    private Waypoint focusWaypoint;
    private ArrayList<WaypointManagerItem> items = new ArrayList();
    private static boolean toggled;

    public WaypointManager() {
        this((Waypoint)null, (JmUI)null);
    }

    public WaypointManager(JmUI returnDisplay) {
        this((Waypoint)null, returnDisplay);
    }

    public WaypointManager(Waypoint focusWaypoint, JmUI returnDisplay) {
        super(Constants.getString("jm.waypoint.manage_title"), returnDisplay);
        this.focusWaypoint = focusWaypoint;
    }

    public void setFocusWaypoint(Waypoint focusWaypoint) {
        this.focusWaypoint = focusWaypoint;
    }

    @Override
    public void method_25426() {
        try {
            this.setRenderBottomBar(true);
            this.getRenderables().clear();
            Journeymap.getLogger().debug("Checking if tp is permitted");
            this.canUserTeleport = CmdTeleportWaypoint.isPermitted(class_310.method_1551());
            Journeymap.getLogger().debug("Checked if tp button should be displayed:" + this.canUserTeleport);
            class_327 fr = this.getFontRenderer();
            WaypointManagerItem.DistanceComparator distanceSort = new WaypointManagerItem.DistanceComparator((class_1657)class_310.method_1551().field_1724, true);
            String distanceLabel = Constants.getString("jm.waypoint.distance");
            this.buttonSortDistance = new SortButton(distanceLabel, distanceSort, b -> {
                this.buttonSortDistance.toggle();
                this.updateSort(this.buttonSortDistance);
            });
            this.buttonSortDistance.setTextOnly(fr);
            this.getRenderables().add((class_4068)this.buttonSortDistance);
            this.method_37063((class_364)this.buttonSortDistance);
            WaypointManagerItem.NameComparator nameSort = new WaypointManagerItem.NameComparator(true);
            WaypointManagerItem.DeviationComparator deviationSort = new WaypointManagerItem.DeviationComparator(true);
            this.buttonSortName = new SortButton(Constants.getString("jm.waypoint.name"), nameSort, b -> {
                this.buttonSortName.toggle();
                this.updateSort(this.buttonSortName);
            });
            this.buttonSortName.setTextOnly(fr);
            this.method_37063((class_364)this.buttonSortName);
            this.getRenderables().add((class_4068)this.buttonSortName);
            this.buttonSortDeviation = new SortButton(Constants.getString("jm.waypoint.deviation_button_sort"), deviationSort, b -> {
                this.buttonSortDeviation.toggle();
                this.updateSort(this.buttonSortDeviation);
            });
            this.buttonSortDeviation.setTextOnly(fr);
            this.method_37063((class_364)this.buttonSortDeviation);
            this.getRenderables().add((class_4068)this.buttonSortDeviation);
            String enableOn = Constants.getString("jm.waypoint.enable_all", "", this.on);
            String enableOff = Constants.getString("jm.waypoint.enable_all", "", this.off);
            this.buttonToggleAll = new OnOffButton(enableOff, enableOn, true, b -> {
                boolean state = this.buttonToggleAll.getToggled();
                state = this.toggleItems(state);
                this.buttonToggleAll.setToggled(state);
            });
            this.buttonToggleAll.setTextOnly(this.getFontRenderer());
            this.method_37063((class_364)this.buttonToggleAll);
            this.getRenderables().add((class_4068)this.buttonToggleAll);
            this.buttonDimensions = new DimensionsDropDownButton(b -> this.updateItems());
            this.method_37063((class_364)this.buttonDimensions);
            if (JourneymapClient.getInstance().getWaypointProperties().managerDimensionFocus.get().booleanValue()) {
                this.buttonDimensions.setDim((class_5321<class_1937>)this.field_22787.field_1724.field_6002.method_27983());
            }
            this.buttonAdd = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.waypoint.new"), button -> {
                Waypoint waypoint = Waypoint.of((class_1297)this.field_22787.field_1724);
                UIManager.INSTANCE.openWaypointEditor(waypoint, true, this);
            }));
            this.buttonAdd.fitWidth(this.getFontRenderer());
            this.buttonAdd.method_25358(this.buttonAdd.method_25368() * 2);
            this.buttonOptions = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.common.options_button"), button -> UIManager.INSTANCE.openOptionsManager(this, ClientCategory.Waypoint, ClientCategory.WaypointBeacon)));
            this.buttonOptions.fitWidth(this.getFontRenderer());
            this.buttonClose = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.common.close"), button -> this.refreshAndClose()));
            this.bottomButtons = new ButtonList(this.buttonOptions, this.buttonAdd, this.buttonDimensions, this.buttonClose);
            this.buttonOptions.setDefaultStyle(false);
            this.buttonAdd.setDefaultStyle(false);
            this.buttonDimensions.setDefaultStyle(false);
            this.buttonClose.setDefaultStyle(false);
            this.getRenderables().addAll(this.bottomButtons);
            if (this.items.isEmpty()) {
                this.updateItems();
                if (currentSort == null) {
                    this.updateSort(this.buttonSortDistance);
                } else {
                    if (this.buttonSortDistance.sort.equals(currentSort)) {
                        this.buttonSortDistance.sort.ascending = WaypointManager.currentSort.ascending;
                        this.buttonSortDistance.setActive(true);
                        this.buttonSortName.setActive(false);
                        this.buttonSortDeviation.setActive(false);
                    }
                    if (this.buttonSortName.sort.equals(currentSort)) {
                        this.buttonSortName.sort.ascending = WaypointManager.currentSort.ascending;
                        this.buttonSortName.setActive(true);
                        this.buttonSortDistance.setActive(false);
                        this.buttonSortDeviation.setActive(false);
                    }
                    if (this.buttonSortDeviation.sort.equals(currentSort)) {
                        this.buttonSortDeviation.sort.ascending = WaypointManager.currentSort.ascending;
                        this.buttonSortDeviation.setActive(true);
                        this.buttonSortName.setActive(false);
                        this.buttonSortDistance.setActive(false);
                    }
                }
            }
            if (this.itemScrollPane == null) {
                this.itemScrollPane = new ScrollListPane(this, this.field_22787, this.field_22789, this.field_22790, 35, this.field_22790 - 30, 20);
                this.itemScrollPane.method_31323(false);
            } else {
                this.itemScrollPane.method_25323(this.field_22789, this.field_22790, 35, this.field_22790 - 30);
                this.itemScrollPane.updateSlots();
            }
            this.itemScrollPane.setSlots(this.items);
            if (!this.items.isEmpty()) {
                this.itemScrollPane.scrollTo(this.items.get(0));
            }
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in OptionsManager.init(): " + t, t);
        }
    }

    @Override
    protected void layoutButtons(class_4587 poseStack) {
        if (this.getRenderables().isEmpty() || this.itemScrollPane == null) {
            this.method_25426();
        }
        this.buttonToggleAll.setDrawButton(!this.items.isEmpty());
        this.buttonSortDistance.setDrawButton(!this.items.isEmpty());
        this.buttonSortName.setDrawButton(!this.items.isEmpty());
        this.buttonSortDeviation.setDrawButton(!this.items.isEmpty() && JourneymapClient.getInstance().getWaypointProperties().showDeviationLabel.get() != false);
        this.bottomButtons.equalizeWidths(this.getFontRenderer());
        int bottomButtonWidth = Math.min(this.bottomButtons.getWidth(4) + 25, this.itemScrollPane.method_25322());
        this.bottomButtons.equalizeWidths(this.getFontRenderer(), 4, bottomButtonWidth);
        this.bottomButtons.layoutCenteredHorizontal(this.field_22789 / 2, this.field_22790 - 25, true, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void method_25394(class_4587 poseStack, int x, int y, float par3) {
        if (this.field_22787 == null) {
            return;
        }
        if (this.getRenderables().isEmpty() || this.itemScrollPane == null) {
            this.method_25426();
        }
        if (currentSort != null) {
            Collections.sort(this.items, currentSort);
        }
        if (this.itemScrollPane != null) {
            this.itemScrollPane.setSlots(this.items);
        }
        try {
            poseStack.method_22903();
            this.itemScrollPane.method_25323(this.field_22789, this.field_22790, 35, this.field_22790 - 30);
            List<class_5481> lastTooltip = this.itemScrollPane.lastTooltip;
            long lastTooltipTime = this.itemScrollPane.lastTooltipTime;
            this.itemScrollPane.lastTooltip = null;
            this.itemScrollPane.method_25394(poseStack, x, y, par3);
            super.method_25394(poseStack, x, y, par3);
            if (!this.items.isEmpty()) {
                Objects.requireNonNull(this.getFontRenderer());
                int headerY = 35 - 9;
                WaypointManagerItem firstRow = this.items.get(0);
                if (firstRow.y > headerY + 16) {
                    headerY = firstRow.y - 16;
                }
                this.buttonToggleAll.centerHorizontalOn(firstRow.getButtonEnableCenterX()).setY(headerY);
                this.buttonSortDistance.centerHorizontalOn(firstRow.getLocationLeftX()).setY(headerY);
                this.colName = this.buttonSortDistance.getRightX() + 20;
                this.buttonSortName.setPosition(this.colName - 5, headerY);
                this.buttonSortDeviation.centerHorizontalOn(firstRow.getButtonDeviationX()).setY(headerY);
            }
            this.buttonToggleAll.drawUnderline(poseStack);
            for (List<SlotMetadata> toolbar : this.getToolbars().values()) {
                for (SlotMetadata slotMetadata : toolbar) {
                    slotMetadata.getButton().secondaryDrawButton();
                }
            }
            if (this.itemScrollPane.lastTooltip != null && this.itemScrollPane.lastTooltip.equals(lastTooltip)) {
                this.itemScrollPane.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - this.itemScrollPane.lastTooltipTime > this.itemScrollPane.hoverDelay) {
                    Button button = this.itemScrollPane.lastTooltipMetadata.getButton();
                    this.method_25417(poseStack, this.itemScrollPane.lastTooltip, x, button.getBottomY() + 15);
                }
            }
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in OptionsManager.render(): " + t, t);
        }
        finally {
            poseStack.method_22909();
        }
    }

    @Override
    public void method_25420(class_4587 poseStack) {
    }

    public void method_25433(class_4587 poseStack, int tint) {
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        try {
            boolean pressed;
            if (mouseButton == 0 && (pressed = this.itemScrollPane.method_25402(mouseX, mouseY, mouseButton))) {
                this.checkPressedButton();
                return true;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Problem with mouseClicked", (Throwable)e);
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        this.itemScrollPane.method_25406(mouseX, mouseY, mouseButton);
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        this.checkPressedButton();
        this.itemScrollPane.method_25403(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.method_25403(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean method_25401(double x, double y, double scroll) {
        if (this.itemScrollPane.method_25401(x, y, scroll)) {
            return true;
        }
        return super.method_25401(x, y, scroll);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkPressedButton() {
        try {
            CategorySlot parentSlot;
            SlotMetadata slotMetadata = this.itemScrollPane.getLastPressed();
            if (slotMetadata != null) {
                // empty if block
            }
            if ((parentSlot = (CategorySlot)this.itemScrollPane.getLastPressedParentSlot()) == null) return;
        }
        catch (Exception e) {
            Journeymap.getLogger().error("WARNING: Problem checking buttons.");
            throw new RuntimeException("checkPressedButton", e);
        }
    }

    @Override
    public boolean method_25400(char typedChar, int keyCode) {
        if (keyCode == 256) {
            this.closeAndReturn();
        }
        if (this.itemScrollPane != null) {
            boolean keyUsed = this.itemScrollPane.method_25400(typedChar, keyCode);
            if (keyUsed) {
                return true;
            }
            if (keyCode == 265) {
                this.itemScrollPane.method_25309(-this.rowHeight);
                return true;
            }
            if (keyCode == 264) {
                this.itemScrollPane.method_25309(this.rowHeight);
                return true;
            }
            if (keyCode == 266) {
                this.itemScrollPane.method_25309(-this.itemScrollPane.getHeight());
                return true;
            }
            if (keyCode == 267) {
                this.itemScrollPane.method_25309(this.itemScrollPane.getHeight());
                return true;
            }
            if (keyCode == 268) {
                this.itemScrollPane.method_25309((int)(-this.itemScrollPane.method_25341()));
                return true;
            }
            if (keyCode == 269) {
                this.itemScrollPane.method_25309((int)this.itemScrollPane.method_25341());
                return true;
            }
        } else {
            Journeymap.getLogger().error("WARNING: itemScrollPane is null. This is an error state! Report to Developers!");
        }
        return true;
    }

    protected boolean toggleItems(boolean enable) {
        for (WaypointManagerItem item : this.items) {
            if (enable != item.waypoint.isEnable()) continue;
            enable = !enable;
            break;
        }
        for (WaypointManagerItem item : this.items) {
            if (item.waypoint.isEnable() == enable) continue;
            item.enableWaypoint(enable);
        }
        return !enable;
    }

    public static void toggleAllWaypoints() {
        toggled = !toggled;
        Collection<Waypoint> waypoints = WaypointStore.INSTANCE.getAll();
        for (Waypoint waypoint : waypoints) {
            waypoint.setEnable(toggled);
            waypoint.setDirty();
        }
        WaypointStore.INSTANCE.bulkSave();
    }

    protected void updateItems() {
        this.items.clear();
        String currentDim = DimensionsDropDownButton.currentWorldProvider == null ? null : DimensionsDropDownButton.currentWorldProvider.getDimensionId();
        class_327 fr = this.getFontRenderer();
        Collection<Waypoint> waypoints = WaypointStore.INSTANCE.getAll();
        boolean allOn = true;
        this.itemWidth = 0;
        for (Waypoint waypoint : waypoints) {
            WaypointManagerItem item = new WaypointManagerItem(waypoint, fr, this);
            this.itemWidth = Math.max(item.internalWidth, this.itemWidth);
            item.getDistanceTo((class_1657)this.field_22787.field_1724);
            if (currentDim != null && !item.waypoint.getDimensions().contains(currentDim)) continue;
            this.items.add(item);
            if (!allOn) continue;
            allOn = waypoint.isEnable();
        }
        if (this.items.isEmpty()) {
            this.itemWidth = 460;
        }
        this.buttonToggleAll.setToggled(!allOn);
        this.updateCount();
    }

    protected void updateSort(SortButton sortButton) {
        for (class_4068 button : this.getRenderables()) {
            if (!(button instanceof SortButton)) continue;
            if (button == sortButton) {
                if (!sortButton.sort.equals(currentSort)) {
                    sortButton.setActive(true);
                }
                currentSort = sortButton.sort;
                continue;
            }
            ((SortButton)button).setActive(false);
        }
    }

    protected void updateCount() {
        String itemCount = this.items.isEmpty() ? "" : Integer.toString(this.items.size());
        String enableOn = Constants.getString("jm.waypoint.enable_all", itemCount, this.on);
        String enableOff = Constants.getString("jm.waypoint.enable_all", itemCount, this.off);
        this.buttonToggleAll.setLabels(enableOff, enableOn);
    }

    protected boolean isSelected(WaypointManagerItem item) {
        return this.itemScrollPane.method_25332(item.getSlotIndex());
    }

    protected int getMargin() {
        return this.field_22789 > this.itemWidth + 2 ? (this.field_22789 - this.itemWidth) / 2 : 0;
    }

    public void removeWaypoint(WaypointManagerItem item) {
        WaypointStore.INSTANCE.remove(item.waypoint, true);
        this.items.remove((Object)item);
        this.updateItems();
    }

    protected void refreshAndClose() {
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        this.bottomButtons.setEnabled(false);
        WaypointStore.INSTANCE.bulkSave();
        Fullscreen.state().requireRefresh();
        this.bottomButtons.setEnabled(true);
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open((class_437)returnDisplayStack.pop());
        }
    }

    Map<Category, List<SlotMetadata>> getToolbars() {
        return Collections.EMPTY_MAP;
    }

    static {
        toggled = true;
    }
}

