/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.handler;

import journeymap.client.JourneymapClient;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.dialog.MultiplayerOptionsManager;
import journeymap.client.ui.dialog.ServerOptionsManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.command.CreateWaypoint;
import journeymap.common.network.data.ServerPropertyType;
import journeymap.common.network.data.model.ClientState;
import journeymap.common.network.data.model.PlayerLocation;
import journeymap.common.util.PlayerRadarManager;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class ClientPacketHandler {
    public void onClientStateUpdate(ClientState packet) {
        JourneymapClient.getInstance().getStateHandler().setStates(packet);
    }

    public void onServerAdminDataResponse(int type, String payload, String dimension) {
        ServerOptionsManager serverOptionsManager = UIManager.INSTANCE.getServerEditor();
        if (serverOptionsManager != null) {
            serverOptionsManager.setData(ServerPropertyType.getFromType(type), payload, dimension);
        }
    }

    public void onMultiplayerDataResponse(String payload) {
        MultiplayerOptionsManager multiplayerOptionsManager = UIManager.INSTANCE.getMultiplayerOptions();
        if (multiplayerOptionsManager != null) {
            multiplayerOptionsManager.setData(payload);
        }
    }

    public void onPlayerLocationPacket(PlayerLocation packet) {
        PlayerRadarManager.getInstance().updatePlayers(packet);
    }

    public void onWaypointCreatePacket(String waypoint, String action, boolean announce) {
        class_5250 message = null;
        if ("create".equalsIgnoreCase(action)) {
            Waypoint clientWaypoint = Waypoint.fromString(waypoint);
            if ("waypoint-normal.png".equals(clientWaypoint.getIcon().method_12832())) {
                clientWaypoint.setIcon(TextureCache.Waypoint);
            }
            if (Waypoint.Origin.EXTERNAL_FORCE.getValue().equals(clientWaypoint.getOrigin())) {
                clientWaypoint.setPersistent(false);
            }
            WaypointStore.INSTANCE.save(clientWaypoint, true);
            Fullscreen.state().requireRefresh();
            message = class_2561.method_43469((String)"jm.common.waypoint.create_packet", (Object[])new Object[]{clientWaypoint.getPrettyName(), clientWaypoint.getX(), clientWaypoint.getY(), clientWaypoint.getZ(), clientWaypoint.getDimensions()});
        } else if ("delete".equalsIgnoreCase(action)) {
            CreateWaypoint.CommandWaypoint commandWaypoint = CreateWaypoint.CommandWaypoint.fromString(waypoint);
            for (Waypoint wp : WaypointStore.INSTANCE.getAll()) {
                if (!commandWaypoint.name.equalsIgnoreCase(wp.getName()) || !wp.getOrigin().equals(commandWaypoint.origin) || !ClientPacketHandler.validOrigin(commandWaypoint.origin)) continue;
                WaypointStore.INSTANCE.remove(wp, true);
                message = class_2561.method_43469((String)"jm.common.waypoint.delete_packet", (Object[])new Object[]{wp.getPrettyName()});
                break;
            }
        } else {
            Journeymap.getLogger().warn("Error invalid action is being sent: \"{}\", \"create\" and \"delete\" are accepted values", (Object)action);
            return;
        }
        if (announce && message != null) {
            class_310.method_1551().field_1705.method_1743().method_1812(message);
        }
        Journeymap.getLogger().info(message.getString());
    }

    private static boolean validOrigin(String origin) {
        return Waypoint.Origin.getValues().contains(origin);
    }

    public void onWorldIdReceived(String worldId) {
        JourneymapClient.getInstance().setCurrentWorldId(worldId);
    }
}

