/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content.handling;

import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.events.SubscribeEvent;
import de.keksuccino.konkrete.events.client.ClientTickEvent;
import de.keksuccino.konkrete.events.client.GuiScreenEvent;
import de.keksuccino.konkrete.events.client.ScreenCharTypedEvent;
import de.keksuccino.konkrete.events.client.ScreenKeyPressedEvent;
import de.keksuccino.konkrete.events.client.ScreenKeyReleasedEvent;
import de.keksuccino.konkrete.events.client.ScreenMouseClickedEvent;
import de.keksuccino.konkrete.events.client.ScreenTickEvent;
import de.keksuccino.konkrete.gui.content.handling.IAdvancedWidgetBase;
import de.keksuccino.konkrete.input.CharData;
import de.keksuccino.konkrete.input.KeyboardData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AdvancedWidgetsHandler {
    protected static Map<IAdvancedWidgetBase, Long> widgets = new HashMap<IAdvancedWidgetBase, Long>();

    public static void init() {
        Konkrete.getEventHandler().registerEventsFrom(new AdvancedWidgetsHandler());
    }

    protected AdvancedWidgetsHandler() {
    }

    public static void handleWidget(IAdvancedWidgetBase widget) {
        widgets.put(widget, System.currentTimeMillis());
    }

    @SubscribeEvent
    public void onScreenCharTyped(ScreenCharTypedEvent e) {
        for (Map.Entry<IAdvancedWidgetBase, Long> m : widgets.entrySet()) {
            CharData d = new CharData(e.character, e.modifiers);
            m.getKey().onCharTyped(d);
        }
    }

    @SubscribeEvent
    public void onScreenKeyPressed(ScreenKeyPressedEvent e) {
        for (Map.Entry<IAdvancedWidgetBase, Long> m : widgets.entrySet()) {
            KeyboardData d = new KeyboardData(e.keyCode, e.scanCode, e.modifiers);
            m.getKey().onKeyPress(d);
        }
    }

    @SubscribeEvent
    public void onScreenKeyReleased(ScreenKeyReleasedEvent e) {
        for (Map.Entry<IAdvancedWidgetBase, Long> m : widgets.entrySet()) {
            KeyboardData d = new KeyboardData(e.keyCode, e.scanCode, e.modifiers);
            m.getKey().onKeyReleased(d);
        }
    }

    @SubscribeEvent
    public void onScreenMouseClicked(ScreenMouseClickedEvent e) {
        for (Map.Entry<IAdvancedWidgetBase, Long> m : widgets.entrySet()) {
            m.getKey().onMouseClicked(e.mouseX, e.mouseY, e.mouseButton);
        }
    }

    @SubscribeEvent
    public void onScreenTick(ScreenTickEvent e) {
        for (Map.Entry<IAdvancedWidgetBase, Long> m : widgets.entrySet()) {
            m.getKey().onTick();
        }
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre e) {
        long now = System.currentTimeMillis();
        ArrayList<IAdvancedWidgetBase> garbageCollected = new ArrayList<IAdvancedWidgetBase>();
        for (Map.Entry<IAdvancedWidgetBase, Long> m : widgets.entrySet()) {
            long lastRenderTick = m.getValue();
            IAdvancedWidgetBase widget = m.getKey();
            if (lastRenderTick + 2000L >= now) continue;
            garbageCollected.add(widget);
        }
        for (IAdvancedWidgetBase widget : garbageCollected) {
            widgets.remove(widget);
        }
    }

    @SubscribeEvent
    public void onInitScreen(GuiScreenEvent.InitGuiEvent.Pre e) {
        widgets.clear();
    }
}

