/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import dev.latvian.mods.rhino.Undefined;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1160;
import net.minecraft.class_1767;
import net.minecraft.class_2680;
import net.minecraft.class_3620;

public record MapColorHelper(int id, String name, class_3620 color, class_1160 rgb) implements Function<class_2680, class_3620>
{
    public static final Map<String, MapColorHelper> NAME_MAP = new HashMap<String, MapColorHelper>(64);
    public static final Map<Integer, MapColorHelper> ID_MAP = new HashMap<Integer, MapColorHelper>(64);
    public static final MapColorHelper NONE = MapColorHelper.add("none", class_3620.field_16008);

    private static MapColorHelper add(String id, class_3620 color) {
        float r = (float)(color.field_16011 >> 16 & 0xFF) / 255.0f;
        float g = (float)(color.field_16011 >> 8 & 0xFF) / 255.0f;
        float b = (float)(color.field_16011 & 0xFF) / 255.0f;
        MapColorHelper helper = new MapColorHelper(color.field_16021, id, color, new class_1160(r, g, b));
        NAME_MAP.put(id, helper);
        ID_MAP.put(color.field_16021, helper);
        return helper;
    }

    public static class_3620 of(Object o) {
        if (o == null || Undefined.isUndefined((Object)o)) {
            return class_3620.field_16008;
        }
        if (o instanceof class_3620) {
            class_3620 c = (class_3620)o;
            return c;
        }
        if (o instanceof CharSequence) {
            CharSequence s = (CharSequence)o;
            if (s.isEmpty()) {
                return class_3620.field_16008;
            }
            if (s.charAt(0) == '#') {
                return MapColorHelper.findClosest((int)Integer.decode((String)s.toString()).intValue()).color;
            }
            return MapColorHelper.NAME_MAP.getOrDefault((Object)s.toString().toLowerCase(), (MapColorHelper)MapColorHelper.NONE).color;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return MapColorHelper.findClosest((int)n.intValue()).color;
        }
        if (o instanceof class_1767) {
            class_1767 c = (class_1767)o;
            return c.method_7794();
        }
        return class_3620.field_16008;
    }

    public static MapColorHelper reverse(class_3620 c) {
        return ID_MAP.getOrDefault(c.field_16021, NONE);
    }

    public static MapColorHelper findClosest(int rgbi) {
        class_1160 rgb = new class_1160((float)(rgbi >> 16 & 0xFF) / 255.0f, (float)(rgbi >> 8 & 0xFF) / 255.0f, (float)(rgbi & 0xFF) / 255.0f);
        MapColorHelper closest = null;
        float lastDist = Float.MAX_VALUE;
        for (MapColorHelper helper : NAME_MAP.values()) {
            float dist;
            if (helper.color == class_3620.field_16008 || !((dist = MapColorHelper.distSq(helper.rgb, rgb)) < lastDist)) continue;
            closest = helper;
            lastDist = dist;
        }
        return closest == null ? NONE : closest;
    }

    private static float distSq(class_1160 a, class_1160 b) {
        return (a.method_4943() - b.method_4943()) * (a.method_4943() - b.method_4943()) + (a.method_4945() - b.method_4945()) * (a.method_4945() - b.method_4945()) + (a.method_4947() - b.method_4947()) * (a.method_4947() - b.method_4947());
    }

    @Override
    public class_3620 apply(class_2680 blockState) {
        return this.color;
    }

    static {
        MapColorHelper.add("grass", class_3620.field_15999);
        MapColorHelper.add("sand", class_3620.field_15986);
        MapColorHelper.add("wool", class_3620.field_15979);
        MapColorHelper.add("fire", class_3620.field_16002);
        MapColorHelper.add("ice", class_3620.field_16016);
        MapColorHelper.add("metal", class_3620.field_16005);
        MapColorHelper.add("plant", class_3620.field_16004);
        MapColorHelper.add("snow", class_3620.field_16022);
        MapColorHelper.add("clay", class_3620.field_15976);
        MapColorHelper.add("dirt", class_3620.field_16000);
        MapColorHelper.add("stone", class_3620.field_16023);
        MapColorHelper.add("water", class_3620.field_16019);
        MapColorHelper.add("wood", class_3620.field_15996);
        MapColorHelper.add("quartz", class_3620.field_16025);
        MapColorHelper.add("color_orange", class_3620.field_15987);
        MapColorHelper.add("color_magenta", class_3620.field_15998);
        MapColorHelper.add("color_light_blue", class_3620.field_16024);
        MapColorHelper.add("color_yellow", class_3620.field_16010);
        MapColorHelper.add("color_light_green", class_3620.field_15997);
        MapColorHelper.add("color_pink", class_3620.field_16030);
        MapColorHelper.add("color_gray", class_3620.field_15978);
        MapColorHelper.add("color_light_gray", class_3620.field_15993);
        MapColorHelper.add("color_cyan", class_3620.field_16026);
        MapColorHelper.add("color_purple", class_3620.field_16014);
        MapColorHelper.add("color_blue", class_3620.field_15984);
        MapColorHelper.add("color_brown", class_3620.field_15977);
        MapColorHelper.add("color_green", class_3620.field_15995);
        MapColorHelper.add("color_red", class_3620.field_16020);
        MapColorHelper.add("color_black", class_3620.field_16009);
        MapColorHelper.add("gold", class_3620.field_15994);
        MapColorHelper.add("diamond", class_3620.field_15983);
        MapColorHelper.add("lapis", class_3620.field_15980);
        MapColorHelper.add("emerald", class_3620.field_16001);
        MapColorHelper.add("podzol", class_3620.field_16017);
        MapColorHelper.add("nether", class_3620.field_16012);
        MapColorHelper.add("terracotta_white", class_3620.field_16003);
        MapColorHelper.add("terracotta_orange", class_3620.field_15981);
        MapColorHelper.add("terracotta_magenta", class_3620.field_15985);
        MapColorHelper.add("terracotta_light_blue", class_3620.field_15991);
        MapColorHelper.add("terracotta_yellow", class_3620.field_16013);
        MapColorHelper.add("terracotta_light_green", class_3620.field_16018);
        MapColorHelper.add("terracotta_pink", class_3620.field_15989);
        MapColorHelper.add("terracotta_gray", class_3620.field_16027);
        MapColorHelper.add("terracotta_light_gray", class_3620.field_15988);
        MapColorHelper.add("terracotta_cyan", class_3620.field_15990);
        MapColorHelper.add("terracotta_purple", class_3620.field_16029);
        MapColorHelper.add("terracotta_blue", class_3620.field_16015);
        MapColorHelper.add("terracotta_brown", class_3620.field_15992);
        MapColorHelper.add("terracotta_green", class_3620.field_16028);
        MapColorHelper.add("terracotta_red", class_3620.field_15982);
        MapColorHelper.add("terracotta_black", class_3620.field_16007);
        MapColorHelper.add("crimson_nylium", class_3620.field_25702);
        MapColorHelper.add("crimson_stem", class_3620.field_25703);
        MapColorHelper.add("crimson_hyphae", class_3620.field_25704);
        MapColorHelper.add("warped_nylium", class_3620.field_25705);
        MapColorHelper.add("warped_stem", class_3620.field_25706);
        MapColorHelper.add("warped_hyphae", class_3620.field_25707);
        MapColorHelper.add("warped_wart_block", class_3620.field_25708);
        MapColorHelper.add("deepslate", class_3620.field_33532);
        MapColorHelper.add("raw_iron", class_3620.field_33533);
        MapColorHelper.add("glow_lichen", class_3620.field_33617);
    }
}

