/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client.painter.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.client.painter.PainterObjectProperties;
import dev.latvian.mods.kubejs.client.painter.screen.PaintScreenEventJS;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPainterObject;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.unit.FixedBooleanUnit;
import dev.latvian.mods.unit.FixedNumberUnit;
import dev.latvian.mods.unit.Unit;
import dev.latvian.mods.unit.UnitVariables;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1309;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_757;
import net.minecraft.class_809;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

public class ItemObject
extends ScreenPainterObject {
    private class_1799 itemStack = class_1799.field_8037;
    private Unit overlay = FixedBooleanUnit.TRUE;
    private String customText = "";
    private Unit rotation = FixedNumberUnit.ZERO;

    public ItemObject(Painter painter) {
        this.z = FixedNumberUnit.of((double)100.0);
    }

    @Override
    protected void load(PainterObjectProperties properties) {
        super.load(properties);
        if (properties.hasAny("item")) {
            this.itemStack = ItemStackJS.of(properties.tag.method_10580("item"));
        }
        this.overlay = properties.getUnit("overlay", this.overlay);
        this.customText = properties.getString("customText", this.customText);
        this.rotation = properties.getUnit("rotation", this.rotation);
    }

    @Override
    public void draw(PaintScreenEventJS event) {
        if (this.itemStack.method_7960()) {
            return;
        }
        float aw = this.w.getFloat((UnitVariables)event);
        float ah = this.h.getFloat((UnitVariables)event);
        float ax = event.alignX(this.x.getFloat((UnitVariables)event), aw, this.alignX);
        float ay = event.alignY(this.y.getFloat((UnitVariables)event), ah, this.alignY);
        float az = this.z.getFloat((UnitVariables)event);
        event.push();
        event.translate(ax, ay, az);
        if (this.rotation != FixedNumberUnit.ZERO) {
            event.rotateRad(this.rotation.getFloat((UnitVariables)event));
        }
        event.scale(aw / 16.0f, ah / 16.0f, 1.0f);
        ItemObject.drawItem(event.matrices, this.itemStack, 0, this.overlay.getBoolean((UnitVariables)event), this.customText.isEmpty() ? null : this.customText);
        event.pop();
    }

    public static void drawItem(class_4587 poseStack, class_1799 stack, int hash, boolean renderOverlay, @Nullable String text) {
        boolean flatLight;
        if (stack.method_7960()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_918 itemRenderer = mc.method_1480();
        class_1087 bakedModel = itemRenderer.method_4019(stack, null, (class_1309)mc.field_1724, hash);
        class_310.method_1551().method_1531().method_4619(class_1723.field_21668).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        modelViewStack.method_34425(poseStack.method_23760().method_23761());
        modelViewStack.method_22905(1.0f, -1.0f, 1.0f);
        modelViewStack.method_22905(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        boolean bl = flatLight = !bakedModel.method_24304();
        if (flatLight) {
            class_308.method_24210();
        }
        itemRenderer.method_23179(stack, class_809.class_811.field_4317, false, new class_4587(), (class_4597)bufferSource, 0xF000F0, class_4608.field_21444, bakedModel);
        bufferSource.method_22993();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            class_308.method_24211();
        }
        modelViewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        if (renderOverlay) {
            float cooldown;
            class_289 t = class_289.method_1348();
            class_327 font = mc.field_1772;
            if (stack.method_7947() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.method_7947()) : text;
                poseStack.method_22903();
                poseStack.method_22904(9.0 - (double)font.method_1727(s), 1.0, 20.0);
                font.method_27521(s, 0.0f, 0.0f, 0xFFFFFF, true, poseStack.method_23760().method_23761(), (class_4597)bufferSource, false, 0, 0xF000F0);
                bufferSource.method_22993();
                poseStack.method_22909();
            }
            if (stack.method_31578()) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableBlend();
                int barWidth = stack.method_31579();
                int barColor = stack.method_31580();
                ItemObject.draw(poseStack, t, -6, 5, 13, 2, 0, 0, 0, 255);
                ItemObject.draw(poseStack, t, -6, 5, barWidth, 1, barColor >> 16 & 0xFF, barColor >> 8 & 0xFF, barColor & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
            float f = cooldown = mc.field_1724 == null ? 0.0f : mc.field_1724.method_7357().method_7905(stack.method_7909(), mc.method_1488());
            if (cooldown > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                ItemObject.draw(poseStack, t, -8, class_3532.method_15375((float)(16.0f * (1.0f - cooldown))) - 8, 16, class_3532.method_15386((float)(16.0f * cooldown)), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
        }
    }

    private static void draw(class_4587 matrixStack, class_289 t, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        if (width <= 0 || height <= 0) {
            return;
        }
        RenderSystem.setShader(class_757::method_34540);
        class_1159 m = matrixStack.method_23760().method_23761();
        class_287 renderer = t.method_1349();
        renderer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        renderer.method_22918(m, (float)x, (float)y, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(m, (float)x, (float)(y + height), 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(m, (float)(x + width), (float)(y + height), 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(m, (float)(x + width), (float)y, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        t.method_1350();
    }
}

