/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.integration.rei;

import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.integration.rei.EntryWrapper;
import dev.latvian.mods.kubejs.integration.rei.KubeJSREIPlugin;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.Tags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class GroupREIEntriesEventJS
extends EventJS {
    public final CollapsibleEntryRegistry registry;

    public GroupREIEntriesEventJS(CollapsibleEntryRegistry registry) {
        this.registry = registry;
    }

    public void groupItems(class_2960 groupId, class_2561 description, class_1856 entries) {
        this.group(groupId, description, (List<EntryStack<?>>)EntryIngredients.ofIngredient((class_1856)entries));
    }

    public void groupFluids(class_2960 groupId, class_2561 description, FluidStackJS ... entries) {
        this.group(groupId, description, (List<EntryStack<?>>)EntryIngredients.of((EntryType)VanillaEntryTypes.FLUID, (Collection)CollectionUtils.map((Object[])entries, FluidStackJS::getFluidStack)));
    }

    public void groupEntries(class_2960 groupId, class_2561 description, class_2960 entryTypeId, Object entries) {
        EntryType<?> entryType = KubeJSREIPlugin.getTypeOrThrow(entryTypeId);
        EntryWrapper wrapper = KubeJSREIPlugin.getWrapperOrFallback(entryType);
        List<?> entryList = ListJS.orSelf(entries);
        ArrayList list = new ArrayList(entryList.size());
        for (Object entry : entryList) {
            Collection<EntryStack<?>> stacks = wrapper.wrap(entry);
            if (stacks == null || stacks.isEmpty()) continue;
            list.addAll(stacks);
        }
        this.group(groupId, description, list);
    }

    public void groupSameItem(class_2960 group, class_2561 description, class_1799 item) {
        this.groupItemsIf(group, description, (Predicate<class_1799>)item.method_7909().kjs$asIngredient());
    }

    public void groupSameFluid(class_2960 group, class_2561 description, FluidStackJS fluid) {
        this.groupFluidsIf(group, description, stack -> stack.getFluid().equals(fluid.getFluid()));
    }

    public void groupItemsByTag(class_2960 groupId, class_2561 description, class_2960 tags) {
        this.group(groupId, description, (List<EntryStack<?>>)EntryIngredients.ofItemTag(Tags.item(tags)));
    }

    public void groupFluidsByTag(class_2960 groupId, class_2561 description, class_2960 tags) {
        this.group(groupId, description, (List<EntryStack<?>>)EntryIngredients.ofFluidTag(Tags.fluid(tags)));
    }

    public void groupItemsIf(class_2960 groupId, class_2561 description, Predicate<class_1799> predicate) {
        this.registry.group(groupId, description, VanillaEntryTypes.ITEM, item -> predicate.test((class_1799)item.getValue()));
    }

    public void groupFluidsIf(class_2960 groupId, class_2561 description, Predicate<FluidStackJS> predicate) {
        this.registry.group(groupId, description, VanillaEntryTypes.FLUID, fluid -> predicate.test(FluidStackJS.of(fluid.getValue())));
    }

    public void groupEntriesIf(class_2960 groupId, class_2561 description, class_2960 entryTypeId, Predicate predicate) {
        EntryType<?> entryType = KubeJSREIPlugin.getTypeOrThrow(entryTypeId);
        EntryWrapper wrapper = KubeJSREIPlugin.getWrapperOrFallback(entryType);
        this.registry.group(groupId, description, entryType, entry -> predicate.test(entry.getValue()));
    }

    public void groupAnyIf(class_2960 groupId, class_2561 description, Predicate<EntryStack<?>> predicate) {
        this.registry.group(groupId, description, predicate);
    }

    private void group(class_2960 groupId, class_2561 description, List<EntryStack<?>> entries) {
        this.registry.group(groupId, description, entries);
    }
}

