/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.platform.IngredientPlatformHelper;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.registry.KubeJSRegistries;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2519;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public interface ItemStackJS {
    public static final Map<String, class_1799> PARSE_CACHE = new HashMap<String, class_1799>();
    public static final class_1799[] EMPTY_ARRAY = new class_1799[0];
    public static final Lazy<List<String>> CACHED_ITEM_TYPE_LIST = Lazy.of(() -> {
        ArrayList<String> cachedItemTypeList = new ArrayList<String>();
        for (class_2960 id : KubeJSRegistries.items().getIds()) {
            cachedItemTypeList.add(id.toString());
        }
        return cachedItemTypeList;
    });
    public static final Lazy<Map<class_2960, class_2371<class_1799>>> CACHED_ITEM_MAP = Lazy.of(() -> {
        HashMap<class_2960, class_2371> map = new HashMap<class_2960, class_2371>();
        class_2371 stackList = class_2371.method_10211();
        for (class_1792 item : KubeJSRegistries.items()) {
            try {
                item.method_7850(class_1761.field_7915, stackList);
            }
            catch (Throwable throwable) {}
        }
        for (class_1799 stack : stackList) {
            if (stack.method_7960()) continue;
            map.computeIfAbsent(stack.method_7909().kjs$getIdLocation(), _rl -> class_2371.method_10211()).add((Object)stack.kjs$withCount(1));
        }
        for (String itemId : CACHED_ITEM_TYPE_LIST.get()) {
            class_2960 itemRl = new class_2960(itemId);
            map.computeIfAbsent(itemRl, _rl -> class_2371.method_10212((Object)class_1799.field_8037, (Object[])new class_1799[]{new class_1799((class_1935)KubeJSRegistries.items().get(itemRl))}));
        }
        return map;
    });
    public static final Lazy<List<class_1799>> CACHED_ITEM_LIST = Lazy.of(() -> CACHED_ITEM_MAP.get().values().stream().flatMap(Collection::stream).toList());

    public static class_1799 of(@Nullable Object o) {
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o == null || o == class_1799.field_8037 || o == class_1802.field_8162) {
            return class_1799.field_8037;
        }
        if (o instanceof class_1799) {
            class_1799 stack = (class_1799)o;
            return stack.method_7960() ? class_1799.field_8037 : stack;
        }
        if (o instanceof OutputItem) {
            OutputItem out = (OutputItem)o;
            return out.item;
        }
        if (o instanceof class_1856) {
            class_1856 ingr = (class_1856)o;
            return ingr.kjs$getFirst();
        }
        if (o instanceof class_2960) {
            class_2960 id = (class_2960)o;
            class_1792 item = (class_1792)KubeJSRegistries.items().get(id);
            if (item == null || item == class_1802.field_8162) {
                if (RecipeJS.itemErrors) {
                    throw new RecipeExceptionJS("Item '" + id + "' not found!").error();
                }
                return class_1799.field_8037;
            }
            return item.method_7854();
        }
        if (o instanceof class_1935) {
            class_1935 itemLike = (class_1935)o;
            return new class_1799((class_1935)itemLike.method_8389());
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return ItemStackJS.resultFromRecipeJson(json);
        }
        if (o instanceof class_2519) {
            class_2519 tag = (class_2519)o;
            return ItemStackJS.of(tag.method_10714());
        }
        if (o instanceof Pattern || o instanceof NativeRegExp) {
            Pattern reg = UtilsJS.parseRegex(o);
            if (reg != null) {
                return IngredientPlatformHelper.get().regex(reg).kjs$getFirst();
            }
            return class_1799.field_8037;
        }
        if (o instanceof CharSequence) {
            String os;
            String s = os = o.toString().trim();
            class_1799 cached = PARSE_CACHE.get(os);
            if (cached != null) {
                return cached.method_7960() ? class_1799.field_8037 : cached.method_7972();
            }
            int count = 1;
            int spaceIndex = s.indexOf(32);
            if (spaceIndex >= 2 && s.indexOf(120) == spaceIndex - 1) {
                count = Integer.parseInt(s.substring(0, spaceIndex - 1));
                s = s.substring(spaceIndex + 1);
            }
            cached = ItemStackJS.parse(s);
            cached.method_7939(count);
            PARSE_CACHE.put(os, cached);
            return cached.method_7972();
        }
        Map<?, ?> map = MapJS.of(o);
        if (map != null) {
            if (map.containsKey("item")) {
                class_2960 id = UtilsJS.getMCID(null, map.get("item").toString());
                class_1792 item = (class_1792)KubeJSRegistries.items().get(id);
                if (item == class_1802.field_8162) {
                    if (RecipeJS.itemErrors) {
                        throw new RecipeExceptionJS("Item '" + id + "' not found!").error();
                    }
                    return class_1799.field_8037;
                }
                class_1799 stack = new class_1799((class_1935)item);
                Object obj = map.get("count");
                if (obj instanceof Number) {
                    Number number = (Number)obj;
                    stack.method_7939(number.intValue());
                }
                if (map.containsKey("nbt")) {
                    stack.method_7980(NBTUtils.toTagCompound(map.get("nbt")));
                }
                return stack;
            }
            Object id = map.get("tag");
            if (id instanceof CharSequence) {
                CharSequence s = (CharSequence)id;
                class_1799 stack = IngredientPlatformHelper.get().tag(s.toString()).kjs$getFirst();
                if (map.containsKey("count")) {
                    stack.method_7939(UtilsJS.parseInt(map.get("count"), 1));
                }
                return stack;
            }
        }
        return class_1799.field_8037;
    }

    public static class_1799 parse(String s) {
        String tagStr;
        if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
            return class_1799.field_8037;
        }
        if (s.startsWith("#")) {
            return IngredientPlatformHelper.get().tag(s.substring(1)).kjs$getFirst();
        }
        if (s.startsWith("@")) {
            return IngredientPlatformHelper.get().mod(s.substring(1)).kjs$getFirst();
        }
        if (s.startsWith("%")) {
            class_1761 group = UtilsJS.findCreativeTab(s.substring(1));
            if (group == null) {
                if (RecipeJS.itemErrors) {
                    throw new RecipeExceptionJS("Item group '" + s.substring(1) + "' not found!").error();
                }
                return class_1799.field_8037;
            }
            return IngredientPlatformHelper.get().creativeTab(group).kjs$getFirst();
        }
        Pattern reg = UtilsJS.parseRegex(s);
        if (reg != null) {
            return IngredientPlatformHelper.get().regex(reg).kjs$getFirst();
        }
        int spaceIndex = s.indexOf(32);
        String id = spaceIndex == -1 ? s : s.substring(0, spaceIndex);
        class_1792 item = (class_1792)KubeJSRegistries.items().get(new class_2960(id));
        if (item == class_1802.field_8162) {
            if (RecipeJS.itemErrors) {
                throw new RecipeExceptionJS("Item '" + id + "' not found!").error();
            }
            return class_1799.field_8037;
        }
        class_1799 stack = new class_1799((class_1935)item);
        if (spaceIndex != -1 && (tagStr = s.substring(spaceIndex + 1)).length() >= 2 && tagStr.charAt(0) == '{') {
            stack.method_7980(NBTUtils.toTagCompound((Object)tagStr));
        }
        return stack;
    }

    public static class_1792 getRawItem(Context cx, @Nullable Object o) {
        if (o == null) {
            return class_1802.field_8162;
        }
        if (o instanceof class_1935) {
            class_1935 item = (class_1935)o;
            return item.method_8389();
        }
        if (o instanceof CharSequence) {
            String s = o.toString();
            if (s.isEmpty()) {
                return class_1802.field_8162;
            }
            if (s.charAt(0) != '#') {
                return (class_1792)KubeJSRegistries.items().get(UtilsJS.getMCID(cx, s));
            }
        }
        return ItemStackJS.of(o).method_7909();
    }

    public static class_1799 resultFromRecipeJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return class_1799.field_8037;
        }
        if (json.isJsonPrimitive()) {
            return ItemStackJS.of(json.getAsString());
        }
        if (json instanceof JsonObject) {
            JsonObject jsonObj = (JsonObject)json;
            class_1799 stack = null;
            if (jsonObj.has("item")) {
                stack = ItemStackJS.of(jsonObj.get("item").getAsString());
            } else if (jsonObj.has("tag")) {
                stack = IngredientPlatformHelper.get().tag(jsonObj.get("tag").getAsString()).kjs$getFirst();
            }
            if (stack != null) {
                if (jsonObj.has("count")) {
                    stack.method_7939(jsonObj.get("count").getAsInt());
                } else if (jsonObj.has("amount")) {
                    stack.method_7939(jsonObj.get("amount").getAsInt());
                }
                if (jsonObj.has("nbt")) {
                    JsonElement element = jsonObj.get("nbt");
                    if (element.isJsonObject()) {
                        stack.method_7980(NBTUtils.toTagCompound((Object)element));
                    } else {
                        stack.method_7980(NBTUtils.toTagCompound((Object)element.getAsString()));
                    }
                }
                return stack;
            }
        }
        return class_1799.field_8037;
    }

    public static String toItemString(Object object) {
        return ItemStackJS.of(object).kjs$toItemString();
    }

    public static List<class_1799> getList() {
        return CACHED_ITEM_LIST.get();
    }

    public static List<String> getTypeList() {
        return CACHED_ITEM_TYPE_LIST.get();
    }

    public static Map<class_2960, class_2371<class_1799>> getTypeToStacks() {
        return CACHED_ITEM_MAP.get();
    }

    public static void clearAllCaches() {
        CACHED_ITEM_LIST.forget();
        CACHED_ITEM_TYPE_LIST.forget();
        PARSE_CACHE.clear();
        InputItem.PARSE_CACHE.clear();
    }
}

