/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient;

import com.google.common.collect.Iterables;
import dev.architectury.extensions.injected.InjectedRegistryEntryExtension;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

public interface TagContext {
    public static final TagContext EMPTY = new TagContext(){

        @Override
        public <T> boolean isEmpty(class_6862<T> tag) {
            return true;
        }

        @Override
        public <T> Iterable<class_6880<T>> getTag(class_6862<T> tag) {
            KubeJS.LOGGER.warn("Tried to get tag {} from an empty tag context!", (Object)tag.comp_327());
            return List.of();
        }
    };
    public static final MutableObject<TagContext> INSTANCE = new MutableObject((Object)EMPTY);

    public static TagContext usingRegistry(final class_5455 registryAccess) {
        return new TagContext(){

            @NotNull
            private <T> class_2378<T> registry(class_6862<T> tag) {
                return registryAccess.method_30530(tag.comp_326());
            }

            @Override
            public boolean areTagsBound() {
                return true;
            }

            @Override
            public <T> Iterable<class_6880<T>> getTag(class_6862<T> tag) {
                return this.registry(tag).method_40286(tag);
            }

            @Override
            public <T> boolean contains(class_6862<T> tag, T value) {
                if (value instanceof InjectedRegistryEntryExtension) {
                    InjectedRegistryEntryExtension ext = (InjectedRegistryEntryExtension)value;
                    class_6880 holder2 = (class_6880)UtilsJS.cast(ext.arch$holder());
                    return holder2.method_40220(tag);
                }
                class_2378<T> reg = this.registry(tag);
                return reg.method_29113(value).flatMap(arg_0 -> reg.method_40264(arg_0)).map(holder -> holder.method_40220(tag)).orElseGet(() -> TagContext.super.contains(tag, value));
            }
        };
    }

    public static TagContext fromLoadResult(List<class_3505.class_6863<?>> results) {
        final Map<class_5321, Map> tags = results.stream().collect(Collectors.toMap(result -> (class_5321)UtilsJS.cast(result.comp_328()), result -> (Map)UtilsJS.cast(result.comp_329())));
        if (!tags.containsKey(class_2378.field_25108)) {
            ConsoleJS.getCurrent(ConsoleJS.SERVER).warn("Failed to load item tags during recipe event! Using replaceInput etc. will not work!");
            return EMPTY;
        }
        return new TagContext(){

            @Override
            public <T> Iterable<class_6880<T>> getTag(class_6862<T> tag) {
                return (Iterable)UtilsJS.cast(((Map)tags.get(tag.comp_326())).getOrDefault(tag.comp_327(), Set.of()));
            }
        };
    }

    default public <T> boolean isEmpty(class_6862<T> tag) {
        return Iterables.isEmpty(this.getTag(tag));
    }

    default public <T> boolean contains(class_6862<T> tag, T value) {
        if (this.isEmpty(tag)) {
            return false;
        }
        for (class_6880<T> holder : this.getTag(tag)) {
            if (!holder.comp_349().equals(value)) continue;
            return true;
        }
        return false;
    }

    default public boolean areTagsBound() {
        return false;
    }

    public <T> Iterable<class_6880<T>> getTag(class_6862<T> var1);

    default public Collection<class_1799> patchIngredientTags(class_6862<class_1792> tag) {
        int n;
        Iterable<class_6880<class_1792>> c = this.getTag(tag);
        if (c instanceof Collection) {
            Collection cl = (Collection)c;
            n = cl.size();
        } else {
            n = 3;
        }
        ArrayList<class_1799> stacks = new ArrayList<class_1799>(n);
        for (class_6880<class_1792> holder : c) {
            stacks.add(new class_1799((class_1935)holder.comp_349()));
        }
        return stacks.isEmpty() ? List.of() : stacks;
    }
}

