/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import dev.architectury.hooks.level.ExplosionHooks;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.level.LevelEventJS;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public abstract class ExplosionEventJS
extends LevelEventJS {
    protected final class_1937 level;
    protected final class_1927 explosion;

    public ExplosionEventJS(class_1937 level, class_1927 explosion) {
        this.level = level;
        this.explosion = explosion;
    }

    @Override
    public class_1937 getLevel() {
        return this.level;
    }

    public class_243 getPosition() {
        return ExplosionHooks.getPosition((class_1927)this.explosion);
    }

    public double getX() {
        return this.getPosition().field_1352;
    }

    public double getY() {
        return this.getPosition().field_1351;
    }

    public double getZ() {
        return this.getPosition().field_1350;
    }

    public BlockContainerJS getBlock() {
        return new BlockContainerJS(this.level, new class_2338(this.getPosition()));
    }

    @Nullable
    public class_1309 getExploder() {
        return this.explosion.method_8347();
    }

    @Info(value="Invoked right after an explosion happens.\n")
    public static class After
    extends ExplosionEventJS {
        private final List<class_1297> affectedEntities;

        public After(class_1937 level, class_1927 explosion, List<class_1297> affectedEntities) {
            super(level, explosion);
            this.affectedEntities = affectedEntities;
        }

        @Info(value="Gets a list of all entities affected by the explosion.")
        public EntityArrayList getAffectedEntities() {
            return new EntityArrayList(this.level, this.affectedEntities);
        }

        @Info(value="Remove an entity from the list of affected entities.")
        public void removeAffectedEntity(class_1297 entity) {
            this.affectedEntities.remove(entity);
        }

        @Info(value="Remove all entities from the list of affected entities.")
        public void removeAllAffectedEntities() {
            this.affectedEntities.clear();
        }

        @Info(value="Gets a list of all blocks affected by the explosion.")
        public List<BlockContainerJS> getAffectedBlocks() {
            ArrayList<BlockContainerJS> list = new ArrayList<BlockContainerJS>(this.explosion.method_8346().size());
            for (class_2338 pos : this.explosion.method_8346()) {
                list.add(new BlockContainerJS(this.level, pos));
            }
            return list;
        }

        @Info(value="Remove a block from the list of affected blocks.")
        public void removeAffectedBlock(BlockContainerJS block) {
            this.explosion.method_8346().remove(block.getPos());
        }

        @Info(value="Remove all blocks from the list of affected blocks.")
        public void removeAllAffectedBlocks() {
            this.explosion.method_8346().clear();
        }

        @Info(value="Remove all knockback from all affected *players*.")
        public void removeKnockback() {
            this.explosion.method_8351().clear();
        }
    }

    @Info(value="Invoked right before an explosion happens.\n")
    public static class Before
    extends ExplosionEventJS {
        public Before(class_1937 level, class_1927 explosion) {
            super(level, explosion);
        }

        @Info(value="Returns the size of the explosion.")
        public float getSize() {
            return this.explosion.field_9190;
        }

        @Info(value="Sets the size of the explosion.")
        public void setSize(float s) {
            this.explosion.field_9190 = s;
        }
    }
}

