/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level.gen;

import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.latvian.mods.kubejs.event.StartupEventJS;
import dev.latvian.mods.kubejs.level.gen.filter.biome.BiomeFilter;
import dev.latvian.mods.kubejs.level.gen.properties.AddLakeProperties;
import dev.latvian.mods.kubejs.level.gen.properties.AddOreProperties;
import dev.latvian.mods.kubejs.level.gen.properties.AddSpawnProperties;
import dev.latvian.mods.kubejs.registry.KubeJSRegistries;
import dev.latvian.mods.kubejs.util.ClassWrapper;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3085;
import net.minecraft.class_3124;
import net.minecraft.class_4651;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5458;
import net.minecraft.class_5483;
import net.minecraft.class_5843;
import net.minecraft.class_6017;
import net.minecraft.class_6793;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6799;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class AddWorldgenEventJS
extends StartupEventJS {
    private static final Pattern SPAWN_PATTERN = Pattern.compile("(\\w+:\\w+)\\*\\((\\d+)-(\\d+)\\):(\\d+)");

    private static <T> class_6880<T> registerFeature(class_2378<T> registry, class_2960 id, T object) {
        class_5321 key = class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)id);
        return ((class_2385)registry).method_31062(OptionalInt.empty(), key, object, Lifecycle.experimental());
    }

    private void addFeature(class_2960 id, BiomeFilter filter, class_2893.class_2895 step, class_2975<?, ?> feature, List<class_6797> modifiers) {
        if (id == null) {
            id = new class_2960("kubejs:features/" + UtilsJS.getUniqueId(feature, class_2975.field_25833));
        }
        class_6880<class_2975<?, ?>> holder = AddWorldgenEventJS.registerFeature(class_5458.field_25929, id, feature);
        class_6796 placed = new class_6796(holder, modifiers);
        this.addFeature(id, filter, step, placed);
    }

    private void addFeature(class_2960 id, BiomeFilter filter, class_2893.class_2895 step, class_6796 feature) {
        if (id == null) {
            id = new class_2960("kubejs:features/" + UtilsJS.getUniqueId(feature, class_6796.field_35729));
        }
        class_6880<class_6796> holder = AddWorldgenEventJS.registerFeature(class_5458.field_35761, id, feature);
        BiomeModifications.postProcessProperties((Predicate)filter, (ctx, props) -> props.getGenerationProperties().addFeature(step, holder));
    }

    private void addEntitySpawn(BiomeFilter filter, class_1311 category, class_5483.class_1964 spawnerData) {
        BiomeModifications.postProcessProperties((Predicate)filter, (ctx, props) -> props.getSpawnProperties().addSpawn(category, spawnerData));
    }

    @Deprecated(forRemoval=true)
    public void addFeatureJson(BiomeFilter filter, JsonObject json) {
        class_2960 id = json.has("id") ? new class_2960(json.get("id").getAsString()) : null;
        this.addFeatureJson(filter, id, json);
    }

    @Deprecated(forRemoval=true)
    public void addFeatureJson(BiomeFilter filter, @Nullable class_2960 id, JsonObject json) {
        JsonObject featureJson;
        ConsoleJS.STARTUP.warn("addFeatureJson is deprecated for removal in 1.19.2! Please use virtual datapacks or addOre (for ores) instead.");
        JsonObject jsonObject = featureJson = json.has("feature") ? json : (JsonObject)class_156.method_654((Object)new JsonObject(), o -> o.add("feature", (JsonElement)json));
        if (!featureJson.has("placement")) {
            featureJson.add("placement", (JsonElement)new JsonArray());
        }
        if (id == null) {
            id = new class_2960("kubejs:features/" + UtilsJS.getUniqueId((JsonElement)featureJson));
        }
        if (!featureJson.get("feature").isJsonObject()) {
            ConsoleJS.STARTUP.error("Adding feature JSONs with indirect references is not supported during worldgen events due to how dynamic registries work.");
            ConsoleJS.STARTUP.error("If you want to add a feature that references another feature by ID, please use virtual datapacks instead.");
            return;
        }
        class_6796 feature = (class_6796)class_6796.field_35729.parse((DynamicOps)JsonOps.INSTANCE, (Object)featureJson).get().orThrow();
        this.addFeature(id, filter, class_2893.class_2895.field_13173, feature);
    }

    public void addOre(Consumer<AddOreProperties> p) {
        AddOreProperties properties = new AddOreProperties();
        p.accept(properties);
        if (properties.targets.isEmpty()) {
            return;
        }
        class_2975 oreFeature = new class_2975(class_3031.field_13517, (class_3037)new class_3124(properties.targets, properties.size, properties.noSurface));
        ArrayList<class_6797> modifiers = new ArrayList<class_6797>();
        if (properties.count.method_35011() > 1) {
            modifiers.add((class_6797)class_6793.method_39624((class_6017)properties.count));
        }
        if (properties.chance > 0) {
            modifiers.add((class_6797)class_6799.method_39659((int)properties.chance));
        }
        if (properties.squared) {
            modifiers.add((class_6797)class_5450.method_39639());
        }
        modifiers.add((class_6797)properties.height);
        this.addFeature(properties.id, properties.biomes, properties.worldgenLayer, oreFeature, modifiers);
    }

    public void addLake(Consumer<AddLakeProperties> p) {
        AddLakeProperties properties = new AddLakeProperties();
        p.accept(properties);
        class_2680 fluid = (class_2680)Iterables.getFirst(properties.fluid.getBlockStates(), (Object)class_2246.field_10124.method_9564());
        if (fluid == null || fluid.method_26215()) {
            return;
        }
        class_2680 barrier = (class_2680)Iterables.getFirst(properties.barrier.getBlockStates(), (Object)class_2246.field_10124.method_9564());
        if (barrier == null || barrier.method_26215()) {
            return;
        }
        this.addFeature(properties.id, properties.biomes, properties.worldgenLayer, new class_2975(class_3031.field_13573, (class_3037)new class_3085.class_6788((class_4651)class_4651.method_38433((class_2680)fluid), (class_4651)class_4651.method_38433((class_2680)barrier))), properties.chance > 0 ? Collections.singletonList(class_6799.method_39659((int)properties.chance)) : List.of());
    }

    public void addSpawn(Consumer<AddSpawnProperties> p) {
        AddSpawnProperties properties = new AddSpawnProperties();
        p.accept(properties);
        if (properties._entity == null || properties._category == null) {
            return;
        }
        this.addEntitySpawn(properties.biomes, properties._category, new class_5483.class_1964(properties._entity, properties.weight, properties.minCount, properties.maxCount));
    }

    public void addSpawn(BiomeFilter filter, class_1311 category, String spawn) {
        Matcher matcher = SPAWN_PATTERN.matcher(spawn);
        if (matcher.matches()) {
            try {
                class_1299 entity = Objects.requireNonNull((class_1299)KubeJSRegistries.entityTypes().get(new class_2960(matcher.group(1))));
                int weight = Integer.parseInt(matcher.group(4));
                int min = Integer.parseInt(matcher.group(2));
                int max = Integer.parseInt(matcher.group(3));
                this.addEntitySpawn(filter, category, new class_5483.class_1964(entity, weight, min, max));
            }
            catch (Exception ex) {
                ConsoleJS.STARTUP.info("Failed to add spawn: " + ex);
            }
        } else {
            ConsoleJS.STARTUP.info("Invalid spawn syntax! Must be mod:entity_type*(minCount-maxCount):weight");
        }
    }

    public void addSpawn(class_1311 category, String spawn) {
        this.addSpawn(BiomeFilter.ALWAYS_TRUE, category, spawn);
    }

    public static ClassWrapper<class_5843> getAnchors() {
        return new ClassWrapper<class_5843>(class_5843.class);
    }
}

