/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.loot.ConditionContainer;
import dev.latvian.mods.kubejs.loot.FunctionContainer;
import dev.latvian.mods.kubejs.loot.LootTableEntry;
import dev.latvian.mods.kubejs.registry.KubeJSRegistries;
import dev.latvian.mods.kubejs.util.UtilsJS;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_40;
import net.minecraft.class_44;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import org.jetbrains.annotations.Nullable;

public class LootBuilderPool
implements FunctionContainer,
ConditionContainer {
    public class_5658 rolls = class_44.method_32448((float)1.0f);
    public class_5658 bonusRolls = null;
    public final JsonArray conditions = new JsonArray();
    public final JsonArray functions = new JsonArray();
    public final JsonArray entries = new JsonArray();

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("rolls", UtilsJS.numberProviderJson(this.rolls));
        if (this.bonusRolls != null) {
            json.add("bonus_rolls", UtilsJS.numberProviderJson(this.bonusRolls));
        }
        if (this.conditions.size() > 0) {
            json.add("conditions", (JsonElement)this.conditions);
        }
        if (this.functions.size() > 0) {
            json.add("functions", (JsonElement)this.functions);
        }
        if (this.entries.size() > 0) {
            json.add("entries", (JsonElement)this.entries);
        } else {
            json.add("entries", (JsonElement)new JsonArray());
        }
        return json;
    }

    public void setUniformRolls(float min, float max) {
        this.rolls = class_5662.method_32462((float)min, (float)max);
    }

    public void setBinomialRolls(int n, float p) {
        this.rolls = class_40.method_273((int)n, (float)p);
    }

    @Override
    public LootBuilderPool addFunction(JsonObject o) {
        this.functions.add((JsonElement)o);
        return this;
    }

    @Override
    public LootBuilderPool addCondition(JsonObject o) {
        this.conditions.add((JsonElement)o);
        return this;
    }

    public LootTableEntry addEntry(JsonObject json) {
        this.entries.add((JsonElement)json);
        return new LootTableEntry(json);
    }

    public LootTableEntry addEmpty(int weight) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:empty");
        return this.addEntry(json).weight(weight);
    }

    public LootTableEntry addLootTable(class_2960 table) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:loot_table");
        json.addProperty("name", table.toString());
        return this.addEntry(json);
    }

    public LootTableEntry addItem(class_1799 item, int weight, @Nullable class_5658 count) {
        class_2960 id = KubeJSRegistries.items().getId((Object)item.method_7909());
        if (id == null || item.method_7960()) {
            return new LootTableEntry(new JsonObject());
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:item");
        json.addProperty("name", id.toString());
        LootTableEntry entry = this.addEntry(json);
        if (weight >= 0) {
            entry.weight(weight);
        }
        if (count == null && item.method_7947() > 1) {
            count = class_44.method_32448((float)item.method_7947());
        }
        if (count != null) {
            entry.count(count);
        }
        if (item.method_7969() != null) {
            entry.nbt(item.method_7969());
        }
        return entry;
    }

    public LootTableEntry addItem(class_1799 item, int weight) {
        return this.addItem(item, weight, null);
    }

    public LootTableEntry addItem(class_1799 item) {
        return this.addItem(item, -1, null);
    }

    public LootTableEntry addTag(String tag, boolean expand) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:tag");
        json.addProperty("name", tag);
        json.addProperty("expand", Boolean.valueOf(expand));
        return this.addEntry(json);
    }
}

