/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.ingredientaction;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.hooks.item.ItemStackHooks;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.DamageAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientActionFilter;
import dev.latvian.mods.kubejs.recipe.ingredientaction.KeepAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.ReplaceAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public abstract class IngredientAction
extends IngredientActionFilter {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final Map<String, Function<JsonObject, IngredientAction>> FACTORY_MAP = new HashMap<String, Function<JsonObject, IngredientAction>>();

    public static List<IngredientAction> parseList(JsonElement json) {
        if (json == null || !json.isJsonArray()) {
            return List.of();
        }
        ArrayList<IngredientAction> list = new ArrayList<IngredientAction>();
        for (JsonElement e : json.getAsJsonArray()) {
            JsonObject o = e.getAsJsonObject();
            Function<JsonObject, IngredientAction> factory = FACTORY_MAP.get(o.has("type") ? o.get("type").getAsString() : "");
            IngredientAction action = factory == null ? null : factory.apply(o);
            if (action == null) continue;
            action.filterIndex = o.has("filter_index") ? o.get("filter_index").getAsInt() : -1;
            action.filterIngredient = o.has("filter_ingredient") ? IngredientJS.of(o.get("filter_ingredient")) : null;
            list.add(action);
        }
        return list.isEmpty() ? List.of() : list;
    }

    public static List<IngredientAction> readList(class_2540 buf) {
        int s = buf.method_10816();
        if (s <= 0) {
            return List.of();
        }
        ArrayList<IngredientAction> list = new ArrayList<IngredientAction>();
        for (int i = 0; i < s; ++i) {
            IngredientAction action;
            Function<JsonObject, IngredientAction> factory = FACTORY_MAP.get(buf.method_19772());
            IngredientAction ingredientAction = action = factory == null ? null : factory.apply((JsonObject)GSON.fromJson(buf.method_19772(), JsonObject.class));
            if (action == null) continue;
            action.filterIndex = buf.method_10816();
            String ij = buf.method_19772();
            action.filterIngredient = ij.isEmpty() ? null : IngredientJS.of(GSON.fromJson(ij, JsonObject.class));
            list.add(action);
        }
        return list.isEmpty() ? List.of() : list;
    }

    public static void writeList(class_2540 buf, @Nullable List<IngredientAction> list) {
        if (list == null || list.isEmpty()) {
            buf.method_10804(0);
            return;
        }
        buf.method_10804(list.size());
        for (IngredientAction action : list) {
            buf.method_10814(action.getType());
            JsonObject json = new JsonObject();
            action.toJson(json);
            buf.method_10814(GSON.toJson((JsonElement)json));
            buf.method_10804(action.filterIndex);
            buf.method_10814(action.filterIngredient == null ? "" : GSON.toJson(action.filterIngredient.method_8089()));
        }
    }

    public static class_1799 getRemaining(class_1715 container, int index, List<IngredientAction> ingredientActions) {
        class_1799 stack = container.method_5438(index);
        if (stack == null || stack.method_7960()) {
            return class_1799.field_8037;
        }
        for (IngredientAction action : ingredientActions) {
            if (!action.checkFilter(index, stack)) continue;
            return action.transform(stack.method_7972(), index, container);
        }
        if (ItemStackHooks.hasCraftingRemainingItem((class_1799)stack)) {
            return ItemStackHooks.getCraftingRemainingItem((class_1799)stack);
        }
        return class_1799.field_8037;
    }

    public abstract class_1799 transform(class_1799 var1, int var2, class_1715 var3);

    public abstract String getType();

    public void toJson(JsonObject json) {
    }

    public final JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        if (this.filterIngredient != null) {
            json.add("filter_ingredient", this.filterIngredient.method_8089());
        }
        if (this.filterIndex != -1) {
            json.addProperty("filter_index", (Number)this.filterIndex);
        }
        this.toJson(json);
        return json;
    }

    static {
        FACTORY_MAP.put("custom", json -> new CustomIngredientAction(json.get("id").getAsString()));
        FACTORY_MAP.put("damage", json -> new DamageAction(json.get("damage").getAsInt()));
        FACTORY_MAP.put("replace", json -> new ReplaceAction(ItemStackJS.resultFromRecipeJson(json.get("item"))));
        FACTORY_MAP.put("keep", json -> new KeepAction());
    }
}

