/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.BuilderFactory;
import dev.latvian.mods.kubejs.registry.BuilderType;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1535;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2556;
import net.minecraft.class_2582;
import net.minecraft.class_2591;
import net.minecraft.class_2806;
import net.minecraft.class_2874;
import net.minecraft.class_2922;
import net.minecraft.class_2939;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3195;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_3611;
import net.minecraft.class_3773;
import net.minecraft.class_3785;
import net.minecraft.class_3816;
import net.minecraft.class_3827;
import net.minecraft.class_3828;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4140;
import net.minecraft.class_4149;
import net.minecraft.class_4158;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4648;
import net.minecraft.class_4652;
import net.minecraft.class_4663;
import net.minecraft.class_4996;
import net.minecraft.class_5142;
import net.minecraft.class_5202;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5338;
import net.minecraft.class_5339;
import net.minecraft.class_5342;
import net.minecraft.class_5363;
import net.minecraft.class_5497;
import net.minecraft.class_5650;
import net.minecraft.class_5657;
import net.minecraft.class_5669;
import net.minecraft.class_5712;
import net.minecraft.class_5717;
import net.minecraft.class_5864;
import net.minecraft.class_6018;
import net.minecraft.class_6123;
import net.minecraft.class_6647;
import net.minecraft.class_6796;
import net.minecraft.class_6798;
import net.minecraft.class_6875;
import net.minecraft.class_6910;
import net.minecraft.class_7059;
import net.minecraft.class_7106;
import net.minecraft.class_7142;
import net.minecraft.class_7145;
import net.minecraft.class_7151;
import net.minecraft.class_7375;
import net.minecraft.class_7388;
import net.minecraft.class_7444;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegistryInfo
implements Iterable<BuilderBase<?>> {
    public static final Map<class_5321<? extends class_2378<?>>, RegistryInfo> MAP = Collections.synchronizedMap(new LinkedHashMap());
    public static final List<BuilderBase<?>> ALL_BUILDERS = new LinkedList();
    public static final RegistryInfo SOUND_EVENT = RegistryInfo.of(class_2378.field_25102).type(class_3414.class);
    public static final RegistryInfo FLUID = RegistryInfo.of(class_2378.field_25103).type(class_3611.class);
    public static final RegistryInfo MOB_EFFECT = RegistryInfo.of(class_2378.field_25104).type(class_1291.class).languageKeyPrefix("effect");
    public static final RegistryInfo BLOCK = RegistryInfo.of(class_2378.field_25105).type(class_2248.class);
    public static final RegistryInfo ENCHANTMENT = RegistryInfo.of(class_2378.field_25106).type(class_1887.class);
    public static final RegistryInfo ENTITY_TYPE = RegistryInfo.of(class_2378.field_25107).type(class_1299.class);
    public static final RegistryInfo ITEM = RegistryInfo.of(class_2378.field_25108).type(class_1792.class).noAutoWrap();
    public static final RegistryInfo POTION = RegistryInfo.of(class_2378.field_25109).type(class_1842.class);
    public static final RegistryInfo PARTICLE_TYPE = RegistryInfo.of(class_2378.field_25070).type(class_2396.class);
    public static final RegistryInfo BLOCK_ENTITY_TYPE = RegistryInfo.of(class_2378.field_25073).type(class_2591.class);
    public static final RegistryInfo PAINTING_VARIANT = RegistryInfo.of(class_2378.field_25074).type(class_1535.class);
    public static final RegistryInfo CUSTOM_STAT = RegistryInfo.of(class_2378.field_25075).type(class_2960.class);
    public static final RegistryInfo CHUNK_STATUS = RegistryInfo.of(class_2378.field_25076).type(class_2806.class);
    public static final RegistryInfo RULE_TEST = RegistryInfo.of(class_2378.field_25079).type(class_3827.class);
    public static final RegistryInfo POS_RULE_TEST = RegistryInfo.of(class_2378.field_25080).type(class_4996.class);
    public static final RegistryInfo MENU = RegistryInfo.of(class_2378.field_25083).type(class_3917.class);
    public static final RegistryInfo RECIPE_TYPE = RegistryInfo.of(class_2378.field_25084).type(class_3956.class);
    public static final RegistryInfo RECIPE_SERIALIZER = RegistryInfo.of(class_2378.field_25085).type(class_1865.class);
    public static final RegistryInfo ATTRIBUTE = RegistryInfo.of(class_2378.field_25086).type(class_1320.class);
    public static final RegistryInfo GAME_EVENT = RegistryInfo.of(class_2378.field_28266).type(class_5712.class);
    public static final RegistryInfo POSITION_SOURCE_TYPE = RegistryInfo.of(class_2378.field_28263).type(class_5717.class);
    public static final RegistryInfo STAT_TYPE = RegistryInfo.of(class_2378.field_25087).type(class_3448.class);
    public static final RegistryInfo VILLAGER_TYPE = RegistryInfo.of(class_2378.field_25088).type(class_3854.class);
    public static final RegistryInfo VILLAGER_PROFESSION = RegistryInfo.of(class_2378.field_25089).type(class_3852.class);
    public static final RegistryInfo POINT_OF_INTEREST_TYPE = RegistryInfo.of(class_2378.field_25090).type(class_4158.class);
    public static final RegistryInfo MEMORY_MODULE_TYPE = RegistryInfo.of(class_2378.field_25091).type(class_4140.class);
    public static final RegistryInfo SENSOR_TYPE = RegistryInfo.of(class_2378.field_25092).type(class_4149.class);
    public static final RegistryInfo SCHEDULE = RegistryInfo.of(class_2378.field_25093).type(class_4170.class);
    public static final RegistryInfo ACTIVITY = RegistryInfo.of(class_2378.field_25094).type(class_4168.class);
    public static final RegistryInfo LOOT_ENTRY = RegistryInfo.of(class_2378.field_25295).type(class_5338.class);
    public static final RegistryInfo LOOT_FUNCTION = RegistryInfo.of(class_2378.field_25296).type(class_5339.class);
    public static final RegistryInfo LOOT_ITEM = RegistryInfo.of(class_2378.field_25297).type(class_5342.class);
    public static final RegistryInfo LOOT_NUMBER_PROVIDER = RegistryInfo.of(class_2378.field_28005).type(class_5657.class);
    public static final RegistryInfo LOOT_NBT_PROVIDER = RegistryInfo.of(class_2378.field_28006).type(class_5650.class);
    public static final RegistryInfo LOOT_SCORE_PROVIDER = RegistryInfo.of(class_2378.field_28007).type(class_5669.class);
    public static final RegistryInfo COMMAND_ARGUMENT_TYPE = RegistryInfo.of(class_2378.field_37997).type(class_2314.class);
    public static final RegistryInfo DIMENSION_TYPE = RegistryInfo.of(class_2378.field_25095).type(class_2874.class);
    public static final RegistryInfo DIMENSION = RegistryInfo.of(class_2378.field_25298).type(class_1937.class);
    public static final RegistryInfo LEVEL_STEM = RegistryInfo.of(class_2378.field_25490).type(class_5363.class);
    public static final RegistryInfo FLOAT_PROVIDER_TYPE = RegistryInfo.of(class_2378.field_29075).type(class_5864.class);
    public static final RegistryInfo INT_PROVIDER_TYPE = RegistryInfo.of(class_2378.field_33092).type(class_6018.class);
    public static final RegistryInfo HEIGHT_PROVIDER_TYPE = RegistryInfo.of(class_2378.field_33094).type(class_6123.class);
    public static final RegistryInfo BLOCK_PREDICATE_TYPE = RegistryInfo.of(class_2378.field_35089).type(class_6647.class);
    public static final RegistryInfo NOISE_GENERATOR_SETTINGS = RegistryInfo.of(class_2378.field_26374).type(class_5284.class);
    public static final RegistryInfo CONFIGURED_CARVER = RegistryInfo.of(class_2378.field_25913).type(class_2922.class);
    public static final RegistryInfo CONFIGURED_FEATURE = RegistryInfo.of(class_2378.field_25914).type(class_2975.class);
    public static final RegistryInfo PLACED_FEATURE = RegistryInfo.of(class_2378.field_35758).type(class_6796.class);
    public static final RegistryInfo STRUCTURE = RegistryInfo.of(class_2378.field_25915).type(class_3195.class);
    public static final RegistryInfo STRUCTURE_SET = RegistryInfo.of(class_2378.field_37227).type(class_7059.class);
    public static final RegistryInfo PROCESSOR_LIST = RegistryInfo.of(class_2378.field_25916).type(class_5497.class);
    public static final RegistryInfo TEMPLATE_POOL = RegistryInfo.of(class_2378.field_25917).type(class_3785.class);
    public static final RegistryInfo BIOME = RegistryInfo.of(class_2378.field_25114).type(class_1959.class);
    public static final RegistryInfo NOISE = RegistryInfo.of(class_2378.field_35433).type(class_5216.class_5487.class);
    public static final RegistryInfo DENSITY_FUNCTION = RegistryInfo.of(class_2378.field_37228).type(class_6910.class);
    public static final RegistryInfo WORLD_PRESET = RegistryInfo.of(class_2378.field_37998).type(class_7145.class);
    public static final RegistryInfo FLAT_LEVEL_GENERATOR_PRESET = RegistryInfo.of(class_2378.field_37999).type(class_7142.class);
    public static final RegistryInfo CARVER = RegistryInfo.of(class_2378.field_25110).type(class_2939.class);
    public static final RegistryInfo FEATURE = RegistryInfo.of(class_2378.field_25112).type(class_3031.class);
    public static final RegistryInfo STRUCTURE_PLACEMENT_TYPE = RegistryInfo.of(class_2378.field_36466).type(class_6875.class);
    public static final RegistryInfo STRUCTURE_PIECE = RegistryInfo.of(class_2378.field_25078).type(class_3773.class);
    public static final RegistryInfo STRUCTURE_TYPE = RegistryInfo.of(class_2378.field_25077).type(class_7151.class);
    public static final RegistryInfo PLACEMENT_MODIFIER = RegistryInfo.of(class_2378.field_35759).type(class_6798.class);
    public static final RegistryInfo BLOCK_STATE_PROVIDER_TYPE = RegistryInfo.of(class_2378.field_25115).type(class_4652.class);
    public static final RegistryInfo FOLIAGE_PLACER_TYPE = RegistryInfo.of(class_2378.field_25117).type(class_4648.class);
    public static final RegistryInfo TRUNK_PLACER_TYPE = RegistryInfo.of(class_2378.field_25118).type(class_5142.class);
    public static final RegistryInfo TREE_DECORATOR_TYPE = RegistryInfo.of(class_2378.field_25068).type(class_4663.class);
    public static final RegistryInfo ROOT_PLACER_TYPE = RegistryInfo.of(class_2378.field_38806).type(class_7388.class);
    public static final RegistryInfo FEATURE_SIZE_TYPE = RegistryInfo.of(class_2378.field_25069).type(class_5202.class);
    public static final RegistryInfo BIOME_SOURCE = RegistryInfo.of(class_2378.field_25071).type(Codec.class).noAutoWrap();
    public static final RegistryInfo CHUNK_GENERATOR = RegistryInfo.of(class_2378.field_25072).type(Codec.class).noAutoWrap();
    public static final RegistryInfo CONDITION = RegistryInfo.of(class_2378.field_35305).type(Codec.class).noAutoWrap();
    public static final RegistryInfo RULE = RegistryInfo.of(class_2378.field_35306).type(Codec.class).noAutoWrap();
    public static final RegistryInfo DENSITY_FUNCTION_TYPE = RegistryInfo.of(class_2378.field_37229).type(Codec.class).noAutoWrap();
    public static final RegistryInfo STRUCTURE_PROCESSOR = RegistryInfo.of(class_2378.field_25081).type(class_3828.class);
    public static final RegistryInfo STRUCTURE_POOL_ELEMENT = RegistryInfo.of(class_2378.field_25082).type(class_3816.class);
    public static final RegistryInfo CHAT_TYPE = RegistryInfo.of(class_2378.field_39205).type(class_2556.class);
    public static final RegistryInfo CAT_VARIANT = RegistryInfo.of(class_2378.field_38802).type(class_7375.class);
    public static final RegistryInfo FROG_VARIANT = RegistryInfo.of(class_2378.field_38804).type(class_7106.class);
    public static final RegistryInfo BANNER_PATTERN = RegistryInfo.of(class_2378.field_39207).type(class_2582.class);
    public static final RegistryInfo INSTRUMENT = RegistryInfo.of(class_2378.field_39209).type(class_7444.class);
    public static final LinkedList<RegistryInfo> AFTER_VANILLA = new LinkedList();
    public final class_5321<? extends class_2378<?>> key;
    public Class<?> objectBaseClass;
    public final Map<String, BuilderType> types;
    public final Map<class_2960, BuilderBase<?>> objects;
    public boolean hasDefaultTags = false;
    private BuilderType defaultType;
    public boolean bypassServerOnly;
    public boolean autoWrap;
    public String languageKeyPrefix;

    public static RegistryInfo of(class_5321<? extends class_2378<?>> key) {
        return MAP.computeIfAbsent(key, RegistryInfo::new);
    }

    private RegistryInfo(class_5321<? extends class_2378<?>> key) {
        this.key = key;
        this.objectBaseClass = Object.class;
        this.types = new LinkedHashMap<String, BuilderType>();
        this.objects = new LinkedHashMap();
        this.bypassServerOnly = false;
        this.autoWrap = true;
        this.languageKeyPrefix = key.method_29177().method_12832().replace('/', '.');
    }

    public RegistryInfo type(Class<?> baseClass) {
        this.objectBaseClass = baseClass;
        return this;
    }

    public RegistryInfo bypassServerOnly() {
        this.bypassServerOnly = true;
        return this;
    }

    public RegistryInfo languageKeyPrefix(String prefix) {
        this.languageKeyPrefix = prefix;
        return this;
    }

    public RegistryInfo noAutoWrap() {
        this.autoWrap = false;
        return this;
    }

    public void addType(String type, Class<? extends BuilderBase> builderType, BuilderFactory factory, boolean isDefault) {
        BuilderType b = new BuilderType(type, builderType, factory);
        this.types.put(type, b);
        if (isDefault) {
            if (this.defaultType != null) {
                ConsoleJS.STARTUP.warn("Previous default type '" + this.defaultType.type() + "' for registry '" + this.key.method_29177() + "' replaced with '" + type + "'!");
            }
            this.defaultType = b;
        }
    }

    public void addType(String type, Class<? extends BuilderBase<?>> builderType, BuilderFactory factory) {
        this.addType(type, builderType, factory, type.equals("basic"));
    }

    public void addBuilder(BuilderBase<?> builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Can't add null builder in registry '" + this.key.method_29177() + "'!");
        }
        if (DevProperties.get().debugInfo) {
            ConsoleJS.STARTUP.info("~ " + this.key.method_29177() + " | " + builder.id);
        }
        if (this.objects.containsKey(builder.id)) {
            throw new IllegalArgumentException("Duplicate key '" + builder.id + "' in registry '" + this.key.method_29177() + "'!");
        }
        this.objects.put(builder.id, builder);
        ALL_BUILDERS.add(builder);
    }

    @Nullable
    public BuilderType getDefaultType() {
        if (this.types.isEmpty()) {
            return null;
        }
        if (this.defaultType == null) {
            this.defaultType = this.types.values().iterator().next();
        }
        return this.defaultType;
    }

    public String toString() {
        return this.key.method_29177().toString();
    }

    public int registerObjects(BiConsumer<class_2960, Supplier<Object>> function) {
        if (DevProperties.get().debugInfo) {
            if (this.objects.isEmpty()) {
                KubeJS.LOGGER.info("Skipping " + this + " registry");
            } else {
                KubeJS.LOGGER.info("Building " + this.objects.size() + " objects of " + this + " registry");
            }
        }
        if (this.objects.isEmpty()) {
            return 0;
        }
        int added = 0;
        for (BuilderBase<?> builder : this) {
            if (builder.dummyBuilder) continue;
            if (!builder.getRegistryType().bypassServerOnly) {
                if (CommonProperties.get().serverOnly) continue;
            }
            function.accept(builder.id, builder::createTransformedObject);
            if (DevProperties.get().debugInfo) {
                ConsoleJS.STARTUP.info("+ " + this + " | " + builder.id);
            }
            ++added;
        }
        if (!this.objects.isEmpty() && DevProperties.get().debugInfo) {
            KubeJS.LOGGER.info("Registered " + added + "/" + this.objects.size() + " objects of " + this);
        }
        return added;
    }

    @Override
    @NotNull
    public Iterator<BuilderBase<?>> iterator() {
        return this.objects.values().iterator();
    }
}

