/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.conf;

import com.google.common.collect.Lists;
import com.jtorleonstudios.libraryferret.conf.Configuration;
import com.jtorleonstudios.libraryferret.conf.Props;
import com.jtorleonstudios.libraryferret.gui.AbstractScreen;
import com.jtorleonstudios.libraryferret.gui.AbstractUI;
import com.jtorleonstudios.libraryferret.gui.ScrollableTextUI;
import com.jtorleonstudios.libraryferret.utils.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class ConfigurationScreen
extends AbstractScreen {
    private final class_437 lastScreen;
    private boolean hasPropsChanged = false;
    private int listWidth;
    private final Map<String, List<Props>> propsByGroups;
    private Props currentPropsDisplayed = null;
    private List<WidgetStringList.StringEntry> currentListDisplay;
    private List<WidgetStringList.StringEntry> unsortedCurrentListDisplay;
    private String lastFilterText = "";
    private WidgetStringList propsGroupSelectionList;
    private AbstractUI rightSection;
    private class_342 search;
    private class_4185 btnSwapList;
    private class_4185 btnDone;
    private int rightSectionWidth;
    private final Configuration config;

    public ConfigurationScreen(class_437 parentScreen, String modID, Configuration cfg) {
        super((class_2561)class_2561.method_43471((String)("gui.jtorleonstudios." + modID + ".configscreen.title")));
        this.lastScreen = parentScreen;
        this.propsByGroups = new HashMap<String, List<Props>>();
        this.config = cfg;
        this.config.getPropsRegistry().values().forEach(v -> {
            if (!this.propsByGroups.containsKey(v.getGroup())) {
                ArrayList<Props> l = new ArrayList<Props>();
                l.add((Props)v);
                this.propsByGroups.put(v.getGroup(), l);
            } else {
                this.propsByGroups.get(v.getGroup()).add((Props)v);
            }
        });
    }

    public void method_25426() {
        this.listWidth = 0;
        this.propsByGroups.forEach((group, propsList) -> {
            int i1 = Math.max(this.listWidth, this.getFontRenderer().method_27525((class_5348)class_2561.method_43471((String)("gui.libraryferret.group.name." + group))) + 10);
            if (i1 > this.listWidth) {
                this.listWidth = i1;
            }
            propsList.forEach(props -> {
                int i2 = Math.max(this.listWidth, this.getFontRenderer().method_27525((class_5348)class_2561.method_43471((String)("gui.libraryferret.props.name." + props.getKey()))) + 10);
                if (i2 > this.listWidth) {
                    this.listWidth = i2;
                }
            });
        });
        this.listWidth = Math.max(Math.min(this.listWidth, this.field_22789 / 3), 100);
        this.rightSectionWidth = this.field_22789 - this.listWidth - 18;
        int doneButtonWidth = Math.min(this.rightSectionWidth, 200);
        int y = this.field_22790 - 20 - 6;
        this.btnDone = new class_4185((this.listWidth + 6 + this.field_22789 - doneButtonWidth) / 2, y, doneButtonWidth, 20, (class_2561)class_2561.method_43471((String)"gui.done"), b -> {
            if (this.btnDone.method_25369().equals(class_2561.method_43471((String)"gui.done"))) {
                this.onClose();
            } else {
                this.onSwapList();
            }
        });
        class_4185 openFile = new class_4185(6, y, this.listWidth, 20, (class_2561)class_2561.method_43471((String)"gui.libraryferret.openconfigfile"), b -> class_156.method_668().method_672(new File(this.config.getPropertiesPath())));
        this.btnSwapList = new class_4185(6, y -= 26, this.listWidth, 20, (class_2561)class_2561.method_43471((String)"menu.options"), b -> this.onSwapList());
        this.search = new class_342(this.getFontRenderer(), 7, y -= 21, this.listWidth - 2, 14, (class_2561)class_2561.method_43471((String)"gui.libraryferret.search"));
        this.propsGroupSelectionList = new WidgetStringList(this.listWidth, 6, this.search.field_22761 - this.getLineHeight() - 6);
        this.propsGroupSelectionList.method_25333(6);
        this.rightSection = this.currentPropsDisplayed == null ? new WelcomeSection(this, this.listWidth + 12, 6, this.rightSectionWidth, this.btnDone.field_22761 - 12) : new PropsSection(this, this.currentPropsDisplayed, this.listWidth + 12, 6, this.rightSectionWidth, this.btnDone.field_22761 - 12);
        this.method_37063((class_364)this.propsGroupSelectionList);
        this.method_37063((class_364)this.rightSection);
        this.method_37063((class_364)this.search);
        this.method_37063((class_364)this.btnDone);
        this.method_37063((class_364)openFile);
        this.method_37063((class_364)this.btnSwapList);
        this.method_20085((class_364)this.search);
        this.btnSwapList.field_22763 = false;
    }

    public void method_25394(class_4587 mStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(mStack);
        super.method_25394(mStack, mouseX, mouseY, partialTicks);
        class_5250 text = class_2561.method_43471((String)"gui.libraryferret.search");
        int x = this.propsGroupSelectionList.getLeft() + (this.propsGroupSelectionList.getRight() - this.propsGroupSelectionList.getLeft()) / 2 - this.getFontRenderer().method_27525((class_5348)text) / 2;
        this.getFontRenderer().method_27528(mStack, text.method_30937(), (float)x, (float)(this.search.field_22761 - this.getLineHeight()), 0xFFFFFF);
    }

    public void method_25393() {
        this.search.method_1865();
        this.rightSection.tick();
        if (!this.search.method_1882().equals(this.lastFilterText)) {
            this.reloadProps();
            this.propsGroupSelectionList.refreshList();
        }
    }

    public void onClose() {
        if (this.field_22787 != null) {
            if (this.hasPropsChanged) {
                this.field_22787.method_1507((class_437)new class_410(b -> {
                    if (b) {
                        this.config.save();
                    }
                    this.field_22787.method_1507(this.lastScreen);
                }, (class_2561)class_2561.method_43471((String)"gui.libraryferret.requiresave.title"), (class_2561)class_2561.method_43471((String)"gui.libraryferret.requiresave.message")));
            } else {
                this.field_22787.method_1507(this.lastScreen);
            }
        } else {
            this.config.save();
        }
    }

    private void onSwapList() {
        if (this.currentPropsDisplayed != null) {
            this.setCurrentPropsDisplayed(null);
        }
        this.propsGroupSelectionList.swapList();
    }

    public void method_25410(class_310 mc, int width, int height) {
        String s = this.search.method_1882();
        this.method_25423(mc, width, height);
        this.search.method_1852(s);
        if (!this.search.method_1882().isEmpty()) {
            this.reloadProps();
        }
    }

    private void reloadProps() {
        this.currentListDisplay = this.unsortedCurrentListDisplay.stream().filter(v -> ConfigurationScreen.stripColor(v.value).toLowerCase().contains(this.search.method_1882().toLowerCase())).collect(Collectors.toList());
        this.lastFilterText = this.search.method_1882();
    }

    private void setCurrentPropsDisplayed(@Nullable Props p) {
        this.method_37066((class_364)this.rightSection);
        this.currentPropsDisplayed = p;
        this.rightSection = this.currentPropsDisplayed == null ? new WelcomeSection(this, this.listWidth + 12, 6, this.rightSectionWidth, this.btnDone.field_22761 - 12) : new PropsSection(this, this.currentPropsDisplayed, this.listWidth + 12, 6, this.rightSectionWidth, this.btnDone.field_22761 - 12);
        this.method_37063((class_364)this.rightSection);
    }

    private void setCurrentListDisplayed(List<WidgetStringList.StringEntry> v) {
        this.currentListDisplay = Collections.unmodifiableList(v);
        this.unsortedCurrentListDisplay = this.currentListDisplay;
    }

    protected class WidgetStringList
    extends class_4280<StringEntry> {
        public WidgetStringList(int listWidth, int top, int bottom) {
            super(ConfigurationScreen.this.field_22787, listWidth, ConfigurationScreen.this.field_22790, top, bottom, ConfigurationScreen.this.getLineHeight() + 8);
            this.swapList();
        }

        public void setSelected(StringEntry entry) {
            StringEntry lastSelected = (StringEntry)this.method_25334();
            super.method_25313((class_350.class_351)entry);
            if (entry == null) {
                if (ConfigurationScreen.this.rightSection instanceof WelcomeSection) {
                    ((WelcomeSection)ConfigurationScreen.this.rightSection).weclome.setTexts(class_1074.method_4662((String)"gui.libraryferret.config_welcome", (Object[])new Object[0]));
                }
            } else {
                if (!ConfigurationScreen.this.btnSwapList.field_22763) {
                    ConfigurationScreen.this.btnSwapList.field_22763 = true;
                }
                if (ConfigurationScreen.this.propsByGroups.containsKey(entry.keyGroup)) {
                    if (ConfigurationScreen.this.currentPropsDisplayed != null) {
                        ConfigurationScreen.this.setCurrentPropsDisplayed(null);
                    }
                    if (entry.equals((Object)lastSelected)) {
                        this.swapList();
                    } else if (ConfigurationScreen.this.rightSection instanceof WelcomeSection) {
                        ((WelcomeSection)ConfigurationScreen.this.rightSection).weclome.setTexts(class_1074.method_4662((String)("gui.libraryferret.group.description." + entry.keyGroup), (Object[])new Object[0]));
                    }
                } else if (ConfigurationScreen.this.config.getPropsRegistry().containsKey(entry.keyProps)) {
                    ConfigurationScreen.this.setCurrentPropsDisplayed(ConfigurationScreen.this.config.getPropsRegistry().get(entry.keyProps));
                } else {
                    System.err.println("not implemented 565 :" + entry.value);
                }
            }
        }

        public void swapList() {
            this.method_25339();
            if (this.method_25334() != null && ConfigurationScreen.this.propsByGroups.containsKey(((StringEntry)this.method_25334()).keyGroup)) {
                ArrayList<StringEntry> l = new ArrayList<StringEntry>();
                ConfigurationScreen.this.propsByGroups.get(((StringEntry)this.method_25334()).keyGroup).forEach(v -> {
                    l.add(new StringEntry("gui.libraryferret.props.name." + v.getKey(), null, v.getKey()));
                    this.method_25321((class_350.class_351)new StringEntry("gui.libraryferret.props.name." + v.getKey(), null, v.getKey()));
                });
                ConfigurationScreen.this.setCurrentListDisplayed(l);
                ConfigurationScreen.this.btnSwapList.method_25355((class_2561)class_2561.method_43471((String)"gui.back"));
                ConfigurationScreen.this.btnDone.method_25355((class_2561)class_2561.method_43471((String)"gui.back"));
                ConfigurationScreen.this.btnSwapList.field_22763 = true;
            } else {
                this.setSelected(null);
                ArrayList<StringEntry> l = new ArrayList<StringEntry>();
                ConfigurationScreen.this.propsByGroups.keySet().forEach(k -> {
                    l.add(new StringEntry("gui.libraryferret.group.name." + k, (String)k, null));
                    this.method_25321((class_350.class_351)new StringEntry("gui.libraryferret.group.name." + k, (String)k, null));
                });
                ConfigurationScreen.this.setCurrentListDisplayed(l);
                ConfigurationScreen.this.btnSwapList.method_25355((class_2561)class_2561.method_43471((String)"menu.options"));
                ConfigurationScreen.this.btnDone.method_25355((class_2561)class_2561.method_43471((String)"gui.done"));
                ConfigurationScreen.this.btnSwapList.field_22763 = false;
            }
            super.method_25313(null);
        }

        public void refreshList() {
            this.method_25339();
            ConfigurationScreen.this.currentListDisplay.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        }

        protected int method_25329() {
            return ConfigurationScreen.this.listWidth;
        }

        public int method_25322() {
            return ConfigurationScreen.this.listWidth;
        }

        protected void method_25325(class_4587 stack) {
            ConfigurationScreen.this.method_25420(stack);
        }

        protected boolean method_25316() {
            return ConfigurationScreen.this.method_25399() == this;
        }

        public int getLeft() {
            return this.field_19088;
        }

        public int getRight() {
            return this.field_19087;
        }

        public final class StringEntry
        extends class_4280.class_4281<StringEntry> {
            private final String value;
            private final String keyGroup;
            private final String keyProps;

            public StringEntry(String value, String keyGroup, String keyProps) {
                this.value = value;
                this.keyGroup = keyGroup;
                this.keyProps = keyProps;
            }

            public void method_25343(class_4587 mStack, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
                class_5250 n = class_2561.method_43471((String)this.value);
                class_327 font = ConfigurationScreen.this.getFontRenderer();
                font.method_27528(mStack, class_2477.method_10517().method_30934(class_5348.method_29433((class_5348[])new class_5348[]{font.method_1714((class_5348)n, ConfigurationScreen.this.listWidth)})), (float)(left + 3), (float)(top + 2), 0xFFFFFF);
            }

            public boolean method_25402(double a, double b, int c) {
                if (c == 0) {
                    WidgetStringList.this.setSelected(this);
                    return true;
                }
                return false;
            }

            public int hashCode() {
                int result = 1;
                result = 31 * result + ((Object)((Object)this.getEnclosingInstance())).hashCode();
                result = 31 * result + Objects.hash(this.keyGroup, this.keyProps, this.value);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (((Object)((Object)this)).getClass() != obj.getClass()) {
                    return false;
                }
                StringEntry other = (StringEntry)((Object)obj);
                if (!((Object)((Object)this.getEnclosingInstance())).equals((Object)other.getEnclosingInstance())) {
                    return false;
                }
                return Objects.equals(this.keyGroup, other.keyGroup) && Objects.equals(this.keyProps, other.keyProps) && Objects.equals(this.value, other.value);
            }

            private WidgetStringList getEnclosingInstance() {
                return WidgetStringList.this;
            }

            public class_2561 method_37006() {
                return class_2561.method_43471((String)this.value);
            }
        }
    }

    private final class WelcomeSection
    extends AbstractUI {
        private final List<class_364> children;
        private final ScrollableTextUI weclome;

        public WelcomeSection(AbstractScreen parent, int x, int y, int w, int h) {
            super(parent, x, y, w, h);
            this.children = new ArrayList<class_364>();
            this.weclome = new ScrollableTextUI(ConfigurationScreen.this, class_1074.method_4662((String)"gui.libraryferret.config_welcome", (Object[])new Object[0]), x, 6, w, this.bottom - 6);
            this.children.add((class_364)this.weclome);
        }

        public void method_25394(class_4587 matrix, int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            this.weclome.method_25394(matrix, mouseX, mouseY, partialTicks);
        }

        @Override
        public List<? extends class_364> method_25396() {
            return this.children;
        }
    }

    private class PropsSection
    extends AbstractUI {
        private final List<class_364> children;
        private final class_4185 btnReset;
        private final ScrollableTextUI description;
        private final Props props;
        private final class_5250 textLine1;
        private final class_5250 textLine2;
        private final class_5250 textLine3;
        private final class_5250 textLine4;
        private class_342 input;
        private class_4185 inputButton;
        private class_357 slide;

        public PropsSection(AbstractScreen parent, Props propsDisplayed, int x, int y, int w, int h) {
            super(parent, x, y, w, h);
            this.children = Lists.newArrayList();
            this.input = null;
            this.inputButton = null;
            this.slide = null;
            this.props = propsDisplayed;
            this.textLine1 = class_2561.method_43469((String)"gui.libraryferret.props.title_value", (Object[])new Object[]{class_2561.method_43471((String)("gui.libraryferret.props.name." + this.props.getKey()))});
            this.textLine2 = class_2561.method_43469((String)"gui.libraryferret.props.key_value", (Object[])new Object[]{this.props.getKey()});
            this.textLine3 = class_2561.method_43469((String)"gui.libraryferret.props.default_value", (Object[])new Object[]{this.props.getDefaultValue()});
            this.textLine4 = class_2561.method_43469((String)"gui.libraryferret.props.type_value", (Object[])new Object[]{this.props.getType()});
            int numberLinesBeforeInput = 4;
            int inputWidth = this.width / 2;
            int inputX = this.x + 6;
            int inputY = 12 + (ConfigurationScreen.this.getLineHeight() + 6) * numberLinesBeforeInput;
            if (this.props.getType().contains("boolean")) {
                ConfigurationScreen configurationScreen2 = ConfigurationScreen.this;
                Objects.requireNonNull(configurationScreen2);
                this.inputButton = configurationScreen2.new OptionToggleWidget(inputX, inputY, inputWidth, this.props);
                this.children.add((class_364)this.inputButton);
            } else if (!(this.props.getType().contains("number") || this.props.getType().contains("int") || this.props.getType().contains("double") || this.props.getType().contains("float") || this.props.getType().contains("long"))) {
                if (!this.props.getType().contains("item") && !this.props.getType().contains("block")) {
                    if (this.props.getType().contains("color")) {
                        ConfigurationScreen configurationScreen3 = ConfigurationScreen.this;
                        Objects.requireNonNull(configurationScreen3);
                        this.input = configurationScreen3.new OptionColorTextWidget(inputX += 26, inputY, inputWidth, this.props);
                        this.children.add((class_364)this.input);
                    } else if (!this.props.getType().contains("key") && !this.props.getType().contains("input")) {
                        ConfigurationScreen configurationScreen4 = ConfigurationScreen.this;
                        Objects.requireNonNull(configurationScreen4);
                        this.input = configurationScreen4.new OptionTextWidget(inputX, inputY, inputWidth, this.props);
                        if (this.props.getType().contains("char")) {
                            this.input.method_1880(1);
                        }
                        this.children.add((class_364)this.input);
                    } else {
                        ConfigurationScreen configurationScreen5 = ConfigurationScreen.this;
                        Objects.requireNonNull(configurationScreen5);
                        this.inputButton = configurationScreen5.new OptionKeyBindWidget(inputX, inputY, inputWidth, this.props);
                        this.children.add((class_364)this.inputButton);
                    }
                } else {
                    ConfigurationScreen configurationScreen6 = ConfigurationScreen.this;
                    Objects.requireNonNull(configurationScreen6);
                    this.input = configurationScreen6.new OptionItemStackTextWidget(inputX += 26, inputY, inputWidth, this.props);
                    this.children.add((class_364)this.input);
                }
            } else {
                ConfigurationScreen configurationScreen7 = ConfigurationScreen.this;
                Objects.requireNonNull(configurationScreen7);
                this.slide = configurationScreen7.new OptionSliderWidget(inputX, inputY, inputWidth, this.props);
                this.children.add((class_364)this.slide);
            }
            int btnResetX = inputX + inputWidth + 6;
            this.btnReset = new class_4185(btnResetX, inputY, this.right - btnResetX - 6, 20, (class_2561)class_2561.method_43471((String)"controls.reset"), e -> {
                ConfigurationScreen.this.config.reset(this.props);
                ConfigurationScreen.this.setCurrentPropsDisplayed(this.props);
                if (!ConfigurationScreen.this.hasPropsChanged) {
                    ConfigurationScreen.this.hasPropsChanged = true;
                }
            });
            this.children.add((class_364)this.btnReset);
            int descriptionY = inputY + 20 + 6;
            this.description = new ScrollableTextUI(ConfigurationScreen.this, class_1074.method_4662((String)("gui.libraryferret.props.description." + this.props.getKey()), (Object[])new Object[0]), x, descriptionY, w, this.bottom - descriptionY);
            this.children.add((class_364)this.description);
        }

        public void method_25394(class_4587 matrix, int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            float y = this.y + 6;
            ConfigurationScreen.this.getFontRenderer().method_30881(matrix, (class_2561)this.textLine1, (float)(this.left + 6), y, 0xFFFFFF);
            ConfigurationScreen.this.getFontRenderer().method_30881(matrix, (class_2561)this.textLine2, (float)(this.left + 6), y += (float)(ConfigurationScreen.this.getLineHeight() + 6), 0xFFFFFF);
            ConfigurationScreen.this.getFontRenderer().method_30881(matrix, (class_2561)this.textLine3, (float)(this.left + 6), y += (float)(ConfigurationScreen.this.getLineHeight() + 6), 0xFFFFFF);
            ConfigurationScreen.this.getFontRenderer().method_30881(matrix, (class_2561)this.textLine4, (float)(this.left + 6), y += (float)(ConfigurationScreen.this.getLineHeight() + 6), 0xFFFFFF);
            if (this.input != null) {
                this.input.method_25394(matrix, mouseX, mouseY, partialTicks);
            } else if (this.inputButton != null) {
                this.inputButton.method_25394(matrix, mouseX, mouseY, partialTicks);
            } else if (this.slide != null) {
                this.slide.method_25394(matrix, mouseX, mouseY, partialTicks);
            }
            this.btnReset.method_25394(matrix, mouseX, mouseY, partialTicks);
            this.description.method_25394(matrix, mouseX, mouseY, partialTicks);
        }

        @Override
        public void tick() {
            if (this.input != null) {
                this.input.method_1865();
            }
        }

        @Override
        public List<? extends class_364> method_25396() {
            return this.children;
        }
    }

    private class OptionTextWidget
    extends class_342 {
        protected final Props props;

        public OptionTextWidget(int x, int y, int w, Props props) {
            super(ConfigurationScreen.this.getFontRenderer(), x, y, w, 20, (class_2561)class_2561.method_43471((String)""));
            this.props = props;
            this.method_1852(ConfigurationScreen.this.config.getStringOrDefault(props));
            this.method_1863(this::valueChanged);
        }

        private void valueChanged(String value) {
            ConfigurationScreen.this.config.set(this.props, value);
            if (!ConfigurationScreen.this.hasPropsChanged) {
                ConfigurationScreen.this.hasPropsChanged = true;
            }
        }
    }

    private class OptionColorTextWidget
    extends OptionTextWidget {
        public OptionColorTextWidget(int x, int y, int w, Props props) {
            super(x, y, w, props);
            this.method_1863(this::valueChanged);
        }

        public void method_25394(class_4587 matrix, int mouseX, int mouseY, float partialTicks) {
            super.method_25394(matrix, mouseX, mouseY, partialTicks);
            int quadX = this.field_22760 - 6 - this.method_25364();
            int quadY = this.field_22761;
            OptionColorTextWidget.method_25294((class_4587)matrix, (int)(quadX - 1), (int)(quadY - 1), (int)(this.field_22760 - 6 + 1), (int)(this.field_22761 + this.method_25364() + 1), (int)(this.method_25370() ? -1 : -6250336));
            OptionColorTextWidget.method_25294((class_4587)matrix, (int)quadX, (int)quadY, (int)(this.field_22760 - 6), (int)(this.field_22761 + this.method_25364()), (int)Color.toHex(this.method_1882()));
        }

        private void valueChanged(String value) {
            ConfigurationScreen.this.config.set(this.props, Color.isRGBorRGBA(value) ? Color.toString(Color.toRGBA(value)) : Color.toString(0, 0, 0, 255));
            if (!ConfigurationScreen.this.hasPropsChanged) {
                ConfigurationScreen.this.hasPropsChanged = true;
            }
        }
    }

    private class OptionItemStackTextWidget
    extends OptionTextWidget {
        public OptionItemStackTextWidget(int x, int y, int w, Props props) {
            super(x, y, w, props);
            this.method_1863(this::valueChanged);
        }

        public void method_25394(class_4587 matrix, int mouseX, int mouseY, float partialTicks) {
            super.method_25394(matrix, mouseX, mouseY, partialTicks);
            int quadX = this.field_22760 - 6 - this.method_25364();
            int quadY = this.field_22761;
            OptionItemStackTextWidget.method_25294((class_4587)matrix, (int)(quadX - 1), (int)(quadY - 1), (int)(this.field_22760 - 6 + 1), (int)(this.field_22761 + this.method_25364() + 1), (int)(this.method_25370() ? -1 : -6250336));
            OptionItemStackTextWidget.method_25294((class_4587)matrix, (int)quadX, (int)quadY, (int)(this.field_22760 - 6), (int)(this.field_22761 + this.method_25364()), (int)Color.BLACK);
            class_2960 test = new class_2960(this.method_1882());
            class_1799 itemstack = new class_1799((class_1935)(class_2378.field_11142.method_10250(test) ? (class_1935)class_2378.field_11142.method_10223(test) : class_1802.field_8077));
            ConfigurationScreen.this.field_22788.method_4023(itemstack, quadX + 2, quadY + 2);
            ConfigurationScreen.this.field_22788.method_4025(ConfigurationScreen.this.getFontRenderer(), itemstack, quadX + 2, quadY + 2);
        }

        private void valueChanged(String value) {
            if (class_2378.field_11142.method_10250(new class_2960(this.method_1882()))) {
                ConfigurationScreen.this.config.set(this.props, value);
                if (!ConfigurationScreen.this.hasPropsChanged) {
                    ConfigurationScreen.this.hasPropsChanged = true;
                }
            }
        }
    }

    private class OptionKeyBindWidget
    extends class_4185 {
        private final Props props;
        private boolean isEdited;
        private class_3675.class_306 keyInput;

        public OptionKeyBindWidget(int x, int y, int w, Props props) {
            super(x, y, w, 20, (class_2561)class_2561.method_43471((String)""), null);
            this.props = props;
            this.isEdited = false;
            this.keyInput = class_3675.class_307.field_1668.method_1447(ConfigurationScreen.this.config.getIntOrDefault(props));
            this.method_25355((class_2561)class_2561.method_43471((String)this.keyInput.method_27445().getString()));
        }

        public void method_25306() {
            this.isEdited = !this.isEdited;
            this.method_25355((class_2561)(this.isEdited ? class_2561.method_43471((String)">").method_27693(this.keyInput.method_27445().getString()).method_27693("<") : class_2561.method_43471((String)this.keyInput.method_27445().getString())));
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.isEdited) {
                this.isEdited = false;
                this.keyInput = class_3675.method_15985((int)keyCode, (int)scanCode);
                this.method_25355((class_2561)class_2561.method_43471((String)this.keyInput.method_27445().getString()));
                ConfigurationScreen.this.config.set(this.props, this.keyInput.method_1444());
                if (!ConfigurationScreen.this.hasPropsChanged) {
                    ConfigurationScreen.this.hasPropsChanged = true;
                }
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }
    }

    private class OptionToggleWidget
    extends class_4185 {
        private final Props props;

        public OptionToggleWidget(int x, int y, int w, Props props) {
            super(x, y, w, 20, (class_2561)class_2561.method_43471((String)""), null);
            this.props = props;
            Configuration configSingleton = ConfigurationScreen.this.config;
            boolean v = configSingleton.getBoolOrDefault(props);
            this.method_25355((class_2561)class_2561.method_43471((String)(v ? "gui.libraryferret.true" : "gui.libraryferret.false")));
        }

        public void method_25306() {
            Configuration configSingleton = ConfigurationScreen.this.config;
            boolean v = !configSingleton.getBoolOrDefault(this.props);
            this.method_25355((class_2561)class_2561.method_43471((String)(v ? "gui.libraryferret.true" : "gui.libraryferret.false")));
            configSingleton.set(this.props, v);
            if (!ConfigurationScreen.this.hasPropsChanged) {
                ConfigurationScreen.this.hasPropsChanged = true;
            }
        }
    }

    private class OptionSliderWidget
    extends class_357 {
        private final Props props;

        public OptionSliderWidget(int x, int y, int w, Props props) {
            super(x, y, w, 20, (class_2561)class_2561.method_43471((String)""), 0.0);
            this.props = props;
            double p = class_3532.method_15350((double)ConfigurationScreen.this.config.getIntOrDefault(props), (double)0.0, (double)100.0);
            this.field_22753 = (p -= 0.0) / 100.0;
            this.method_25346();
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43471((String)("gui.libraryferret.props.name." + this.props.getKey())).method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)String.valueOf(ConfigurationScreen.this.config.getIntOrDefault(this.props)))));
        }

        protected void method_25344() {
            ConfigurationScreen.this.config.set(this.props, (int)class_3532.method_16436((double)class_3532.method_15350((double)this.field_22753, (double)0.0, (double)1.0), (double)0.0, (double)100.0));
            if (!ConfigurationScreen.this.hasPropsChanged) {
                ConfigurationScreen.this.hasPropsChanged = true;
            }
        }
    }
}

