/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.registry;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2277;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3719;
import net.minecraft.class_39;
import net.minecraft.class_5251;
import net.minecraft.class_5819;
import net.zestyblaze.lootr.api.blockentity.ILootBlockEntity;
import net.zestyblaze.lootr.blocks.LootrBarrelBlock;
import net.zestyblaze.lootr.blocks.LootrChestBlock;
import net.zestyblaze.lootr.blocks.LootrShulkerBlock;
import net.zestyblaze.lootr.blocks.entities.LootrInventoryBlockEntity;
import net.zestyblaze.lootr.config.LootrModConfig;
import net.zestyblaze.lootr.data.DataStorage;
import net.zestyblaze.lootr.entity.LootrChestMinecartEntity;
import net.zestyblaze.lootr.registry.LootrBlockInit;
import net.zestyblaze.lootr.registry.LootrEntityInit;
import net.zestyblaze.lootr.util.ChestUtil;
import net.zestyblaze.lootr.util.ServerAccessImpl;
import org.jetbrains.annotations.Nullable;

public class LootrCommandInit {
    private static List<class_2960> tables = null;
    private static List<String> tableNames = null;

    private static List<class_2960> getTables() {
        if (tables == null) {
            tables = new ArrayList<class_2960>(class_39.method_270());
            tableNames = tables.stream().map(class_2960::toString).collect(Collectors.toList());
        }
        return tables;
    }

    private static List<String> getProfiles() {
        return Lists.newArrayList(ServerAccessImpl.getServer().method_3793().field_14312.keySet());
    }

    private static List<String> getTableNames() {
        LootrCommandInit.getTables();
        return tableNames;
    }

    public static void createBlock(class_2168 c, @Nullable class_2248 block, @Nullable class_2960 table) {
        class_3218 world = c.method_9225();
        class_2338 pos = new class_2338(c.method_9222());
        if (table == null) {
            table = LootrCommandInit.getTables().get(world.method_8409().method_43048(LootrCommandInit.getTables().size()));
        }
        if (block == null) {
            LootrChestMinecartEntity cart = new LootrChestMinecartEntity(LootrEntityInit.LOOTR_MINECART_ENTITY, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (class_1937)world);
            class_1297 e = c.method_9228();
            if (e != null) {
                cart.method_36456(e.method_36454());
            }
            cart.method_7562(table, world.method_8409().method_43055());
            world.method_8649((class_1297)cart);
            c.method_9226((class_2561)class_2561.method_43469((String)"lootr.commands.summon", (Object[])new Object[]{class_2564.method_10885((class_2561)class_2561.method_43469((String)"lootr.commands.blockpos", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1060)).method_10982(Boolean.valueOf(true)))), table.toString()}), false);
        } else {
            class_2680 placementState = block.method_9564();
            class_1297 e = c.method_9228();
            if (e != null) {
                class_2753 prop = null;
                class_2350 dir = class_2350.method_10159((class_1297)e)[0].method_10153();
                if (placementState.method_28498((class_2769)LootrBarrelBlock.field_16320)) {
                    prop = LootrBarrelBlock.field_16320;
                } else if (placementState.method_28498((class_2769)LootrChestBlock.field_10768)) {
                    prop = LootrChestBlock.field_10768;
                    dir = e.method_5735().method_10153();
                } else if (placementState.method_28498((class_2769)LootrShulkerBlock.field_11496)) {
                    prop = LootrShulkerBlock.field_11496;
                }
                if (prop != null) {
                    placementState = (class_2680)placementState.method_11657((class_2769)prop, (Comparable)dir);
                }
            }
            world.method_8652(pos, placementState, 2);
            class_2621.method_11287((class_1922)world, (class_5819)world.method_8409(), (class_2338)pos, (class_2960)table);
            c.method_9226((class_2561)class_2561.method_43469((String)"lootr.commands.create", (Object[])new Object[]{class_2561.method_43471((String)block.method_9539()), class_2564.method_10885((class_2561)class_2561.method_43469((String)"lootr.commands.blockpos", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1060)).method_10982(Boolean.valueOf(true)))), table.toString()}), false);
        }
    }

    private static RequiredArgumentBuilder<class_2168, class_2960> suggestTables() {
        return class_2170.method_9244((String)"table", (ArgumentType)class_2232.method_9441()).suggests((c, build) -> class_2172.method_9265(LootrCommandInit.getTableNames(), (SuggestionsBuilder)build));
    }

    private static RequiredArgumentBuilder<class_2168, String> suggestProfiles() {
        return class_2170.method_9244((String)"profile", (ArgumentType)StringArgumentType.string()).suggests((c, build) -> class_2172.method_9265(LootrCommandInit.getProfiles(), (SuggestionsBuilder)build));
    }

    private static LiteralArgumentBuilder<class_2168> builder(LiteralArgumentBuilder<class_2168> builder) {
        builder.executes(c -> {
            ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43471((String)"lootr.commands.usage"), false);
            return 1;
        });
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"barrel").executes(c -> {
            LootrCommandInit.createBlock((class_2168)c.getSource(), (class_2248)LootrBlockInit.BARREL, null);
            return 1;
        })).then(LootrCommandInit.suggestTables().executes(c -> {
            LootrCommandInit.createBlock((class_2168)c.getSource(), (class_2248)LootrBlockInit.BARREL, class_2232.method_9443((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"trapped_chest").executes(c -> {
            LootrCommandInit.createBlock((class_2168)c.getSource(), (class_2248)LootrBlockInit.TRAPPED_CHEST, null);
            return 1;
        })).then(LootrCommandInit.suggestTables().executes(c -> {
            LootrCommandInit.createBlock((class_2168)c.getSource(), (class_2248)LootrBlockInit.TRAPPED_CHEST, class_2232.method_9443((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"chest").executes(c -> {
            LootrCommandInit.createBlock((class_2168)c.getSource(), (class_2248)LootrBlockInit.CHEST, null);
            return 1;
        })).then(LootrCommandInit.suggestTables().executes(c -> {
            LootrCommandInit.createBlock((class_2168)c.getSource(), (class_2248)LootrBlockInit.CHEST, class_2232.method_9443((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"shulker").executes(c -> {
            LootrCommandInit.createBlock((class_2168)c.getSource(), (class_2248)LootrBlockInit.SHULKER, null);
            return 1;
        })).then(LootrCommandInit.suggestTables().executes(c -> {
            LootrCommandInit.createBlock((class_2168)c.getSource(), (class_2248)LootrBlockInit.SHULKER, class_2232.method_9443((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").executes(c -> {
            ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Must provide player name."), true);
            return 1;
        })).then(LootrCommandInit.suggestProfiles().executes(c -> {
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"profile");
            Optional opt_profile = ((class_2168)c.getSource()).method_9211().method_3793().method_14515(playerName);
            if (!opt_profile.isPresent()) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid player name: " + playerName + ", profile not found in the cache.")));
                return 0;
            }
            GameProfile profile = (GameProfile)opt_profile.get();
            ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43470((String)(DataStorage.clearInventories(profile.getId()) ? "Cleared stored inventories for " + playerName : "No stored inventories for " + playerName + " to clear")), true);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"cart").executes(c -> {
            LootrCommandInit.createBlock((class_2168)c.getSource(), null, null);
            return 1;
        })).then(LootrCommandInit.suggestTables().executes(c -> {
            LootrCommandInit.createBlock((class_2168)c.getSource(), null, class_2232.method_9443((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(class_2170.method_9247((String)"custom").executes(c -> {
            class_2338 pos = new class_2338(((class_2168)c.getSource()).method_9222());
            class_3218 world = ((class_2168)c.getSource()).method_9225();
            class_2680 state = world.method_8320(pos);
            if (!state.method_27852(class_2246.field_10034) && !state.method_27852(class_2246.field_16328)) {
                pos = pos.method_10074();
                state = world.method_8320(pos);
            }
            if (!state.method_27852(class_2246.field_10034) && !state.method_27852(class_2246.field_16328)) {
                ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Please stand on the chest or barrel you wish to convert."), false);
            } else {
                class_2371 reference;
                class_2680 newState = LootrBlockInit.INVENTORY.method_9564();
                if (state.method_27852(class_2246.field_10034)) {
                    reference = ((class_2595)Objects.requireNonNull(world.method_8321((class_2338)pos))).field_11927;
                    newState = (class_2680)((class_2680)newState.method_11657((class_2769)class_2281.field_10768, (Comparable)((class_2350)state.method_11654((class_2769)class_2281.field_10768)))).method_11657((class_2769)class_2281.field_10772, (Comparable)((Boolean)state.method_11654((class_2769)class_2281.field_10772)));
                } else if (state.method_27852(class_2246.field_16328)) {
                    reference = ((class_3719)Objects.requireNonNull(world.method_8321((class_2338)pos))).field_16410;
                } else {
                    ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Unable to convert barrel or chest."), false);
                    return -1;
                }
                class_2371<class_1799> custom = ChestUtil.copyItemList((class_2371<class_1799>)reference);
                world.method_8544(pos);
                world.method_8501(pos, newState);
                class_2586 te = world.method_8321(pos);
                if (!(te instanceof LootrInventoryBlockEntity)) {
                    ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Unable to convert chest, BlockState is not a Lootr Inventory block."), false);
                } else {
                    LootrInventoryBlockEntity inventory = (LootrInventoryBlockEntity)te;
                    inventory.setCustomInventory(custom);
                    inventory.method_5431();
                }
            }
            return 1;
        }));
        builder.then(class_2170.method_9247((String)"id").executes(c -> {
            class_2338 pos = new class_2338(((class_2168)c.getSource()).method_9222());
            class_3218 world = ((class_2168)c.getSource()).method_9225();
            class_2586 te = world.method_8321(pos);
            if (!(te instanceof ILootBlockEntity)) {
                pos = pos.method_10074();
                te = world.method_8321(pos);
            }
            if (!(te instanceof ILootBlockEntity)) {
                ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Please stand on a valid Lootr chest."), false);
            } else {
                ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43470((String)("The ID of this inventory is: " + ((ILootBlockEntity)te).getTileId().toString())), false);
            }
            return 1;
        }));
        builder.then(class_2170.method_9247((String)"refresh").executes(c -> {
            class_2338 pos = new class_2338(((class_2168)c.getSource()).method_9222());
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            class_2586 be = level.method_8321(pos);
            if (!(be instanceof ILootBlockEntity)) {
                pos = pos.method_10074();
                be = level.method_8321(pos);
            }
            if (be instanceof ILootBlockEntity) {
                DataStorage.setRefreshing(((ILootBlockEntity)be).getTileId(), LootrModConfig.get().refresh.refresh_value);
                ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43470((String)("Container with ID " + ((ILootBlockEntity)be).getTileId() + " has been set to refresh with a delay of " + LootrModConfig.get().refresh.refresh_value)), false);
            } else {
                ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Please stand on a valid Lootr container."), false);
            }
            return 1;
        }));
        builder.then(class_2170.method_9247((String)"decay").executes(c -> {
            class_2338 pos = new class_2338(((class_2168)c.getSource()).method_9222());
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            class_2586 be = level.method_8321(pos);
            if (!(be instanceof ILootBlockEntity)) {
                pos = pos.method_10074();
                be = level.method_8321(pos);
            }
            if (be instanceof ILootBlockEntity) {
                DataStorage.setDecaying(((ILootBlockEntity)be).getTileId(), LootrModConfig.get().decay.decay_value);
                ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43470((String)("Container with ID " + ((ILootBlockEntity)be).getTileId() + " has been set to decay with a delay of " + LootrModConfig.get().decay.decay_value)), false);
            } else {
                ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Please stand on a valid Lootr container."), false);
            }
            return 1;
        }));
        builder.then(class_2170.method_9247((String)"openers").then(class_2170.method_9244((String)"location", (ArgumentType)class_2277.method_9737()).executes(c -> {
            class_2338 position = class_2277.method_9734((CommandContext)c, (String)"location").method_9704((class_2168)c.getSource());
            class_3218 world = ((class_2168)c.getSource()).method_9225();
            class_2586 tile = world.method_8321(position);
            if (tile instanceof ILootBlockEntity) {
                Set<UUID> openers = ((ILootBlockEntity)tile).getOpeners();
                ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43470((String)("Tile at location " + position + " has " + openers.size() + " openers. UUIDs as follows:")), true);
                for (UUID uuid : openers) {
                    Optional prof = ((class_2168)c.getSource()).method_9211().method_3793().method_14512(uuid);
                    ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43470((String)("UUID: " + uuid.toString() + ", user profile: " + (prof.isPresent() ? ((GameProfile)prof.get()).getName() : "null"))), true);
                }
            } else {
                ((class_2168)c.getSource()).method_9226((class_2561)class_2561.method_43470((String)("No Lootr tile exists at location: " + position)), false);
            }
            return 1;
        })));
        return builder;
    }

    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, reg, env) -> dispatcher.register(LootrCommandInit.builder((LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)class_2170.method_9247((String)"lootr").requires(p -> p.method_9259(2))))));
    }
}

