/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.megane.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lol.bai.megane.api.MeganeModule;
import lol.bai.megane.runtime.config.ModuleConfig;
import lol.bai.megane.runtime.registry.Registrar;
import lol.bai.megane.runtime.util.MeganeUtils;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.minecraft.class_1309;
import net.minecraft.class_2248;

public class Megane
implements IWailaPlugin {
    private static final Class<class_2248> BLOCK = class_2248.class;
    private static final Class<class_1309> ENTITY = class_1309.class;

    public void register(IRegistrar r) {
        FabricLoader loader = FabricLoader.getInstance();
        Registrar.INSTANCE.waila = r;
        loader.getAllMods().forEach(mod -> {
            ModMetadata metadata = mod.getMetadata();
            String modId = metadata.getId();
            if (metadata.containsCustomValue("megane:modules")) {
                metadata.getCustomValue("megane:modules").getAsArray().forEach(value -> {
                    String className;
                    boolean satisfied = true;
                    if (value.getType() == CustomValue.CvType.OBJECT) {
                        CustomValue.CvObject object = value.getAsObject();
                        className = object.get("init").getAsString();
                        if (object.containsKey("depends")) {
                            for (Map.Entry dep : object.get("depends").getAsObject()) {
                                Optional optional = loader.getModContainer((String)dep.getKey());
                                satisfied = optional.isPresent();
                                if (satisfied) {
                                    try {
                                        satisfied = VersionPredicate.parse((String)((CustomValue)dep.getValue()).getAsString()).test((Object)((ModContainer)optional.get()).getMetadata().getVersion());
                                    }
                                    catch (VersionParsingException e) {
                                        MeganeUtils.LOGGER.error("Failed to parse dependency version for module " + className, (Throwable)e);
                                        satisfied = false;
                                    }
                                }
                                if (satisfied) continue;
                                break;
                            }
                        }
                    } else {
                        className = value.getAsString();
                    }
                    satisfied = satisfied && ((ModuleConfig)MeganeUtils.MODULE_CONFIG.get()).modules.computeIfAbsent(modId, s -> new HashMap()).computeIfAbsent(className, s -> true) != false;
                    MeganeUtils.MODULE_CONFIG.save();
                    if (satisfied) {
                        try {
                            MeganeUtils.LOGGER.info("[megane] Loading {} from {}", (Object)className, (Object)modId);
                            MeganeModule entry = (MeganeModule)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            entry.registerCommon(Registrar.INSTANCE);
                            if (loader.getEnvironmentType() == EnvType.CLIENT) {
                                entry.registerClient(Registrar.INSTANCE);
                            }
                        }
                        catch (Throwable t) {
                            MeganeUtils.LOGGER.error("[megane] error when loading {} from {}", (Object)className, (Object)modId);
                            t.printStackTrace();
                        }
                    }
                });
            }
        });
    }
}

