/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.client;

import com.google.common.collect.Maps;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.client.DecorationRenderer;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_22;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;

public class MapDecorationClientHandler {
    private static final Map<MapDecorationType<?, ?>, DecorationRenderer<?>> RENDERERS = Maps.newHashMap();

    public static <T extends CustomMapDecoration> void registerCustomRenderer(MapDecorationType<T, ?> type, DecorationRenderer<T> renderer) {
        RENDERERS.put(type, renderer);
    }

    private static <T extends CustomMapDecoration> DecorationRenderer<T> simpleRenderer(MapDecorationType<T, ?> type) {
        class_2960 id = Utils.getID(type);
        class_2960 texture = new class_2960(id.method_12836(), "textures/map_markers/" + id.method_12832() + ".png");
        return new DecorationRenderer(texture);
    }

    public static <E extends CustomMapDecoration> DecorationRenderer<E> getRenderer(E decoration) {
        return MapDecorationClientHandler.getRenderer(decoration.getType());
    }

    public static <E extends CustomMapDecoration, T extends MapDecorationType<E, ?>> DecorationRenderer<E> getRenderer(T type) {
        return RENDERERS.computeIfAbsent(type, t -> MapDecorationClientHandler.simpleRenderer(type));
    }

    public static <T extends CustomMapDecoration> boolean render(T decoration, class_4587 matrixStack, class_4597 buffer, @Nullable class_22 mapData, boolean isOnFrame, int light, int index) {
        DecorationRenderer renderer = MapDecorationClientHandler.getRenderer(decoration);
        if (renderer != null) {
            return renderer.render(decoration, matrixStack, buffer, mapData, isOnFrame, light, index);
        }
        return false;
    }
}

