/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.fabric;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.mehvahdjukaar.moonlight.api.client.fabric.IFabricMenuType;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.fabric.RegistryQueue;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.AntiRepostWarning;
import net.mehvahdjukaar.moonlight.core.set.fabric.BlockSetInternalImpl;
import net.mehvahdjukaar.moonlight.fabric.FabricSetupCallbacks;
import net.mehvahdjukaar.moonlight.fabric.ResourceConditionsBridge;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_6880;
import net.minecraft.class_7477;
import org.jetbrains.annotations.ApiStatus;

public class RegHelperImpl {
    public static final Map<class_2378<?>, Map<String, RegistryQueue<?>>> REGISTRIES = new LinkedHashMap();
    private static final List<Consumer<RegHelper.AttributeEvent>> ATTRIBUTE_REGISTRATIONS = new ArrayList<Consumer<RegHelper.AttributeEvent>>();
    private static final List<Consumer<RegHelper.SpawnPlacementEvent>> SPAWN_PLACEMENT_REGISTRATIONS = new ArrayList<Consumer<RegHelper.SpawnPlacementEvent>>();
    public static final List<class_2378<?>> REG_PRIORITY = List.of(class_2378.field_11156, class_2378.field_11154, class_2378.field_11146, class_2378.field_11141, class_2378.field_11145, class_2378.field_11142, class_2378.field_11137, class_2378.field_35760, class_2378.field_16644, class_2378.field_16645, class_2378.field_11138, class_5458.field_25929, class_5458.field_35761);

    @ApiStatus.Internal
    public static void lateRegisterEntries() {
        for (Map.Entry<class_2378<?>, Map<String, RegistryQueue<?>>> m : REGISTRIES.entrySet()) {
            Map<String, RegistryQueue<?>> v = m.getValue();
            List sorted = v.keySet().stream().sorted().toList();
            for (String s : sorted) {
                v.get(s).initializeEntries();
            }
            if (m.getKey() != class_2378.field_11146) continue;
            BlockSetInternalImpl.registerEntries();
        }
        ATTRIBUTE_REGISTRATIONS.forEach(e -> e.accept(FabricDefaultAttributeRegistry::register));
        SPAWN_PLACEMENT_REGISTRATIONS.forEach(e -> e.accept(new SpawnPlacementsImpl()));
    }

    public static void finishRegistration(String modId) {
        for (Map.Entry<class_2378<?>, Map<String, RegistryQueue<?>>> r : REGISTRIES.entrySet()) {
            Map<String, RegistryQueue<?>> m = r.getValue();
            RegistryQueue<?> v = m.get(modId);
            if (v == null) continue;
            v.initializeEntries();
            m.remove(modId);
        }
    }

    public static <T, E extends T> RegSupplier<E> register(class_2960 name, Supplier<E> supplier, class_2378<T> reg) {
        if (supplier == null) {
            throw new IllegalArgumentException("Registry entry Supplier for " + name + " can't be null");
        }
        if (name.method_12836().equals("minecraft")) {
            throw new IllegalArgumentException("Registering under minecraft namespace is not supported");
        }
        String modId = name.method_12836();
        Map m = REGISTRIES.computeIfAbsent(reg, h -> new LinkedHashMap());
        RegistryQueue registry = m.computeIfAbsent(modId, c -> {
            if (PlatformHelper.getEnv().isClient()) {
                AntiRepostWarning.addMod(modId);
            }
            return new RegistryQueue(reg);
        });
        if (reg.equals((Object)class_2378.field_18792)) {
            PlatformHelper.addCommonSetup(() -> {
                class_6880 holder = class_2378.field_18792.method_40290(class_5321.method_29179((class_5321)class_2378.field_25090, (class_2960)name));
                class_7477.method_43990((class_6880)holder);
            });
        }
        return registry.add(supplier, name);
    }

    public static <T, E extends T> RegSupplier<E> registerAsync(class_2960 name, Supplier<E> supplier, class_2378<T> reg) {
        RegistryQueue.EntryWrapper<E, T> entry = new RegistryQueue.EntryWrapper<E, T>(name, supplier, reg);
        entry.initialize();
        return entry;
    }

    public static <T> void registerInBatch(class_2378<T> reg, Consumer<Registrator<T>> eventListener) {
        Map m = REGISTRIES.computeIfAbsent(reg, h -> new LinkedHashMap());
        RegistryQueue registry = m.computeIfAbsent("a", c -> new RegistryQueue(reg));
        registry.add(eventListener);
    }

    public static <C extends class_1703> RegSupplier<class_3917<C>> registerMenuType(class_2960 name, TriFunction<Integer, class_1661, class_2540, C> containerFactory) {
        return RegHelperImpl.register(name, () -> IFabricMenuType.create(containerFactory::apply), class_2378.field_17429);
    }

    public static <T extends class_1297> RegSupplier<class_1299<T>> registerEntityType(class_2960 name, class_1299.class_4049<T> factory, class_1311 category, float width, float height, int clientTrackingRange, int updateInterval) {
        Supplier<class_1299> s = () -> class_1299.class_1300.method_5903((class_1299.class_4049)factory, (class_1311)category).method_17687(width, height).method_5905(name.toString());
        return RegHelperImpl.register(name, s, class_2378.field_11145);
    }

    public static void registerItemBurnTime(class_1792 item, int burnTime) {
        FuelRegistry.INSTANCE.add((class_1935)item, (Object)burnTime);
    }

    public static void registerBlockFlammability(class_2248 item, int fireSpread, int flammability) {
        FlammableBlockRegistry.getDefaultInstance().add(item, fireSpread, flammability);
    }

    public static void registerVillagerTrades(class_3852 profession, int level, Consumer<List<class_3853.class_1652>> factories) {
        FabricSetupCallbacks.COMMON_SETUP.add(() -> TradeOfferHelper.registerVillagerOffers((class_3852)profession, (int)level, (Consumer)factories));
    }

    public static void registerWanderingTraderTrades(int level, Consumer<List<class_3853.class_1652>> factories) {
        FabricSetupCallbacks.COMMON_SETUP.add(() -> TradeOfferHelper.registerWanderingTraderOffers((int)level, (Consumer)factories));
    }

    public static void addAttributeRegistration(Consumer<RegHelper.AttributeEvent> eventListener) {
        ATTRIBUTE_REGISTRATIONS.add(eventListener);
    }

    public static void addSpawnPlacementsRegistration(Consumer<RegHelper.SpawnPlacementEvent> eventListener) {
        SPAWN_PLACEMENT_REGISTRATIONS.add(eventListener);
    }

    public static void addCommandRegistration(Consumer<CommandDispatcher<class_2168>> eventListener) {
        CommandRegistrationCallback.EVENT.register((d, s, b) -> eventListener.accept(d));
    }

    public static void registerSimpleRecipeCondition(class_2960 id, Predicate<String> predicate) {
        ResourceConditionsBridge.registerSimple(id, predicate);
    }

    public static <T extends class_1860<?>> RegSupplier<class_1865<T>> registerSpecialRecipe(class_2960 name, Function<class_2960, T> factory) {
        return RegHelper.registerRecipeSerializer(name, () -> new class_1866(factory));
    }

    public static <T extends class_3611> RegSupplier<T> registerFluid(class_2960 name, Supplier<T> fluid) {
        return RegHelperImpl.register(name, fluid, class_2378.field_11154);
    }

    static {
        REG_PRIORITY.forEach(e -> REGISTRIES.put((class_2378<?>)e, new LinkedHashMap()));
    }

    static class SpawnPlacementsImpl
    implements RegHelper.SpawnPlacementEvent {
        SpawnPlacementsImpl() {
        }

        @Override
        public <T extends class_1297> void register(class_1299<T> entityType, class_1317.class_1319 decoratorType, class_2902.class_2903 heightMapType, class_1317.class_4306<T> decoratorPredicate) {
            try {
                class_1317.method_20637(entityType, (class_1317.class_1319)decoratorType, (class_2902.class_2903)heightMapType, decoratorPredicate);
            }
            catch (Exception e) {
                Moonlight.LOGGER.warn("Skipping placement registration for {} as its not of Mob type", entityType);
            }
        }
    }
}

