/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.Path;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3288;

public class DynamicTexturePack
extends DynamicResourcePack {
    public DynamicTexturePack(class_2960 name, class_3288.class_3289 position, boolean fixed, boolean hidden) {
        super(name, class_3264.field_14188, position, fixed, hidden);
    }

    public DynamicTexturePack(class_2960 name) {
        super(name, class_3264.field_14188);
    }

    void addPackLogo() {
        Path logoPath = ClientPlatformHelper.getModIcon(this.mainNamespace);
        if (logoPath != null) {
            try {
                this.addRootResource("pack.png", Files.readAllBytes(logoPath));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addAndCloseTexture(class_2960 path, TextureImage image) {
        try (TextureImage textureImage = image;){
            this.addBytes(path, image.getImage().method_24036(), ResType.TEXTURES);
            JsonObject mcmeta = image.serializeMcMeta();
            if (mcmeta != null) {
                this.addJson(path, (JsonElement)mcmeta, ResType.MCMETA);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to add image {} to resource pack {}.", (Object)path, (Object)this.resourcePackName, (Object)e);
        }
    }

    public void addBlockModel(class_2960 modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.BLOCK_MODELS);
    }

    public void addItemModel(class_2960 modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.ITEM_MODELS);
    }

    public void addBlockState(class_2960 modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.BLOCKSTATES);
    }

    public void addLang(class_2960 langName, JsonElement language) {
        this.addJson(langName, language, ResType.LANG);
    }

    public void addLang(class_2960 langName, LangBuilder builder) {
        this.addJson(langName, builder.build(), ResType.LANG);
    }
}

