/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import com.google.common.base.Suppliers;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WoodType
extends BlockType {
    public final class_3614 material;
    public final class_2248 planks;
    public final class_2248 log;
    private final Supplier<class_4719> vanillaType = Suppliers.memoize(() -> {
        String i = this.id.method_12836().equals("minecraft") ? this.id.method_12832() : this.id.toString();
        Optional<class_4719> o = class_4719.method_24026().filter(v -> v.method_24028().equals(i)).findAny();
        return o.orElse(null);
    });

    protected WoodType(class_2960 id, class_2248 baseBlock, class_2248 logBlock) {
        super(id);
        this.planks = baseBlock;
        this.log = logBlock;
        this.material = baseBlock.method_9564().method_26207();
    }

    @Nullable
    protected class_2248 findLogRelatedBlock(String append, String postpend) {
        Optional o;
        if (this.id.method_12836().equals("tfc") && (o = class_2378.field_11146.method_17966(new class_2960(this.id.method_12836(), "wood/" + append + "_" + postpend + "/" + this.id.method_12832()))).isPresent()) {
            return (class_2248)o.get();
        }
        Object post = postpend.isEmpty() ? "" : "_" + postpend;
        class_2960 id = this.getId();
        String logN = Utils.getID(this.log).method_12832();
        class_2960[] targets = new class_2960[]{new class_2960(id.method_12836(), logN + "_" + append + (String)post), new class_2960(id.method_12836(), append + "_" + logN + (String)post), new class_2960(id.method_12836(), id.method_12832() + "_" + append + (String)post), new class_2960(id.method_12836(), append + "_" + id.method_12832() + (String)post)};
        class_2248 found = null;
        for (class_2960 r : targets) {
            if (!class_2378.field_11146.method_10250(r)) continue;
            found = (class_2248)class_2378.field_11146.method_10223(r);
            break;
        }
        return found;
    }

    public class_3614 getMaterial() {
        return this.material;
    }

    @Override
    public class_1935 mainChild() {
        return this.planks;
    }

    @Nullable
    public class_4719 toVanilla() {
        return this.vanillaType.get();
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getTypeName();
        }
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public boolean canBurn() {
        return this.material.method_15802();
    }

    public class_3620 getColor() {
        return this.material.method_15803();
    }

    @Override
    public String getTranslationKey() {
        return "wood_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("planks", this.planks);
        this.addChild("log", this.log);
        this.addChild("leaves", this.findRelatedEntry("leaves", class_2378.field_11146));
        this.addChild("stripped_log", this.findLogRelatedBlock("stripped", "log"));
        this.addChild("stripped_wood", this.findLogRelatedBlock("stripped", "wood"));
        this.addChild("wood", this.findRelatedEntry("wood", class_2378.field_11146));
        this.addChild("slab", this.findRelatedEntry("slab", class_2378.field_11146));
        this.addChild("stairs", this.findRelatedEntry("stairs", class_2378.field_11146));
        this.addChild("fence", this.findRelatedEntry("fence", class_2378.field_11146));
        this.addChild("fence_gate", this.findRelatedEntry("fence_gate", class_2378.field_11146));
        this.addChild("door", this.findRelatedEntry("door", class_2378.field_11146));
        this.addChild("trapdoor", this.findRelatedEntry("trapdoor", class_2378.field_11146));
        this.addChild("button", this.findRelatedEntry("button", class_2378.field_11146));
        this.addChild("pressure_plate", this.findRelatedEntry("pressure_plate", class_2378.field_11146));
        if (this.id.method_12836().equals("handcrafted")) {
            this.addChild("board", this.findRelatedEntry("board", class_2378.field_11146));
        }
    }

    @Override
    public void initializeChildrenItems() {
        this.addChild("boat", this.findRelatedEntry("boat", class_2378.field_11142));
        this.addChild("sign", this.findRelatedEntry("sign", class_2378.field_11142));
    }

    public static class Finder
    implements BlockType.SetFinder<WoodType> {
        private final Map<String, class_2960> childNames = new HashMap<String, class_2960>();
        private final Supplier<class_2248> planksFinder;
        private final Supplier<class_2248> logFinder;
        private final class_2960 id;

        public Finder(class_2960 id, Supplier<class_2248> planks, Supplier<class_2248> log) {
            this.id = id;
            this.planksFinder = planks;
            this.logFinder = log;
        }

        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return Finder.simple(new class_2960(modId, woodTypeName), new class_2960(modId, planksName), new class_2960(modId, logName));
        }

        public static Finder simple(class_2960 woodTypeName, class_2960 planksName, class_2960 logName) {
            return new Finder(woodTypeName, () -> (class_2248)class_2378.field_11146.method_10223(planksName), () -> (class_2248)class_2378.field_11146.method_10223(logName));
        }

        public void addChild(String childType, String childName) {
            this.addChild(childType, new class_2960(this.id.method_12836(), childName));
        }

        public void addChild(String childType, class_2960 childName) {
            this.childNames.put(childType, childName);
        }

        @Override
        @ApiStatus.Internal
        public Optional<WoodType> get() {
            if (PlatformHelper.isModLoaded(this.id.method_12836())) {
                try {
                    class_2248 plank = this.planksFinder.get();
                    class_2248 log = this.logFinder.get();
                    class_2248 d = (class_2248)class_2378.field_11146.method_10223(class_2378.field_11146.method_10137());
                    if (plank != d && log != d && plank != null && log != null) {
                        WoodType w = new WoodType(this.id, plank, log);
                        this.childNames.forEach((key, value) -> w.addChild((String)key, class_2378.field_11146.method_10223(value)));
                        return Optional.of(w);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Moonlight.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

