/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set;

import com.google.common.base.Stopwatch;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.set.fabric.BlockSetInternalImpl;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class BlockSetInternal {
    private static final Map<Class<? extends BlockType>, BlockTypeRegistry<?>> BLOCK_SET_CONTAINERS = new ConcurrentHashMap();
    private static final ConcurrentLinkedDeque<Runnable> FINDER_ADDER = new ConcurrentLinkedDeque();
    private static final ConcurrentLinkedDeque<Runnable> REMOVER_ADDER = new ConcurrentLinkedDeque();

    public static void initializeBlockSets() {
        Stopwatch sw = Stopwatch.createStarted();
        if (BlockSetInternal.hasFilledBlockSets()) {
            throw new UnsupportedOperationException("block sets have already bee initialized");
        }
        FINDER_ADDER.forEach(Runnable::run);
        FINDER_ADDER.clear();
        BLOCK_SET_CONTAINERS.values().forEach(BlockTypeRegistry::buildAll);
        BLOCK_SET_CONTAINERS.values().forEach(BlockTypeRegistry::onBlockInit);
        REMOVER_ADDER.forEach(Runnable::run);
        REMOVER_ADDER.clear();
        Moonlight.LOGGER.info("Initialized block sets in {}ms", (Object)sw.elapsed().toMillis());
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    protected static boolean hasFilledBlockSets() {
        return BlockSetInternalImpl.hasFilledBlockSets();
    }

    public static <T extends BlockType> void registerBlockSetDefinition(BlockTypeRegistry<T> typeRegistry) {
        if (BlockSetInternal.hasFilledBlockSets()) {
            throw new UnsupportedOperationException(String.format("Tried to register block set definition %s after registry events", typeRegistry));
        }
        BLOCK_SET_CONTAINERS.put(typeRegistry.getType(), typeRegistry);
    }

    public static <T extends BlockType> void addBlockTypeFinder(Class<T> type, BlockType.SetFinder<T> blockFinder) {
        if (BlockSetInternal.hasFilledBlockSets()) {
            throw new UnsupportedOperationException(String.format("Tried to register block %s finder %s after registry events", type, blockFinder));
        }
        FINDER_ADDER.add(() -> {
            BlockTypeRegistry container = BlockSetInternal.getBlockSet(type);
            container.addFinder(blockFinder);
        });
    }

    public static <T extends BlockType> void addBlockTypeRemover(Class<T> type, class_2960 id) {
        if (BlockSetInternal.hasFilledBlockSets()) {
            throw new UnsupportedOperationException(String.format("Tried to remove block type %s for type %s after registry events", id, type));
        }
        REMOVER_ADDER.add(() -> {
            BlockTypeRegistry container = BlockSetInternal.getBlockSet(type);
            container.addRemover(id);
        });
    }

    public static <T extends BlockType> BlockTypeRegistry<T> getBlockSet(Class<T> type) {
        return BLOCK_SET_CONTAINERS.get(type);
    }

    public static void addTranslations(AfterLanguageLoadEvent event) {
        BlockSetAPI.getRegistries().forEach(r -> r.addTypeTranslations(event));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockType, E> void addDynamicRegistration(BlockSetAPI.BlockTypeRegistryCallback<E, T> registrationFunction, Class<T> blockType, class_2378<E> registry) {
        void var2_2;
        void var1_1;
        BlockSetInternalImpl.addDynamicRegistration(registrationFunction, var1_1, var2_2);
    }

    @Deprecated(forRemoval=true)
    public static <T extends BlockType> void addDynamicBlockRegistration(BlockSetAPI.BlockTypeRegistryCallback<class_2248, T> registrationFunction, Class<T> blockType) {
        BlockSetInternal.addDynamicRegistration(registrationFunction, blockType, class_2378.field_11146);
    }

    @Deprecated(forRemoval=true)
    public static <T extends BlockType> void addDynamicItemRegistration(BlockSetAPI.BlockTypeRegistryCallback<class_1792, T> registrationFunction, Class<T> blockType) {
        BlockSetInternal.addDynamicRegistration(registrationFunction, blockType, class_2378.field_11142);
    }

    public static Collection<BlockTypeRegistry<?>> getRegistries() {
        return BLOCK_SET_CONTAINERS.values();
    }

    @Nullable
    public static <T extends BlockType> BlockTypeRegistry<T> getRegistry(Class<T> typeClass) {
        return BLOCK_SET_CONTAINERS.get(typeClass);
    }

    @Nullable
    public static <T extends BlockType> T getBlockTypeOf(class_1935 itemLike, Class<T> typeClass) {
        BlockTypeRegistry<T> r = BlockSetInternal.getRegistry(typeClass);
        if (r != null) {
            return r.getBlockTypeOf(itemLike);
        }
        return null;
    }
}

