/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.starfish_studios.naturalist.entity.SleepingAnimal;
import com.starfish_studios.naturalist.entity.ai.goal.BabyHurtByTargetGoal;
import com.starfish_studios.naturalist.entity.ai.goal.BabyPanicGoal;
import com.starfish_studios.naturalist.entity.ai.goal.SleepGoal;
import com.starfish_studios.naturalist.entity.ai.navigation.BetterGroundPathNavigation;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.registry.NaturalistTags;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1333;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Lion
extends class_1429
implements IAnimatable,
SleepingAnimal {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(Lion.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_MANE = class_2945.method_12791(Lion.class, (class_2941)class_2943.field_13323);

    public Lion(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6013 = 1.0f;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23717, 32.0);
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        class_1296.class_4697 ageableMobGroupData;
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(true);
            this.setHasMane(this.method_6051().method_43056());
        }
        if ((ageableMobGroupData = (class_1296.class_4697)spawnData).method_22432() > 2) {
            this.method_5614(-24000);
        }
        ageableMobGroupData.method_22435();
        class_5819 random = level.method_8409();
        this.method_5996(class_5134.field_23717).method_26837(new class_1322("Random spawn bonus", random.method_43385(0.0, 0.11485000000000001), class_1322.class_1323.field_6330));
        return spawnData;
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return (class_1296)NaturalistEntityTypes.LION.get().method_5883((class_1937)serverLevel);
    }

    protected class_1408 method_5965(class_1937 level) {
        return new BetterGroundPathNavigation((class_1308)this, level);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new LionPreyGoal((class_1314)this));
        this.field_6201.method_6277(2, (class_1352)new BabyPanicGoal((class_1314)this, 2.0));
        this.field_6201.method_6277(3, new SleepGoal<Lion>(this));
        this.field_6201.method_6277(4, (class_1352)new LionFollowParentGoal(this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new LionFollowLeaderGoal(this, 1.1, 8.0f, 24.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new BabyHurtByTargetGoal((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1314.class, 10, true, true, entity -> entity.method_5864().method_20210(NaturalistTags.EntityTypes.LION_HOSTILES) && !entity.method_6109() && !this.method_6113() && !this.method_6109() && this.method_37908().method_23886()));
    }

    public boolean method_6481(class_1799 pStack) {
        return false;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SLEEPING, (Object)false);
        this.field_6011.method_12784(HAS_MANE, (Object)false);
    }

    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        pCompound.method_10556("Mane", this.hasMane());
    }

    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        this.setHasMane(pCompound.method_10577("Mane"));
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_6113() || this.method_6062()) {
            this.field_6282 = false;
            this.field_6212 = 0.0f;
            this.field_6250 = 0.0f;
        }
    }

    protected void method_5619() {
        super.method_5619();
        this.setHasMane(this.method_6051().method_43056());
    }

    @Override
    public boolean canSleep() {
        long dayTime = this.field_6002.method_8532();
        if (this.method_5968() != null || this.field_6002.method_22351(this.method_24515())) {
            return false;
        }
        return dayTime > 6000L && dayTime < 13000L;
    }

    public void method_5958() {
        if (this.method_5962().method_6241()) {
            double speedModifier = this.method_5962().method_6242();
            if (speedModifier < 1.0 && this.method_24828()) {
                this.method_18380(class_4050.field_18081);
                this.method_5728(false);
            } else if (speedModifier >= 1.5 && this.method_24828()) {
                this.method_18380(class_4050.field_18076);
                this.method_5728(true);
            } else {
                this.method_18380(class_4050.field_18076);
                this.method_5728(false);
            }
        } else {
            this.method_18380(class_4050.field_18076);
            this.method_5728(false);
        }
    }

    public boolean method_21749() {
        return this.method_18276() || super.method_21749();
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public void setHasMane(boolean hasMane) {
        this.field_6011.method_12778(HAS_MANE, (Object)hasMane);
    }

    public boolean hasMane() {
        return (Boolean)this.field_6011.method_12789(HAS_MANE);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return NaturalistSoundEvents.LION_HURT.get();
    }

    @Nullable
    protected class_3414 method_5994() {
        return NaturalistSoundEvents.LION_AMBIENT.get();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.method_6113() && this.hasMane()) {
            event.getController().setAnimation(new AnimationBuilder().loop("sleep2"));
        } else if (this.method_6113() && !this.hasMane()) {
            event.getController().setAnimation(new AnimationBuilder().loop("sleep"));
        } else if (this.method_18798().method_37268() > 1.0E-6) {
            if (this.method_5624()) {
                event.getController().setAnimation(new AnimationBuilder().loop("run"));
                event.getController().setAnimationSpeed(2.5);
            } else if (this.method_18276()) {
                event.getController().setAnimation(new AnimationBuilder().loop("prey"));
                event.getController().setAnimationSpeed((double)0.8f);
            } else {
                event.getController().setAnimation(new AnimationBuilder().loop("walk"));
                event.getController().setAnimationSpeed(1.0);
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().loop("idle"));
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attackPredicate(AnimationEvent<E> event) {
        if (this.field_6252 && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().playOnce("attack"));
            this.field_6252 = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(10.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attackController", 0.0f, this::attackPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class LionPreyGoal
    extends class_1352 {
        protected final class_1314 mob;
        private double speedModifier = 0.5;
        private class_11 path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;

        public LionPreyGoal(class_1314 pathfinderMob) {
            this.mob = pathfinderMob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.mob.method_6109()) {
                return false;
            }
            long gameTime = this.mob.field_6002.method_8510();
            if (gameTime - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = gameTime;
            class_1309 livingEntity = this.mob.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            this.path = this.mob.method_5942().method_6349((class_1297)livingEntity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingEntity) >= this.mob.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
        }

        public boolean method_6266() {
            class_1309 livingEntity = this.mob.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            return !this.mob.method_5942().method_6357();
        }

        public void method_6269() {
            class_1309 target = this.mob.method_5968();
            if (target == null) {
                return;
            }
            this.speedModifier = this.mob.method_5739((class_1297)target) > 12.0f ? 0.5 : 1.7;
            this.mob.method_5942().method_6334(this.path, this.speedModifier);
            this.mob.method_19540(true);
            this.mob.method_43077(NaturalistSoundEvents.LION_ROAR.get());
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public void method_6270() {
            class_1309 livingEntity = this.mob.method_5968();
            if (!class_1301.field_6156.test(livingEntity)) {
                this.mob.method_5980(null);
            }
            this.mob.method_19540(false);
            this.mob.method_5942().method_6340();
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            class_1309 target = this.mob.method_5968();
            if (target == null) {
                return;
            }
            this.speedModifier = this.mob.method_5739((class_1297)target) > 12.0f ? 0.5 : 1.7;
            this.mob.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            double d = this.mob.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if (this.mob.method_5985().method_6369((class_1297)target) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.method_5649(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.method_6051().method_43057() < 0.05f)) {
                this.pathedTargetX = target.method_23317();
                this.pathedTargetY = target.method_23318();
                this.pathedTargetZ = target.method_23321();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.method_6051().method_43048(7);
                if (d > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.method_5942().method_6335((class_1297)target, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.method_38847(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(target, d);
        }

        protected void checkAndPerformAttack(class_1309 enemy, double distToEnemySqr) {
            double d = this.getAttackReachSqr(enemy);
            if (distToEnemySqr <= d && this.ticksUntilNextAttack <= 0) {
                this.resetAttackCooldown();
                this.mob.method_6104(class_1268.field_5808);
                this.mob.method_6121((class_1297)enemy);
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.method_38847(20);
        }

        protected double getAttackReachSqr(class_1309 attackTarget) {
            return this.mob.method_17681() * 2.0f * (this.mob.method_17681() * 2.0f) + attackTarget.method_17681();
        }
    }

    static class LionFollowParentGoal
    extends class_1353 {
        private final Lion lion;

        public LionFollowParentGoal(Lion animal, double speedModifier) {
            super((class_1429)animal, speedModifier);
            this.lion = animal;
        }

        public boolean method_6264() {
            return !this.lion.method_6113() && super.method_6264();
        }

        public boolean method_6266() {
            return !this.lion.method_6113() && super.method_6266();
        }
    }

    static class LionFollowLeaderGoal
    extends class_1352 {
        private final Lion mob;
        private final Predicate<class_1308> followPredicate;
        @Nullable
        private Lion followingMob;
        private final double speedModifier;
        private final class_1408 navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private float oldWaterCost;
        private final float areaSize;

        public LionFollowLeaderGoal(Lion mob, double speedModifier, float stopDistance, float areaSize) {
            this.mob = mob;
            this.followPredicate = followingMob -> followingMob != null && !followingMob.method_6109();
            this.speedModifier = speedModifier;
            this.navigation = mob.method_5942();
            this.stopDistance = stopDistance;
            this.areaSize = areaSize;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.mob.method_6109() || this.mob.hasMane()) {
                return false;
            }
            List nearbyLions = this.mob.field_6002.method_8390(Lion.class, this.mob.method_5829().method_1014((double)this.areaSize), this.followPredicate);
            if (!nearbyLions.isEmpty()) {
                for (Lion lion : nearbyLions) {
                    if (!lion.hasMane() || lion.method_5767()) continue;
                    this.followingMob = lion;
                    return true;
                }
                if (this.followingMob == null) {
                    for (Lion lion : nearbyLions) {
                        if (lion.method_6109() || lion.method_5767()) continue;
                        this.followingMob = lion;
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean method_6266() {
            return this.followingMob != null && !this.navigation.method_6357() && this.mob.method_5858((class_1297)this.followingMob) > (double)(this.stopDistance * this.stopDistance);
        }

        public void method_6269() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.mob.method_5944(class_7.field_18);
            this.mob.method_5941(class_7.field_18, 0.0f);
        }

        public void method_6270() {
            this.followingMob = null;
            this.navigation.method_6340();
            this.mob.method_5941(class_7.field_18, this.oldWaterCost);
        }

        public void method_6268() {
            double f;
            double e;
            if (this.followingMob == null || this.mob.method_5934()) {
                return;
            }
            this.mob.method_5988().method_6226((class_1297)this.followingMob, 10.0f, (float)this.mob.method_5978());
            if (--this.timeToRecalcPath > 0) {
                return;
            }
            this.timeToRecalcPath = this.method_38847(10);
            double d = this.mob.method_23317() - this.followingMob.method_23317();
            double g = d * d + (e = this.mob.method_23318() - this.followingMob.method_23318()) * e + (f = this.mob.method_23321() - this.followingMob.method_23321()) * f;
            if (g <= (double)(this.stopDistance * this.stopDistance)) {
                this.navigation.method_6340();
                class_1333 lookControl = this.followingMob.method_5988();
                if (g <= (double)this.stopDistance || lookControl.method_6225() == this.mob.method_23317() && lookControl.method_6227() == this.mob.method_23318() && lookControl.method_6228() == this.mob.method_23321()) {
                    double h = this.followingMob.method_23317() - this.mob.method_23317();
                    double i = this.followingMob.method_23321() - this.mob.method_23321();
                    this.navigation.method_6337(this.mob.method_23317() - h, this.mob.method_23318(), this.mob.method_23321() - i, this.speedModifier);
                }
                return;
            }
            this.navigation.method_6335((class_1297)this.followingMob, this.speedModifier);
        }
    }
}

