/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.HorizontalFlowLayout;
import io.wispforest.owo.ui.container.VerticalFlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.Drawer;
import io.wispforest.owo.ui.util.UISounds;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DropdownComponent
extends HorizontalFlowLayout {
    protected static final class_2960 ICONS_TEXTURE = new class_2960("owo", "textures/gui/dropdown_icons.png");
    protected final EntryList entries;
    protected boolean requiresHover = false;

    protected DropdownComponent(Sizing horizontalSizing) {
        super(Sizing.content(), Sizing.content());
        this.entries = new EntryList(horizontalSizing);
        this.child(this.entries);
    }

    @Override
    public void draw(class_4587 matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(matrices, mouseX, mouseY, partialTicks, delta);
        if (this.requiresHover && !this.isInBoundingBox(mouseX, mouseY)) {
            this.queue(() -> {
                this.requiresHover(false);
                this.parent.removeChild(this);
            });
        }
    }

    public DropdownComponent divider() {
        this.entries.child(new Divider());
        return this;
    }

    public DropdownComponent text(class_2561 text) {
        this.entries.child(Components.label(text).color(Color.ofFormatting(class_124.field_1080)));
        return this;
    }

    public DropdownComponent button(class_2561 text, Consumer<DropdownComponent> onClick) {
        this.entries.child(new Button(text, onClick));
        return this;
    }

    public DropdownComponent checkbox(class_2561 text, boolean state, Consumer<Boolean> onClick) {
        this.entries.child(new Checkbox(text, state, onClick));
        return this;
    }

    public DropdownComponent nested(class_2561 text, Sizing horizontalSizing, Consumer<DropdownComponent> builder) {
        DropdownComponent nested = new DropdownComponent(horizontalSizing);
        builder.accept(nested);
        this.entries.child(new NestEntry(text, nested));
        return this;
    }

    @Override
    public FlowLayout removeChild(Component child) {
        if (child == this.entries) {
            this.queue(() -> {
                this.requiresHover(false);
                this.parent.removeChild(this);
            });
        }
        return super.removeChild(child);
    }

    protected static void drawIconFromTexture(class_4587 matrices, ParentComponent dropdown, int y, int u, int v) {
        RenderSystem.setShaderTexture((int)0, (class_2960)ICONS_TEXTURE);
        Drawer.method_25290((class_4587)matrices, (int)(dropdown.x() + dropdown.width() - ((Insets)dropdown.padding().get()).right() - 10), (int)y, (float)u, (float)v, (int)9, (int)9, (int)32, (int)32);
    }

    public boolean requiresHover() {
        return this.requiresHover;
    }

    public DropdownComponent requiresHover(boolean requiresHover) {
        this.requiresHover = requiresHover;
        return this;
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "entries", Function.identity(), this::parseAndApplyEntries);
        UIParsing.apply(children, "requires-hover", UIParsing::parseBool, this::requiresHover);
    }

    protected void parseAndApplyEntries(Element container) {
        for (Node node : UIParsing.allChildrenOfType(container, (short)1)) {
            Element entry = (Element)node;
            switch (entry.getNodeName()) {
                case "divider": {
                    this.divider();
                    break;
                }
                case "text": {
                    this.text(UIParsing.parseText(entry));
                    break;
                }
                case "button": {
                    Map<String, Element> children = UIParsing.childElements(entry);
                    UIParsing.expectChildren(entry, children, "text");
                    class_2561 text = UIParsing.parseText(children.get("text"));
                    this.button(text, dropdownComponent -> {});
                    break;
                }
                case "checkbox": {
                    Map<String, Element> children = UIParsing.childElements(entry);
                    UIParsing.expectChildren(entry, children, "text", "checked");
                    class_2561 text = UIParsing.parseText(children.get("text"));
                    boolean checked = UIParsing.parseBool(children.get("checked"));
                    this.checkbox(text, checked, aBoolean -> {});
                    break;
                }
                case "nested": {
                    class_5250 text = entry.getAttribute("translate").equals("true") ? class_2561.method_43471((String)entry.getAttribute("name")) : class_2561.method_43470((String)entry.getAttribute("name"));
                    this.nested((class_2561)text, Sizing.content(), dropdownComponent -> dropdownComponent.parseAndApplyEntries(entry));
                }
            }
        }
    }

    public static class EntryList
    extends VerticalFlowLayout {
        protected EntryList(Sizing horizontalSizing) {
            super(horizontalSizing, Sizing.content());
            this.padding(Insets.of(2));
            this.allowOverflow(true);
        }

        @Override
        public void draw(class_4587 matrices, int mouseX, int mouseY, float partialTicks, float delta) {
            Drawer.method_25294((class_4587)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)0x77000000);
            Drawer.drawRectOutline(matrices, this.x, this.y, this.width, this.height, 0x77FFFFFF);
            super.draw(matrices, mouseX, mouseY, partialTicks, delta);
        }
    }

    protected static class Divider
    extends BaseComponent {
        public Divider() {
            this.verticalSizing(Sizing.fixed(1));
            this.horizontalSizing(Sizing.fixed(1));
        }

        @Override
        public void draw(class_4587 matrices, int mouseX, int mouseY, float partialTicks, float delta) {
            Drawer.method_25294((class_4587)matrices, (int)(this.x - 1), (int)(this.y + this.height / 2), (int)(this.x + this.parent.width() - ((Insets)this.parent.padding().get()).horizontal() + 1), (int)(this.y + this.height / 2 + 1), (int)0x77FFFFFF);
        }
    }

    protected static class Button
    extends LabelComponent {
        protected Consumer<DropdownComponent> onClick;

        protected Button(class_2561 text, Consumer<DropdownComponent> onClick) {
            super(text);
            this.onClick = onClick;
            this.margins(Insets.vertical(1));
            this.cursorStyle(CursorStyle.HAND);
        }

        @Override
        public boolean onMouseDown(double mouseX, double mouseY, int button) {
            super.onMouseDown(mouseX, mouseY, button);
            this.onClick.accept((DropdownComponent)this.parent.parent());
            this.playInteractionSound();
            return true;
        }

        @Override
        public void draw(class_4587 matrices, int mouseX, int mouseY, float partialTicks, float delta) {
            if (this.isInBoundingBox(mouseX, mouseY)) {
                Insets margins = (Insets)this.margins.get();
                Drawer.method_25294((class_4587)matrices, (int)(this.x - margins.top()), (int)(this.y - 1), (int)(this.x + this.parent.width() - ((Insets)this.parent.padding().get()).horizontal() + 1), (int)(this.y + this.height + margins.bottom()), (int)0x44FFFFFF);
            }
            super.draw(matrices, mouseX, mouseY, partialTicks, delta);
        }

        protected void playInteractionSound() {
            UISounds.playButtonSound();
        }
    }

    protected static class Checkbox
    extends Button {
        protected boolean state;

        public Checkbox(class_2561 text, boolean state, Consumer<Boolean> onClick) {
            super(text, dropdownComponent -> {});
            this.state = state;
            this.onClick = dropdownComponent -> {
                this.state = !this.state;
                onClick.accept(this.state);
            };
        }

        @Override
        public void draw(class_4587 matrices, int mouseX, int mouseY, float partialTicks, float delta) {
            super.draw(matrices, mouseX, mouseY, partialTicks, delta);
            DropdownComponent.drawIconFromTexture(matrices, this.parent, this.y, this.state ? 16 : 0, 0);
        }

        @Override
        protected int determineHorizontalContentSize(Sizing sizing) {
            return super.determineHorizontalContentSize(sizing) + 17;
        }

        @Override
        protected void playInteractionSound() {
            UISounds.playInteractionSound();
        }
    }

    protected static class NestEntry
    extends LabelComponent {
        private final DropdownComponent child;

        protected NestEntry(class_2561 text, DropdownComponent child) {
            super(text);
            this.child = child;
            this.mouseEnter().subscribe(() -> {
                DropdownComponent dropdown = (DropdownComponent)this.parent.parent();
                child.margins(Insets.top(this.y - dropdown.y));
                dropdown.queue(() -> {
                    dropdown.removeChild(child);
                    dropdown.child(child);
                });
            });
        }

        @Override
        public void draw(class_4587 matrices, int mouseX, int mouseY, float partialTicks, float delta) {
            super.draw(matrices, mouseX, mouseY, partialTicks, delta);
            DropdownComponent.drawIconFromTexture(matrices, this.parent, this.y, 0, 16);
            this.child.requiresHover(!PositionedRectangle.of(this.x, this.y, this.parent.width(), this.height).isInBoundingBox(mouseX, mouseY));
        }

        @Override
        protected int determineHorizontalContentSize(Sizing sizing) {
            return super.determineHorizontalContentSize(sizing) + 17;
        }
    }
}

