/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.Drawer;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.w3c.dom.Element;

public interface Surface {
    public static final Surface PANEL = (matrices, component) -> Drawer.drawPanel(matrices, component.x(), component.y(), component.width(), component.height(), false);
    public static final Surface DARK_PANEL = (matrices, component) -> Drawer.drawPanel(matrices, component.x(), component.y(), component.width(), component.height(), true);
    public static final Surface VANILLA_TRANSLUCENT = (matrices, component) -> Drawer.drawGradientRect(matrices, component.x(), component.y(), component.width(), component.height(), -1072689136, -1072689136, -804253680, -804253680);
    public static final Surface OPTIONS_BACKGROUND = (matrices, component) -> {
        RenderSystem.setShaderTexture((int)0, (class_2960)Drawer.field_22735);
        RenderSystem.setShaderColor((float)0.2509804f, (float)0.2509804f, (float)0.2509804f, (float)1.0f);
        Drawer.method_25290((class_4587)matrices, (int)component.x(), (int)component.y(), (float)0.0f, (float)0.0f, (int)component.width(), (int)component.height(), (int)32, (int)32);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    };
    public static final Surface BLANK = (matrices, component) -> {};

    public static Surface flat(int color) {
        return (matrices, component) -> Drawer.method_25294((class_4587)matrices, (int)component.x(), (int)component.y(), (int)(component.x() + component.width()), (int)(component.y() + component.height()), (int)color);
    }

    public static Surface outline(int color) {
        return (matrices, component) -> Drawer.drawRectOutline(matrices, component.x(), component.y(), component.width(), component.height(), color);
    }

    public static Surface tiled(class_2960 texture, int textureWidth, int textureHeight) {
        return (matrices, component) -> {
            RenderSystem.setShaderTexture((int)0, (class_2960)texture);
            Drawer.method_25290((class_4587)matrices, (int)component.x(), (int)component.y(), (float)0.0f, (float)0.0f, (int)component.width(), (int)component.height(), (int)textureWidth, (int)textureHeight);
        };
    }

    public void draw(class_4587 var1, ParentComponent var2);

    default public Surface and(Surface surface) {
        return (matrices, component) -> {
            this.draw(matrices, component);
            surface.draw(matrices, component);
        };
    }

    public static Surface parse(Element surfaceElement) {
        List<Element> children = UIParsing.allChildrenOfType(surfaceElement, (short)1);
        Surface surface = BLANK;
        for (Element child : children) {
            surface = switch (child.getNodeName()) {
                case "panel" -> surface.and(child.getAttribute("dark").equalsIgnoreCase("true") ? DARK_PANEL : PANEL);
                case "tiled" -> {
                    UIParsing.expectAttributes(child, "texture-width", "texture-height");
                    yield surface.and(Surface.tiled(UIParsing.parseIdentifier(child), UIParsing.parseUnsignedInt(child.getAttributeNode("texture-width")), UIParsing.parseUnsignedInt(child.getAttributeNode("texture-height"))));
                }
                case "options-background" -> surface.and(OPTIONS_BACKGROUND);
                case "vanilla-translucent" -> surface.and(VANILLA_TRANSLUCENT);
                case "outline" -> surface.and(Surface.outline(Color.parseAndPack(child)));
                case "flat" -> surface.and(Surface.flat(Color.parseAndPack(child)));
                default -> throw new UIModelParsingException("Unknown surface type '" + child.getNodeName() + "'");
            };
        }
        return surface;
    }
}

