/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.computercraft.peripheral.ability;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IOwnerAbility;
import site.siredvin.peripheralium.api.peripheral.IPeripheralFunction;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.common.configuration.PeripheraliumConfig;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.computercraft.peripheral.ability.AbilityToolkit;
import site.siredvin.peripheralium.computercraft.peripheral.ability.FuelAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.OperationAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.PeripheralOwnerAbility;
import site.siredvin.peripheralium.computercraft.peripheral.operation.UnconditionalOperations;
import site.siredvin.peripheralium.util.Pair;
import site.siredvin.peripheralium.util.ValidationHelpersKt;
import site.siredvin.peripheralium.util.representation.LuaInterpretation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 82\u00020\u00012\u00020\u0002:\u00018B\u0017\u0012\u0006\u00102\u001a\u000201\u0012\u0006\u0010*\u001a\u00020\u001c\u00a2\u0006\u0004\b6\u00107J\u0015\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\u000f\u001a\u00020\u00052\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0096\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0013J\r\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ'\u0010!\u001a\u00020\u00112\u000e\u0010 \u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001f2\u0006\u0010\b\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b%\u0010$J%\u0010(\u001a\u00020\u00112\u0014\u0010'\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00110&H\u0004\u00a2\u0006\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u001e\u00100\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030-0,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0017\u00102\u001a\u0002018\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105\u00a8\u00069"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/ExperienceAbility;", "Lsite/siredvin/peripheralium/api/peripheral/IOwnerAbility;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "", "amount", "", "adjustStoredXP", "(D)V", "limit", "burnXP", "(D)D", "", "", "", "data", "collectConfiguration", "(Ljava/util/Map;)V", "Ldan200/computercraft/api/lua/MethodResult;", "collectXP", "()Ldan200/computercraft/api/lua/MethodResult;", "other", "", "equals", "(Ljava/lang/Object;)Z", "getOwnerXP", "getStoredXP", "()D", "getStoredXPLua", "", "hashCode", "()I", "", "rawBlockPos", "sendXP", "(Ljava/util/Map;D)Ldan200/computercraft/api/lua/MethodResult;", "sendXPToOwner", "(I)Ldan200/computercraft/api/lua/MethodResult;", "suckOwnerXP", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralFunction;", "function", "withXPTransfer", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralFunction;)Ldan200/computercraft/api/lua/MethodResult;", "interactionRadius", "I", "", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;", "getOperations", "()[Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;", "operations", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "owner", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "getOwner", "()Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "<init>", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;I)V", "Companion", "peripheralium-fabric-1.19.2"})
@SourceDebugExtension(value={"SMAP\nExperienceAbility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExperienceAbility.kt\nsite/siredvin/peripheralium/computercraft/peripheral/ability/ExperienceAbility\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1855#2,2:150\n*S KotlinDebug\n*F\n+ 1 ExperienceAbility.kt\nsite/siredvin/peripheralium/computercraft/peripheral/ability/ExperienceAbility\n*L\n58#1:150,2\n*E\n"})
public final class ExperienceAbility
implements IOwnerAbility,
IPeripheralPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IPeripheralOwner owner;
    private final int interactionRadius;
    @NotNull
    private static final String COLLECTED_XP_AMOUNT = "CollectedXPAmount";

    public ExperienceAbility(@NotNull IPeripheralOwner owner, int interactionRadius) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.owner = owner;
        this.interactionRadius = interactionRadius;
    }

    @NotNull
    public final IPeripheralOwner getOwner() {
        return this.owner;
    }

    @Override
    @NotNull
    public IPeripheralOperation<?>[] getOperations() {
        IPeripheralOperation[] iPeripheralOperationArray = new IPeripheralOperation[]{UnconditionalOperations.XP_TRANSFER};
        return iPeripheralOperationArray;
    }

    @Override
    public void collectConfiguration(@NotNull Map<String, Object> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        data.put("xpToFuelRate", PeripheraliumConfig.INSTANCE.getXpToFuelRate());
    }

    public final double getStoredXP() {
        return this.owner.getDataStorage().method_10574(COLLECTED_XP_AMOUNT);
    }

    public final void adjustStoredXP(double amount) {
        this.owner.getDataStorage().method_10549(COLLECTED_XP_AMOUNT, this.owner.getDataStorage().method_10574(COLLECTED_XP_AMOUNT) + amount);
        this.owner.markDataStorageDirty();
    }

    @NotNull
    protected final MethodResult withXPTransfer(@NotNull IPeripheralFunction<Object, MethodResult> function) throws LuaException {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        OperationAbility operationAbility = this.owner.getAbility(PeripheralOwnerAbility.Companion.getOPERATION());
        Intrinsics.checkNotNull((Object)operationAbility);
        OperationAbility ability = operationAbility;
        return ability.performOperation(UnconditionalOperations.XP_TRANSFER, null, null, function, null, null);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult collectXP() throws LuaException {
        return this.withXPTransfer(arg_0 -> ExperienceAbility.collectXP$lambda$1(this, arg_0));
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult suckOwnerXP(int limit) throws LuaException {
        return this.withXPTransfer(arg_0 -> ExperienceAbility.suckOwnerXP$lambda$2(this, limit, arg_0));
    }

    @LuaFunction(mainThread=true)
    public final double burnXP(double limit) throws LuaException {
        if (limit <= 0.0) {
            throw new LuaException("Incorrect limit");
        }
        FuelAbility<?> fuelAbility = this.owner.getAbility(PeripheralOwnerAbility.Companion.getFUEL());
        if (fuelAbility == null) {
            throw new LuaException("Unsupported operation");
        }
        FuelAbility<?> fuelAbility2 = fuelAbility;
        double burnAmount = Math.min(limit, this.getStoredXP());
        this.adjustStoredXP(-burnAmount);
        fuelAbility2.addFuel((int)(burnAmount / (double)PeripheraliumConfig.INSTANCE.getXpToFuelRate()));
        return burnAmount;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult sendXPToOwner(int limit) throws LuaException {
        return this.withXPTransfer(arg_0 -> ExperienceAbility.sendXPToOwner$lambda$3(limit, this, arg_0));
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult sendXP(@NotNull Map<?, ?> rawBlockPos, double limit) throws LuaException {
        Intrinsics.checkNotNullParameter(rawBlockPos, (String)"rawBlockPos");
        class_2338 pos = this.owner.getPos();
        class_2338 targetPos = LuaInterpretation.INSTANCE.asBlockPos(pos, rawBlockPos);
        return this.withXPTransfer(arg_0 -> ExperienceAbility.sendXP$lambda$4(pos, targetPos, this, limit, arg_0));
    }

    @LuaFunction(value={"getStoredXP"}, mainThread=true)
    public final double getStoredXPLua() {
        return this.getStoredXP();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getOwnerXP() {
        class_1657 class_16572 = this.owner.getOwner();
        if (class_16572 == null) {
            Object[] objectArray = new Object[]{null, "Cannot find owning player"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find owning player\")");
            return methodResult;
        }
        class_1657 player = class_16572;
        MethodResult methodResult = MethodResult.of((Object)player.field_7495);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(player.totalExperience)");
        return methodResult;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ExperienceAbility)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.owner, (Object)((ExperienceAbility)other).owner) && this.interactionRadius == ((ExperienceAbility)other).interactionRadius;
    }

    public int hashCode() {
        int result = this.owner.hashCode();
        result = 31 * result + this.interactionRadius;
        return result;
    }

    @Override
    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral(this);
    }

    @Override
    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral(this, value);
    }

    @Override
    @NotNull
    public List<BoundMethod> getMethods() {
        return IPeripheralPlugin.DefaultImpls.getMethods(this);
    }

    @Override
    @Nullable
    public String getAdditionalType() {
        return IPeripheralPlugin.DefaultImpls.getAdditionalType(this);
    }

    private static final MethodResult collectXP$lambda$1(ExperienceAbility this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        class_1937 class_19372 = this$0.owner.getLevel();
        Intrinsics.checkNotNull((Object)class_19372);
        class_1937 level = class_19372;
        class_2338 pos = this$0.owner.getPos();
        class_238 searchBox = new class_238(pos).method_1014((double)this$0.interactionRadius);
        double oldCount = this$0.getStoredXP();
        List list = level.method_18467(class_1303.class, searchBox);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"level.getEntitiesOfClass\u2026b::class.java, searchBox)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_1303 entity = (class_1303)element$iv;
            boolean bl = false;
            this$0.adjustStoredXP(entity.method_5919());
            entity.method_5650(class_1297.class_5529.field_26998);
        }
        MethodResult methodResult = MethodResult.of((Object)(this$0.getStoredXP() - oldCount));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(getStoredXP() - oldCount)");
        return methodResult;
    }

    private static final MethodResult suckOwnerXP$lambda$2(ExperienceAbility this$0, int $limit, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        class_1657 class_16572 = this$0.owner.getOwner();
        if (class_16572 == null) {
            Object[] objectArray = new Object[]{null, "Cannot find owning player"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find owning player\")");
            return methodResult;
        }
        class_1657 player = class_16572;
        int suckedCount = Math.min(player.field_7495, $limit);
        player.method_7255(-suckedCount);
        this$0.adjustStoredXP(suckedCount);
        MethodResult methodResult = MethodResult.of((Object)suckedCount);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(suckedCount)");
        return methodResult;
    }

    private static final MethodResult sendXPToOwner$lambda$3(int $limit, ExperienceAbility this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        double count = Math.min((double)$limit, this$0.getStoredXP());
        class_1657 class_16572 = this$0.owner.getOwner();
        if (class_16572 == null) {
            Object[] objectArray = new Object[]{null, "Cannot find owning player"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find owning player\")");
            return methodResult;
        }
        class_1657 player = class_16572;
        player.method_7255((int)count);
        this$0.adjustStoredXP(-count);
        MethodResult methodResult = MethodResult.of((Object)count);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(count)");
        return methodResult;
    }

    private static final MethodResult sendXP$lambda$4(class_2338 $pos, class_2338 $targetPos, ExperienceAbility this$0, double $limit, Object it) {
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)$targetPos, (String)"$targetPos");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!ValidationHelpersKt.radiusCorrect($pos, $targetPos, this$0.interactionRadius)) {
            Object[] objectArray = new Object[]{null, "Turtle are too far away"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Turtle are too far away\")");
            return methodResult;
        }
        PeripheralOwnerAbility<ExperienceAbility> peripheralOwnerAbility = PeripheralOwnerAbility.Companion.getEXPERIENCE();
        class_1937 class_19372 = this$0.owner.getLevel();
        Intrinsics.checkNotNull((Object)class_19372);
        Pair<ExperienceAbility, String> abilityExtractResult = AbilityToolkit.INSTANCE.extractAbility(peripheralOwnerAbility, class_19372, $targetPos);
        if (abilityExtractResult.rightPresent()) {
            Object[] objectArray = new Object[]{null, abilityExtractResult.getRight()};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, abilityExtractResult.right)");
            return methodResult;
        }
        double transferAmount = Math.min(this$0.getStoredXP(), $limit);
        this$0.adjustStoredXP(-transferAmount);
        ExperienceAbility experienceAbility = abilityExtractResult.getLeft();
        Intrinsics.checkNotNull((Object)experienceAbility);
        experienceAbility.adjustStoredXP(transferAmount);
        MethodResult methodResult = MethodResult.of((Object)transferAmount);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(transferAmount)");
        return methodResult;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/ExperienceAbility$Companion;", "", "", "COLLECTED_XP_AMOUNT", "Ljava/lang/String;", "<init>", "()V", "peripheralium-fabric-1.19.2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

