/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.computercraft.peripheral.ability;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IOwnerAbility;
import site.siredvin.peripheralium.api.peripheral.IPeripheralCheck;
import site.siredvin.peripheralium.api.peripheral.IPeripheralFunction;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.common.configuration.PeripheraliumConfig;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.computercraft.peripheral.ability.FuelAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.PeripheralOwnerAbility;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u0000 ;2\u00020\u00012\u00020\u0002:\u0002;<B\u0019\u0012\u0006\u00104\u001a\u000203\u0012\b\b\u0002\u00107\u001a\u000206\u00a2\u0006\u0004\b9\u0010:J#\u0010\b\u001a\u00020\u00072\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0011\u001a\u00020\u00102\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u0017\u001a\u00020\u00102\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000e\u00a2\u0006\u0004\b\u0017\u0010\u0012J\u0015\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010\u001d\u001a\u00020\u000b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000e\u00a2\u0006\u0004\b\u001d\u0010\u001eJw\u0010*\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u001f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010 \u001a\u00028\u00002\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010!2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140#2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010%2\u0018\u0010)\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u00010'\u00a2\u0006\u0004\b*\u0010+J\u0019\u0010,\u001a\u00020\u00072\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000e\u00a2\u0006\u0004\b,\u0010-J#\u0010/\u001a\u00020\u00072\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010.\u001a\u00020\u0010H\u0004\u00a2\u0006\u0004\b/\u00100R$\u00101\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u00104\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u00107\u001a\u0002068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108\u00a8\u0006="}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/OperationAbility;", "Lsite/siredvin/peripheralium/api/peripheral/IOwnerAbility;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "", "", "", "data", "", "collectConfiguration", "(Ljava/util/Map;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;", "operation", "", "getCooldown", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;)I", "name", "Ldan200/computercraft/api/lua/MethodResult;", "getCooldownLua", "(Ljava/lang/String;)Ldan200/computercraft/api/lua/MethodResult;", "getCurrentCooldown", "", "getOperations", "()Ljava/util/List;", "hashCode", "()I", "isOnCooldown", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;)Z", "T", "context", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralCheck;", "check", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralFunction;", "method", "Ljava/util/function/Consumer;", "successCallback", "Ljava/util/function/BiConsumer;", "Lsite/siredvin/peripheralium/computercraft/peripheral/ability/OperationAbility$FailReason;", "failCallback", "performOperation", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;Ljava/lang/Object;Lsite/siredvin/peripheralium/api/peripheral/IPeripheralCheck;Lsite/siredvin/peripheralium/api/peripheral/IPeripheralFunction;Ljava/util/function/Consumer;Ljava/util/function/BiConsumer;)Ldan200/computercraft/api/lua/MethodResult;", "registerOperation", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;)V", "cooldown", "setCooldown", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;I)V", "allowedOperations", "Ljava/util/Map;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "owner", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "", "reduceRate", "D", "<init>", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;D)V", "Companion", "FailReason", "peripheralium-fabric-1.19.2"})
public final class OperationAbility
implements IOwnerAbility,
IPeripheralPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IPeripheralOwner owner;
    private final double reduceRate;
    @NotNull
    private final Map<String, IPeripheralOperation<?>> allowedOperations;
    @NotNull
    private static final String COOLDOWNS_TAG = "cooldowns";

    public OperationAbility(@NotNull IPeripheralOwner owner, double reduceRate) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.owner = owner;
        this.reduceRate = reduceRate;
        this.allowedOperations = new HashMap();
    }

    public /* synthetic */ OperationAbility(IPeripheralOwner iPeripheralOwner, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        this(iPeripheralOwner, d);
    }

    protected final void setCooldown(@NotNull IPeripheralOperation<?> operation, int cooldown) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        if (cooldown > 0) {
            class_2487 dataStorage = this.owner.getDataStorage();
            if (!dataStorage.method_10545(COOLDOWNS_TAG)) {
                dataStorage.method_10566(COOLDOWNS_TAG, (class_2520)new class_2487());
            }
            dataStorage.method_10562(COOLDOWNS_TAG).method_10544(operation.settingsName(), Timestamp.valueOf(LocalDateTime.now().plus(cooldown, ChronoUnit.MILLIS)).getTime());
        }
    }

    protected final int getCooldown(@NotNull IPeripheralOperation<?> operation) {
        String operationName;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        class_2487 dataStorage = this.owner.getDataStorage();
        if (!dataStorage.method_10545(COOLDOWNS_TAG)) {
            return 0;
        }
        class_2487 cooldowns = dataStorage.method_10562(COOLDOWNS_TAG);
        if (!cooldowns.method_10545(operationName = operation.settingsName())) {
            return 0;
        }
        long currentTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
        return (int)Math.max(0L, cooldowns.method_10537(operationName) - currentTime);
    }

    public final void registerOperation(@NotNull IPeripheralOperation<?> operation) {
        int initialCooldown;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        this.allowedOperations.put(operation.settingsName(), operation);
        if (PeripheraliumConfig.INSTANCE.isInitialCooldownEnabled() && (initialCooldown = operation.getInitialCooldown()) >= PeripheraliumConfig.INSTANCE.getInitialCooldownSensetiveLevel()) {
            this.setCooldown(operation, initialCooldown);
        }
    }

    @NotNull
    public final <T> MethodResult performOperation(@NotNull IPeripheralOperation<T> operation, T context, @Nullable IPeripheralCheck<T> check, @NotNull IPeripheralFunction<T, MethodResult> method, @Nullable Consumer<T> successCallback, @Nullable BiConsumer<MethodResult, FailReason> failCallback) throws LuaException {
        MethodResult checkResult;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter(method, (String)"method");
        if (this.isOnCooldown(operation)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = null;
            String string = "%s is on cooldown";
            Object[] objectArray2 = new Object[]{operation.settingsName()};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(format, *args)");
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, String.format(\"\u2026peration.settingsName()))");
            MethodResult result = methodResult;
            BiConsumer<MethodResult, FailReason> biConsumer = failCallback;
            if (biConsumer != null) {
                biConsumer.accept(result, FailReason.COOLDOWN);
            }
            return result;
        }
        if (check != null && (checkResult = check.check(context)) != null) {
            BiConsumer<MethodResult, FailReason> biConsumer = failCallback;
            if (biConsumer != null) {
                biConsumer.accept(checkResult, FailReason.CHECK_FAILED);
            }
            return checkResult;
        }
        int cost = operation.getCost(context);
        int cooldown = (int)((double)operation.getCooldown(context) * this.reduceRate);
        FuelAbility<?> fuelAbility = null;
        if (cost != 0) {
            fuelAbility = this.owner.getAbility(PeripheralOwnerAbility.Companion.getFUEL());
            if (fuelAbility == null) {
                Object[] objectArray = new Object[]{null, "This peripheral has no fuel at all"};
                MethodResult methodResult = MethodResult.of((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"This peripheral has no fuel at all\")");
                MethodResult result = methodResult;
                BiConsumer<MethodResult, FailReason> biConsumer = failCallback;
                if (biConsumer != null) {
                    biConsumer.accept(result, FailReason.NOT_ENOUGH_FUEL);
                }
                return result;
            }
            if (!fuelAbility.consumeFuel(cost, false)) {
                Object[] objectArray = new Object[]{null, "Not enough fuel for operation"};
                MethodResult methodResult = MethodResult.of((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Not enough fuel for operation\")");
                MethodResult result = methodResult;
                BiConsumer<MethodResult, FailReason> biConsumer = failCallback;
                if (biConsumer != null) {
                    biConsumer.accept(result, FailReason.NOT_ENOUGH_FUEL);
                }
                return result;
            }
            cooldown = fuelAbility.reduceCooldownAccordingToConsumptionRate(cooldown);
        }
        MethodResult result = method.apply(context);
        Consumer<T> consumer = successCallback;
        if (consumer != null) {
            consumer.accept(context);
        }
        if (cooldown > PeripheraliumConfig.INSTANCE.getCooldownTrasholdLevel()) {
            this.setCooldown(operation, cooldown);
        }
        return result;
    }

    public final int getCurrentCooldown(@NotNull IPeripheralOperation<?> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        return this.getCooldown(operation);
    }

    public final boolean isOnCooldown(@NotNull IPeripheralOperation<?> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        return this.getCurrentCooldown(operation) > 0;
    }

    @Override
    public void collectConfiguration(@NotNull Map<String, Object> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        for (IPeripheralOperation<?> operation : this.allowedOperations.values()) {
            data.put(operation.settingsName(), operation.computerDescription());
        }
    }

    @LuaFunction(value={"getCooldown"}, mainThread=true)
    @NotNull
    public final MethodResult getCooldownLua(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IPeripheralOperation<?> iPeripheralOperation = this.allowedOperations.get(name);
        if (iPeripheralOperation == null) {
            Object[] objectArray = new Object[]{null, "Cannot find this operation"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find this operation\")");
            return methodResult;
        }
        IPeripheralOperation<?> op = iPeripheralOperation;
        MethodResult methodResult = MethodResult.of((Object)this.getCurrentCooldown(op));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(getCurrentCooldown(op))");
        return methodResult;
    }

    @LuaFunction
    @NotNull
    public final List<String> getOperations() {
        return CollectionsKt.toList((Iterable)this.allowedOperations.keySet());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OperationAbility)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.owner, (Object)((OperationAbility)other).owner)) {
            return false;
        }
        return this.reduceRate == ((OperationAbility)other).reduceRate;
    }

    public int hashCode() {
        int result = this.owner.hashCode();
        result = 31 * result + Double.hashCode(this.reduceRate);
        return result;
    }

    @Override
    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral(this);
    }

    @Override
    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral(this, value);
    }

    @Override
    @NotNull
    public List<BoundMethod> getMethods() {
        return IPeripheralPlugin.DefaultImpls.getMethods(this);
    }

    @Override
    @NotNull
    public IPeripheralOperation<?>[] getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations(this);
    }

    @Override
    @Nullable
    public String getAdditionalType() {
        return IPeripheralPlugin.DefaultImpls.getAdditionalType(this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/OperationAbility$Companion;", "", "", "COOLDOWNS_TAG", "Ljava/lang/String;", "<init>", "()V", "peripheralium-fabric-1.19.2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/OperationAbility$FailReason;", "", "<init>", "(Ljava/lang/String;I)V", "COOLDOWN", "NOT_ENOUGH_FUEL", "CHECK_FAILED", "peripheralium-fabric-1.19.2"})
    public static final class FailReason
    extends Enum<FailReason> {
        public static final /* enum */ FailReason COOLDOWN = new FailReason();
        public static final /* enum */ FailReason NOT_ENOUGH_FUEL = new FailReason();
        public static final /* enum */ FailReason CHECK_FAILED = new FailReason();
        private static final /* synthetic */ FailReason[] $VALUES;

        public static FailReason[] values() {
            return (FailReason[])$VALUES.clone();
        }

        public static FailReason valueOf(String value) {
            return Enum.valueOf(FailReason.class, value);
        }

        static {
            $VALUES = failReasonArray = new FailReason[]{FailReason.COOLDOWN, FailReason.NOT_ENOUGH_FUEL, FailReason.CHECK_FAILED};
        }
    }
}

