/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTexture;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.PolyTextures;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiButton
extends GuiElement<GuiButton> {
    public static final int LEFT_CLICK = 0;
    public static final int RIGHT_CLICK = 1;
    public static final int MIDDLE_CLICK = 2;
    private final Map<Integer, Runnable> onClick = new HashMap<Integer, Runnable>();
    private final Map<Integer, Runnable> onPress = new HashMap<Integer, Runnable>();
    private boolean pressed = false;
    private class_3414 pressSound = class_3417.field_15015;
    private class_3414 releaseSound = null;
    private Supplier<Boolean> disabled = () -> false;
    private Supplier<Boolean> toggleState;
    private GuiText label = null;

    public GuiButton(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public GuiButton setLabel(GuiText label) {
        this.label = label;
        return this;
    }

    public GuiText getLabel() {
        return this.label;
    }

    public GuiButton onClick(Runnable onClick) {
        return this.onClick(onClick, 0);
    }

    public GuiButton onClick(Runnable onClick, int mouseButton) {
        this.onClick.put(mouseButton, onClick);
        return this;
    }

    public GuiButton onPress(Runnable onPress) {
        return this.onPress(onPress, 0);
    }

    public GuiButton onPress(Runnable onPress, int mouseButton) {
        this.onPress.put(mouseButton, onPress);
        return this;
    }

    public GuiButton setDisabled(boolean disabled) {
        this.disabled = () -> disabled;
        return this;
    }

    public GuiButton setDisabled(Supplier<Boolean> disabled) {
        this.disabled = disabled;
        return this;
    }

    public GuiButton setToggleMode(@Nullable Supplier<Boolean> toggleState) {
        this.toggleState = toggleState;
        return this;
    }

    public boolean isDisabled() {
        return this.disabled.get();
    }

    public boolean isPressed() {
        return this.pressed && this.hoverTime() > 0;
    }

    public boolean toggleState() {
        return this.toggleState != null && this.toggleState.get() != false;
    }

    public GuiButton setPressSound(class_3414 pressSound) {
        this.pressSound = pressSound;
        return this;
    }

    public GuiButton setReleaseSound(class_3414 releaseSound) {
        this.releaseSound = releaseSound;
        return this;
    }

    public class_3414 getPressSound() {
        return this.pressSound;
    }

    public class_3414 getReleaseSound() {
        return this.releaseSound;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver() || this.isDisabled()) {
            return false;
        }
        Runnable onClick = this.onClick.get(button);
        Runnable onPress = this.onPress.get(button);
        if (onClick == null && onPress == null) {
            return false;
        }
        this.pressed = true;
        this.hoverTime = 1;
        boolean consume = false;
        if (onClick != null) {
            onClick.run();
            consume = true;
        }
        if (onPress != null) {
            consume = true;
        }
        if (this.getPressSound() != null) {
            this.mc().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)this.getPressSound(), (float)1.0f));
        }
        return consume;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button, boolean consumed) {
        consumed = super.mouseReleased(mouseX, mouseY, button, consumed);
        if (!this.pressed) {
            return consumed;
        }
        Runnable onClick = this.onClick.get(button);
        Runnable onPress = this.onPress.get(button);
        if (onClick == null && onPress == null) {
            return consumed;
        }
        this.hoverTime = 1;
        if (!this.isDisabled() && this.isMouseOver()) {
            if (this.pressed && onPress != null) {
                onPress.run();
                consumed = true;
            }
            if (!(this.getReleaseSound() == null || this.toggleState != null && this.toggleState.get().booleanValue())) {
                this.mc().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)this.getReleaseSound(), (float)1.0f));
            }
        }
        this.pressed = false;
        return consumed;
    }

    public static GuiButton vanilla(@NotNull GuiParent<?> parent, @Nullable class_2561 label, Runnable onClick) {
        return GuiButton.vanilla(parent, label).onClick(onClick);
    }

    public static GuiButton vanilla(@NotNull GuiParent<?> parent, @Nullable class_2561 label) {
        GuiButton button = new GuiButton(parent);
        GuiTexture texture = new GuiTexture(button, PolyTextures.getter(() -> button.toggleState() ? "dynamic/button_highlight" : "dynamic/button_vanilla"));
        texture.dynamicTexture();
        GuiRectangle highlight = new GuiRectangle(button).border(() -> button.hoverTime() > 0 ? -1 : 0);
        Constraints.bind(texture, button);
        Constraints.bind(highlight, button);
        if (label != null) {
            button.setLabel(new GuiText(button, label));
            Constraints.bind(button.getLabel(), button, 0.0, 2.0, 0.0, 2.0);
        }
        return button;
    }

    public static GuiButton vanillaAnimated(@NotNull GuiParent<?> parent, class_2561 label, Runnable onPress) {
        return GuiButton.vanillaAnimated(parent, label == null ? null : () -> label, onPress);
    }

    public static GuiButton vanillaAnimated(@NotNull GuiParent<?> parent, @Nullable Supplier<class_2561> label, Runnable onPress) {
        return GuiButton.vanillaAnimated(parent, label).onPress(onPress);
    }

    public static GuiButton vanillaAnimated(@NotNull GuiParent<?> parent, class_2561 label) {
        return GuiButton.vanillaAnimated(parent, label == null ? null : () -> label);
    }

    public static GuiButton vanillaAnimated(@NotNull GuiParent<?> parent, @Nullable Supplier<class_2561> label) {
        GuiButton button = new GuiButton(parent);
        GuiTexture texture = new GuiTexture(button, PolyTextures.getter(() -> button.toggleState() || button.isPressed() ? "dynamic/button_pressed" : "dynamic/button_vanilla"));
        texture.dynamicTexture();
        GuiRectangle highlight = new GuiRectangle(button).border(() -> button.isMouseOver() ? -1 : 0);
        Constraints.bind(texture, button);
        Constraints.bind(highlight, button);
        if (label != null) {
            button.setLabel((GuiText)((GuiText)((GuiText)((GuiText)new GuiText(button, label).constrain(GeoParam.TOP, (Constraint)Constraint.relative(button.get(GeoParam.TOP), () -> button.isPressed() ? -0.5 : 0.5).precise())).constrain(GeoParam.LEFT, (Constraint)Constraint.relative(button.get(GeoParam.LEFT), () -> button.isPressed() ? 1.5 : 2.5).precise())).constrain(GeoParam.WIDTH, Constraint.relative(button.get(GeoParam.WIDTH), -4.0))).constrain(GeoParam.HEIGHT, Constraint.match(button.get(GeoParam.HEIGHT))));
        }
        return button;
    }

    public static GuiButton flatColourButton(@NotNull GuiParent<?> parent, @Nullable Supplier<class_2561> label, Function<Boolean, Integer> buttonColour) {
        return GuiButton.flatColourButton(parent, label, buttonColour, null);
    }

    public static GuiButton flatColourButton(@NotNull GuiParent<?> parent, @Nullable Supplier<class_2561> label, Function<Boolean, Integer> buttonColour, @Nullable Function<Boolean, Integer> borderColour) {
        GuiButton button = new GuiButton(parent);
        GuiRectangle background = new GuiRectangle(button).fill(() -> (Integer)buttonColour.apply(button.isMouseOver() || button.toggleState() || button.isPressed())).border(borderColour == null ? null : () -> (Integer)borderColour.apply(button.isMouseOver() || button.toggleState() || button.isPressed()));
        Constraints.bind(background, button);
        if (label != null) {
            GuiText text = new GuiText(button, label);
            button.setLabel(text);
            Constraints.bind(text, button, 0.0, 2.0, 0.0, 2.0);
        }
        return button;
    }
}

