/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiSlider;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.SliderState;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.helpers.MathUtil;
import net.minecraft.class_2561;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class GuiList<E>
extends GuiElement<GuiList<E>> {
    public boolean enableScissor = true;
    private double yScrollPos = 0.0;
    private double contentHeight = 0.0;
    private double itemSpacing = 1.0;
    private boolean rebuild = true;
    private GuiSlider hiddenBar = null;
    private final List<E> listContent = new ArrayList();
    private final Map<E, GuiElement<?>> elementMap = new HashMap();
    private final LinkedList<GuiElement<?>> visible = new LinkedList();
    private BiFunction<GuiList<E>, E, ? extends GuiElement<?>> displayBuilder = (parent, e) -> {
        GuiText text = new GuiText((GuiParent<?>)parent, () -> class_2561.method_43470((String)String.valueOf(e))).setWrap(true);
        text.constrain(GeoParam.HEIGHT, Constraint.dynamic(() -> this.font().method_44378((class_5348)text.getText(), (int)text.xSize())));
        return text;
    };

    public GuiList(@NotNull GuiParent<?> parent2) {
        super(parent2);
        this.setZStacking(false);
        this.setRenderCull(this.getRectangle());
    }

    public boolean add(E e) {
        this.rebuild = true;
        return this.listContent.add(e);
    }

    public boolean remove(E e) {
        this.rebuild = true;
        return this.listContent.remove(e);
    }

    public List<E> getList() {
        return this.listContent;
    }

    public void markDirty() {
        this.rebuild = true;
    }

    public GuiList<E> setDisplayBuilder(BiFunction<GuiList<E>, E, ? extends GuiElement<?>> displayBuilder) {
        this.displayBuilder = displayBuilder;
        return this;
    }

    public GuiList<E> setItemSpacing(double itemSpacing) {
        this.itemSpacing = itemSpacing;
        return this;
    }

    public SliderState scrollState() {
        return SliderState.forScrollBar(() -> this.yScrollPos, e -> {
            this.yScrollPos = e;
            this.updateVisible();
        }, () -> MathUtil.clamp(this.ySize() / this.contentHeight, 0.0, 1.0));
    }

    public GuiList<E> addHiddenScrollBar() {
        if (this.hiddenBar != null) {
            this.removeChild(this.hiddenBar);
        }
        this.hiddenBar = (GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)new GuiSlider(this, Axis.Y).setSliderState(this.scrollState()).setScrollableElement(this).constrain(GeoParam.TOP, Constraint.match(this.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, Constraint.relative(this.get(GeoParam.RIGHT), -5.0))).constrain(GeoParam.BOTTOM, Constraint.match(this.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, Constraint.match(this.get(GeoParam.RIGHT)));
        return this;
    }

    public GuiList<E> removeHiddenScrollBar() {
        if (this.hiddenBar != null) {
            this.removeChild(this.hiddenBar);
        }
        return this;
    }

    public double hiddenSize() {
        return Math.max(this.contentHeight - this.ySize(), 0.0);
    }

    @Override
    public void tick(double mouseX, double mouseY) {
        if (this.rebuild) {
            this.rebuildElements();
        }
        super.tick(mouseX, mouseY);
    }

    public void rebuildElements() {
        this.elementMap.values().forEach(this::removeChild);
        this.elementMap.clear();
        for (E item : this.listContent) {
            GuiElement<?> next = this.displayBuilder.apply(this, item);
            next.constrain(GeoParam.LEFT, Constraint.match(this.get(GeoParam.LEFT)));
            next.constrain(GeoParam.RIGHT, Constraint.match(this.get(GeoParam.RIGHT)));
            this.removeChild(next);
            this.elementMap.put(item, next);
        }
        this.rebuild = false;
        this.updateVisible();
    }

    public Map<E, GuiElement<?>> getElementMap() {
        return this.elementMap;
    }

    public void scrollTo(E scrollTo) {
        if (this.rebuild) {
            this.rebuild = false;
            this.rebuildElements();
        }
        if (this.elementMap.containsKey(scrollTo)) {
            this.scrollState().setPos(0.0);
            double yMax = this.yMin();
            for (E item : this.getList()) {
                GuiElement<?> e = this.elementMap.get(item);
                if (e == null) continue;
                yMax += e.ySize() + 1.0;
                if (!item.equals(scrollTo)) continue;
                break;
            }
            if (yMax > this.yMax()) {
                double move = yMax - this.yMax();
                this.scrollState().setPos(move / this.hiddenSize());
            }
        }
    }

    private void updateVisible() {
        this.visible.forEach(this::removeChild);
        this.visible.clear();
        this.contentHeight = 0.0;
        if (this.listContent.isEmpty()) {
            return;
        }
        for (GuiElement<?> item : this.elementMap.values()) {
            this.contentHeight += item.ySize() + this.itemSpacing;
        }
        this.contentHeight -= this.itemSpacing;
        double winTop = this.yMin();
        double winBottom = this.yMax();
        double yPos = winTop + this.yScrollPos * -this.hiddenSize();
        for (E item : this.listContent) {
            GuiElement<?> element = this.elementMap.get(item);
            if (element == null) continue;
            double top = yPos;
            double bottom = yPos + element.ySize();
            if (top >= winTop && top <= winBottom || bottom >= winTop && bottom <= winBottom) {
                this.addChild(element);
                this.visible.add(element);
                element.constrain(GeoParam.TOP, Constraint.literal(top));
            }
            yPos = bottom + this.itemSpacing;
        }
    }

    @Override
    public boolean blockMouseOver(GuiElement<?> element, double mouseX, double mouseY) {
        return super.blockMouseOver(element, mouseX, mouseY) || element.isDescendantOf(this) && !this.isMouseOver();
    }

    @Override
    public void render(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        if (this.enableScissor) {
            render.pushScissorRect(this.getRectangle());
        }
        super.render(render, mouseX, mouseY, partialTicks);
        if (this.enableScissor) {
            render.popScissor();
        }
    }
}

