/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Direction;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.minecraft.class_1160;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiProgressIcon
extends GuiElement<GuiProgressIcon>
implements BackgroundRender {
    private Material background = null;
    private Material animated;
    private Supplier<Double> progress = () -> 0.0;
    private Direction direction = Direction.RIGHT;

    public GuiProgressIcon(@NotNull GuiParent<?> parent, Material animated) {
        super(parent);
        this.animated = animated;
    }

    public GuiProgressIcon(@NotNull GuiParent<?> parent, Material background, Material animated) {
        super(parent);
        this.background = background;
        this.animated = animated;
    }

    public GuiProgressIcon(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public GuiProgressIcon setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public GuiProgressIcon setBackground(@Nullable Material background) {
        this.background = background;
        return this;
    }

    public GuiProgressIcon setAnimated(Material animated) {
        this.animated = animated;
        return this;
    }

    public GuiProgressIcon setProgress(double progress) {
        return this.setProgress(() -> progress);
    }

    public GuiProgressIcon setProgress(Supplier<Double> progress) {
        this.progress = progress;
        return this;
    }

    public double getProgress() {
        return this.progress.get();
    }

    @Override
    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        render.pose().method_22903();
        double width = this.direction.getAxis() == Axis.X ? this.xSize() : this.ySize();
        double height = this.direction.getAxis() == Axis.X ? this.ySize() : this.xSize();
        render.pose().method_22904(this.xMin() + this.xSize() / 2.0, this.yMin() + this.ySize() / 2.0, 0.0);
        render.pose().method_22907(class_1160.field_20707.method_23214((float)Direction.RIGHT.rotationTo(this.direction)));
        double halfWidth = width / 2.0;
        double halfHeight = height / 2.0;
        if (this.background != null) {
            render.tex(this.background, -halfWidth, -halfHeight, halfWidth, halfHeight, -1);
        }
        if (this.animated == null) {
            return;
        }
        float progress = (float)this.getProgress();
        render.partialSprite(this.animated.renderType(GuiRender::texColType), -halfWidth, -halfHeight, -halfWidth + width * (double)progress, -halfHeight + height, this.animated.sprite(), 0.0f, 0.0f, progress, 1.0f, -1);
        render.pose().method_22909();
    }
}

