/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiSlider;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.SliderState;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.helpers.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiScrolling
extends GuiElement<GuiScrolling> {
    public boolean enableScissor = true;
    private GuiElement<?> contentElement;
    private double xScrollPos = 0.0;
    private double yScrollPos = 0.0;
    private double contentWidth = 0.0;
    private double contentHeight = 0.0;
    private boolean setup = false;

    public GuiScrolling(@NotNull GuiParent<?> parent) {
        super(parent);
        this.installContainerElement(new ContentElement(this));
    }

    public GuiElement<?> getContentElement() {
        return this.contentElement;
    }

    public void installContainerElement(GuiElement<?> element) {
        if (element.getParent() != this) {
            throw new IllegalStateException("Content element must be a child of the GuiScrollingBase it is being installed in");
        }
        if (this.contentElement != null) {
            this.removeChild(this.contentElement);
        }
        this.setup = true;
        this.contentElement = element;
        this.contentElement.setRenderCull(this.getRectangle());
        this.contentElement.constrain(GeoParam.TOP, Constraint.relative(this.get(GeoParam.TOP), () -> this.yScrollPos * -this.hiddenSize(Axis.Y)));
        this.contentElement.constrain(GeoParam.LEFT, Constraint.relative(this.get(GeoParam.LEFT), () -> this.xScrollPos * -this.hiddenSize(Axis.X)));
        this.contentElement.constrain(GeoParam.WIDTH, Constraint.dynamic(() -> this.contentElement.getChildBounds().xMax() - this.contentElement.xMin()));
        this.contentElement.constrain(GeoParam.HEIGHT, Constraint.dynamic(() -> this.contentElement.getChildBounds().yMax() - this.contentElement.yMin()));
        this.setup = false;
    }

    public SliderState scrollState(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> SliderState.forScrollBar(() -> this.xScrollPos, e -> {
                this.xScrollPos = e;
            }, () -> MathUtil.clamp(this.xSize() / this.contentElement.xSize(), 0.0, 1.0));
            case Axis.Y -> SliderState.forScrollBar(() -> this.yScrollPos, e -> {
                this.yScrollPos = e;
            }, () -> MathUtil.clamp(this.ySize() / this.contentElement.ySize(), 0.0, 1.0));
        };
    }

    public double totalSize(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> this.contentWidth;
            case Axis.Y -> this.contentHeight;
        };
    }

    public double hiddenSize(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> Math.max(this.contentWidth - this.xSize(), 0.0);
            case Axis.Y -> Math.max(this.contentHeight - this.ySize(), 0.0);
        };
    }

    @Override
    public void tick(double mouseX, double mouseY) {
        super.tick(mouseX, mouseY);
        this.contentWidth = this.contentElement.xSize();
        this.contentHeight = this.contentElement.ySize();
    }

    @Override
    public boolean blockMouseOver(GuiElement<?> element, double mouseX, double mouseY) {
        return super.blockMouseOver(element, mouseX, mouseY) || element.isDescendantOf(this.contentElement) && !this.isMouseOver();
    }

    @Override
    protected boolean renderChild(GuiElement<?> child, GuiRender render, double mouseX, double mouseY, float partialTicks) {
        boolean scissor;
        boolean bl = scissor = child == this.contentElement && this.enableScissor;
        if (scissor) {
            render.pushScissorRect(this.getRectangle());
        }
        boolean ret = super.renderChild(child, render, mouseX, mouseY, partialTicks);
        if (scissor) {
            render.popScissor();
        }
        return ret;
    }

    public static Assembly<? extends GuiElement<?>, GuiScrolling> simpleScrollWindow(@NotNull GuiParent<?> parent, boolean verticalScrollBar, boolean horizontalScrollBar) {
        Assembly<GuiRectangle, GuiSlider> bar;
        GuiElement container = new GuiElement(parent);
        GuiRectangle background = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)GuiRectangle.vanillaSlot(container).constrain(GeoParam.TOP, Constraint.match(container.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, Constraint.match(container.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, Constraint.relative(container.get(GeoParam.BOTTOM), horizontalScrollBar ? -10.0 : 0.0))).constrain(GeoParam.RIGHT, Constraint.relative(container.get(GeoParam.RIGHT), verticalScrollBar ? -10.0 : 0.0));
        GuiScrolling scroll = new GuiScrolling(background);
        Constraints.bind(scroll, background, 1.0);
        Assembly result = new Assembly(container, scroll);
        if (verticalScrollBar) {
            bar = GuiSlider.vanillaScrollBar(container, Axis.Y);
            ((GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)bar.container).constrain(GeoParam.TOP, Constraint.match(container.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, Constraint.relative(container.get(GeoParam.BOTTOM), horizontalScrollBar ? -10.0 : 0.0))).constrain(GeoParam.RIGHT, Constraint.match(container.get(GeoParam.RIGHT)))).constrain(GeoParam.WIDTH, Constraint.literal(9.0));
            ((GuiSlider)bar.primary).setSliderState(scroll.scrollState(Axis.Y)).setScrollableElement(scroll);
            result.addParts(new GuiElement[]{bar.container, bar.primary, bar.getPart(0)});
        }
        if (horizontalScrollBar) {
            bar = GuiSlider.vanillaScrollBar(container, Axis.X);
            ((GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)bar.container).constrain(GeoParam.BOTTOM, Constraint.match(container.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, Constraint.match(container.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, Constraint.relative(container.get(GeoParam.RIGHT), verticalScrollBar ? -10.0 : 0.0))).constrain(GeoParam.HEIGHT, Constraint.literal(9.0));
            ((GuiSlider)bar.primary).setSliderState(scroll.scrollState(Axis.X)).setScrollableElement(scroll);
            result.addParts(new GuiElement[]{bar.container, bar.primary, bar.getPart(0)});
        }
        return result;
    }

    private class ContentElement
    extends GuiElement<ContentElement> {
        public ContentElement(GuiParent<?> parent) {
            super(parent);
        }

        @Override
        public ContentElement constrain(GeoParam param, @Nullable Constraint constraint) {
            if (!(GuiScrolling.this.setup || param != GeoParam.TOP && param != GeoParam.LEFT)) {
                throw new IllegalStateException("Can not override TOP or LEFT constraints on content element, These are used to control the scrolling behavior!");
            }
            return (ContentElement)super.constrain(param, constraint);
        }
    }
}

